/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class SimpleValidator<F>
implements Validator {
    private static final String MIN_LENGTH_MESSAGE_KEY = "validation.minLength";
    final Class<F> genericType = GenericTypeResolver.resolveTypeArgument(this.getClass(), SimpleValidator.class);
    @Autowired
    @Qualifier(value="sessionManager")
    protected SessionManager sessionManager;
    @Autowired
    protected ExpressionValidator expressionValidator;
    @Autowired
    protected MessageSource messageSource;

    public boolean supports(Class<?> clazz) {
        return this.genericType.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.genericType.isAssignableFrom(target.getClass())) {
            Object form = target;
            this.validateForm(form, errors);
        }
    }

    public abstract void validateForm(F var1, Errors var2);

    protected CollectSurvey getActiveSurvey() {
        return this.sessionManager.getActiveSurvey();
    }

    protected boolean validateRequiredFields(Errors errors, String ... fields) {
        boolean result = true;
        for (String field : fields) {
            result &= this.validateRequiredField(errors, field);
        }
        return result;
    }

    protected boolean validateRequiredField(Errors errors, String field) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object value = errors.getFieldValue(field);
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            this.rejectRequiredFields(errors, field);
            return false;
        }
        return true;
    }

    protected void rejectRequiredFields(Errors errors, String ... fields) {
        String errorCode = "validation.required_field";
        String defaultMessage = this.messageSource.getMessage(errorCode, null, Locale.ENGLISH);
        for (String field : fields) {
            errors.rejectValue(field, errorCode, defaultMessage);
        }
    }

    protected boolean validateBooleanExpression(Errors errors, NodeDefinition contextNodeDef, NodeDefinition thisNodeDef, String field, String expression) {
        return this.validateExpression(errors, contextNodeDef, thisNodeDef, field, expression, ExpressionValidator.ExpressionType.BOOLEAN);
    }

    protected boolean validateValueExpression(Errors errors, NodeDefinition contextNodeDef, NodeDefinition thisNodeDef, String field, String expression) {
        return this.validateExpression(errors, contextNodeDef, thisNodeDef, field, expression, ExpressionValidator.ExpressionType.VALUE);
    }

    protected boolean validateExpression(Errors errors, NodeDefinition contextNodeDef, NodeDefinition thisNodeDef, String field, String expression, ExpressionValidator.ExpressionType type) {
        ExpressionValidator.ExpressionValidationResult result = this.expressionValidator.validateExpression(type, contextNodeDef, thisNodeDef, expression);
        if (result.isError()) {
            String errorCode = "validation.invalid_expression";
            String validationMessage = StringUtils.defaultString((String)result.getDetailedMessage(), (String)result.getMessage());
            Object[] errorMessageArgs = new String[]{validationMessage};
            String defaultMessage = this.messageSource.getMessage(errorCode, errorMessageArgs, Locale.ENGLISH);
            errors.rejectValue(field, errorCode, defaultMessage);
        }
        return result.isOk();
    }

    protected boolean validateInternalName(Errors errors, String fieldName) {
        return this.validateInternalName(errors, fieldName, "generic.validation.invalid_internal_name");
    }

    protected boolean validateInternalName(Errors errors, String fieldName, String errorMessageKey) {
        return this.validateRegEx(errors, fieldName, "[a-z][a-z0-9_]*", errorMessageKey);
    }

    protected boolean validateRegEx(Errors errors, String fieldName, String regex, String errorMessageKey) {
        return this.validateRegEx(errors, fieldName, Pattern.compile(regex), errorMessageKey);
    }

    protected boolean validateRegEx(Errors errors, String fieldName, Pattern pattern, String errorMessageKey) {
        Matcher matcher;
        Object value = errors.getFieldValue(fieldName);
        if (value != null && value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value)) && !(matcher = pattern.matcher((String)value)).matches()) {
            errors.rejectValue(fieldName, errorMessageKey);
            return false;
        }
        return true;
    }

    protected boolean validateMinLength(Errors errors, String fieldName, int length) {
        String strVal;
        Object value = errors.getFieldValue(fieldName);
        if (value != null && value instanceof String && (strVal = (String)value).trim().length() < length) {
            errors.rejectValue(fieldName, MIN_LENGTH_MESSAGE_KEY, (Object[])new Integer[]{length}, MIN_LENGTH_MESSAGE_KEY);
            return false;
        }
        return true;
    }

    protected void rejectDuplicateValue(Errors errors, String field, Object ... args) {
        this.rejectDuplicateValues(errors, Arrays.asList(field), args);
    }

    protected void rejectDuplicateValues(Errors errors, List<String> fields, Object ... args) {
        String errorCode = "validation.duplicate_value";
        for (String field : fields) {
            errors.rejectValue(field, errorCode, args, this.messageSource.getMessage(errorCode, args, Locale.ENGLISH));
        }
    }

    protected static class ErrorsHelper {
        private Errors errors;

        public ErrorsHelper(Errors errors) {
            this.errors = errors;
        }

        public String getStringValue(String field) {
            Object value = this.errors.getFieldValue(field);
            return value == null ? null : value.toString();
        }
    }
}

