/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager.speciesimport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.io.exception.ParsingException;
import org.openforis.collect.io.metadata.parsing.CSVReferenceDataImportReader;
import org.openforis.collect.io.metadata.parsing.CSVReferenceDataLineParser;
import org.openforis.collect.io.metadata.parsing.DataImportReader;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.io.metadata.species.SpeciesFileColumn;
import org.openforis.collect.io.parsing.CSVFileOptions;
import org.openforis.collect.manager.speciesimport.SpeciesLine;
import org.openforis.commons.io.csv.CsvLine;
import org.openforis.idm.metamodel.Languages;
import org.openforis.idm.model.species.Taxon;

public class SpeciesCSVReader
extends CSVReferenceDataImportReader<SpeciesLine> {
    public SpeciesCSVReader(File file, CSVFileOptions csvFileOptions) throws IOException, ParsingException {
        super(file, csvFileOptions);
    }

    protected boolean isInfoAttribute(String col) {
        HashSet<String> predefinedColumnNames = new HashSet<String>();
        for (SpeciesFileColumn column : SpeciesFileColumn.values()) {
            predefinedColumnNames.add(column.getColumnName());
        }
        return !predefinedColumnNames.contains(col) && !Languages.getCodes((Languages.Standard)Languages.Standard.ISO_639_3).contains(col);
    }

    protected SpeciesCSVLineParser createLineParserInstance() {
        SpeciesCSVLineParser lineParser = SpeciesCSVLineParser.createInstance(this, this.currentCSVLine, this.infoColumnNames);
        return lineParser;
    }

    public boolean validateAllFile() throws ParsingException {
        Validator validator = new Validator();
        validator.validate();
        return true;
    }

    public List<String> getLanguageColumnNames() {
        List columnNames = this.getColumnNames();
        ArrayList<String> result = new ArrayList<String>();
        for (String colName : columnNames) {
            String colNameAdapted = StringUtils.trimToEmpty((String)colName).toLowerCase(Locale.ENGLISH);
            if (!Languages.exists((Languages.Standard)Languages.Standard.ISO_639_3, (String)colNameAdapted)) continue;
            result.add(colName);
        }
        return result;
    }

    static class VernacularLanguagesMap {
        private static final String LATIN_LANGUAGE_CODE = "lat";
        private Map<String, List<String>> langCodeToVernacularNames = new HashMap<String, List<String>>();

        public Map<String, List<String>> getMap() {
            return this.langCodeToVernacularNames;
        }

        public void put(String langCode, List<String> vernacularNames) {
            this.langCodeToVernacularNames.put(langCode, vernacularNames);
        }

        public void addSynonyms(List<String> synonyms) {
            List<String> oldSynonyms = this.langCodeToVernacularNames.get(LATIN_LANGUAGE_CODE);
            if (oldSynonyms == null) {
                this.langCodeToVernacularNames.put(LATIN_LANGUAGE_CODE, synonyms);
            } else {
                oldSynonyms.addAll(synonyms);
            }
        }
    }

    class Validator {
        Validator() {
        }

        public void validate() throws ParsingException {
            this.validateHeaders();
        }

        protected void validateHeaders() throws ParsingException {
            Object[] requiredColumnNames;
            List colNames = SpeciesCSVReader.this.getColumnNames();
            for (String string : requiredColumnNames = SpeciesFileColumn.REQUIRED_COLUMN_NAMES) {
                if (colNames.contains(string)) continue;
                ParsingError error = new ParsingError(ParsingError.ErrorType.MISSING_REQUIRED_COLUMNS, 1L, (String)null);
                String messageArg = StringUtils.join((Object[])requiredColumnNames, (String)", ");
                error.setMessageArgs(new String[]{messageArg});
                throw new ParsingException(error);
            }
        }
    }

    private static class ScientificNameParseResult {
        private String genus;
        private String speciesName;
        private String canonicalScientificName;
        private Taxon.TaxonRank rank;

        public ScientificNameParseResult(String genus, String speciesName, String canonicalScientificName, Taxon.TaxonRank rank) {
            this.genus = genus;
            this.speciesName = speciesName;
            this.canonicalScientificName = canonicalScientificName;
            this.rank = rank;
        }

        public String getGenus() {
            return this.genus;
        }

        public String getSpeciesName() {
            return this.speciesName;
        }

        public String getCanonicalScientificName() {
            return this.canonicalScientificName;
        }

        public Taxon.TaxonRank getRank() {
            return this.rank;
        }
    }

    public static class SpeciesCSVLineParser
    extends CSVReferenceDataLineParser<SpeciesLine> {
        public static final String GENUS_SUFFIX = "sp.";
        private static final String GENUS_PATTERN_STR = "[A-Z][a-z]+";
        private static final String SPECIES_NAME_PATTERN_STR = "[a-z]+\\-?[a-z]+";
        private static final String DEFAULT_HYBRID_FORMULA = "\u00d7";
        private static final Pattern ONLY_GENUS_PATTERN = Pattern.compile("^([A-Z][a-z]+)(\\s+(spp|sp)\\.?)?$");
        private static final String CAPITALIZED_WORD_PATTERN_STR = "[A-Z][a-z]+";
        private static final String CULTIVAR_NAME_PATTERN_STR = "'[A-Z][a-z]+(\\s+[A-Z][a-z]+)*'";
        private static final String SUBSPECIES_NAME_PATTERN_STR = "[a-z]+|[a-z]+\\-[a-z]+";
        private static final Pattern SPECIES_AND_ABOVE_PATTERN = Pattern.compile("^([A-Z][a-z]+)\\s+([a-z]+\\-?[a-z]+)(\\s+(ssp|subsp|var|f)\\.?\\s+([a-z]+|[a-z]+\\-[a-z]+))?$");
        private static final Pattern CULTIVAR_SPECIES_PATTERN = Pattern.compile("^([A-Z][a-z]+)\\s+([a-z]+\\-?[a-z]+)\\s+('[A-Z][a-z]+(\\s+[A-Z][a-z]+)*')$");
        private static final Pattern HYBRID_SPECIES_PATTERN_1 = Pattern.compile("^([A-Z][a-z]+)\\s+([x|X|\u00d7])\\s+([a-z]+\\-?[a-z]+)$");
        private static final Pattern HYBRID_SPECIES_PATTERN_2 = Pattern.compile("^([A-Z][a-z]+)\\s+\u00d7([a-z]+\\-?[a-z]+)$");
        private static final Pattern HYBRID_SPECIES_PATTERN_3 = Pattern.compile("^([A-Z][a-z]+)\\s+([a-z]+\\-?[a-z]+)\\s+([x|X|\u00d7])\\s+(([A-Z]\\.)|([A-Z][a-z]+))?\\s*([a-z]+\\-?[a-z]+)$");
        private static final String VERNACULAR_NAME_TRIM_EXPRESSION = "^\\s+|\\s+$|;+$|\\.+$";
        private static final String SYNONYM_COL_NAME = "synonyms";
        private static final String SYNONYM_SPLIT_EXPRESSION = "((syn|Syn)(\\.\\:|\\.|\\:|\\s))";
        private static final Pattern SYNONYM_PATTERN = Pattern.compile("^((syn|Syn)(\\.\\:|\\.|\\:|\\s))", 2);
        private static final String DEFAULT_VERNACULAR_NAMES_SEPARATOR = ",";
        private static final String OTHER_VERNACULAR_NAMES_SEPARATOR_EXPRESSION = "/";
        public static final String UNEXPECTED_SYNONYM_MESSAGE_KEY = "survey.taxonomy.import_data.error.unexpected_synonym";

        SpeciesCSVLineParser(SpeciesCSVReader reader, CsvLine line, List<String> infoColumnNames) {
            super((DataImportReader)reader, line, infoColumnNames);
        }

        public static SpeciesCSVLineParser createInstance(SpeciesCSVReader reader, CsvLine line, List<String> infoColumnNames) {
            return new SpeciesCSVLineParser(reader, line, infoColumnNames);
        }

        public SpeciesLine parse() throws ParsingException {
            SpeciesLine line = (SpeciesLine)super.parse();
            line.setTaxonId(this.extractTaxonId(false));
            line.setCode(this.extractCode(true));
            line.setFamilyName(this.extractFamilyName());
            line.setLanguageToVernacularNames(this.extractLanguageToVernacularNames());
            String rawScientificName = this.extractRawScientificName();
            rawScientificName = StringUtils.trimToNull((String)rawScientificName);
            if (rawScientificName == null) {
                line.setCanonicalScientificName(line.getFamilyName());
                line.setRank(Taxon.TaxonRank.FAMILY);
                return line;
            }
            ScientificNameParseResult scientificNameParseResult = this.parseScientificName(rawScientificName);
            line.setGenus(scientificNameParseResult.getGenus());
            line.setSpeciesName(scientificNameParseResult.getSpeciesName());
            line.setCanonicalScientificName(scientificNameParseResult.getCanonicalScientificName());
            line.setRank(scientificNameParseResult.getRank());
            return line;
        }

        private ScientificNameParseResult parseScientificName(String rawScientificName) throws ParsingException {
            Matcher matcher = ONLY_GENUS_PATTERN.matcher(rawScientificName);
            if (matcher.matches()) {
                String genus = matcher.group(1);
                return new ScientificNameParseResult(genus, null, genus + " " + GENUS_SUFFIX, Taxon.TaxonRank.GENUS);
            }
            matcher = SPECIES_AND_ABOVE_PATTERN.matcher(rawScientificName);
            if (matcher.matches()) {
                Taxon.TaxonRank rank;
                String speciesName;
                String genus = matcher.group(1);
                String species = matcher.group(2);
                String canonicalScientificName = speciesName = genus + " " + species;
                String discriminator = matcher.group(4);
                if (StringUtils.isBlank((CharSequence)discriminator)) {
                    rank = Taxon.TaxonRank.SPECIES;
                } else {
                    String normalizedDiscriminator;
                    if ("var".equals(discriminator)) {
                        rank = Taxon.TaxonRank.VARIETY;
                        normalizedDiscriminator = "var.";
                    } else if ("subsp".equals(discriminator) || "ssp".equals(discriminator)) {
                        rank = Taxon.TaxonRank.SUBSPECIES;
                        normalizedDiscriminator = "subsp.";
                    } else if ("f".equals(discriminator)) {
                        rank = Taxon.TaxonRank.FORM;
                        normalizedDiscriminator = "f.";
                    } else {
                        throw new IllegalArgumentException(String.format("Invalid discriminator %s found in scientific name %s", discriminator, rawScientificName));
                    }
                    canonicalScientificName = canonicalScientificName + " " + normalizedDiscriminator + " " + matcher.group(5);
                }
                return new ScientificNameParseResult(genus, speciesName, canonicalScientificName, rank);
            }
            matcher = HYBRID_SPECIES_PATTERN_1.matcher(rawScientificName);
            if (matcher.find()) {
                String genus = matcher.group(1);
                String species = matcher.group(3);
                String hybridFormula = matcher.group(2).toLowerCase(Locale.ENGLISH);
                String speciesName = genus + " " + hybridFormula + " " + species;
                return new ScientificNameParseResult(genus, speciesName, speciesName, Taxon.TaxonRank.SPECIES);
            }
            matcher = HYBRID_SPECIES_PATTERN_2.matcher(rawScientificName);
            if (matcher.find()) {
                String genus = matcher.group(1);
                String species = matcher.group(2);
                String speciesName = genus + " " + DEFAULT_HYBRID_FORMULA + species;
                return new ScientificNameParseResult(genus, speciesName, speciesName, Taxon.TaxonRank.SPECIES);
            }
            matcher = HYBRID_SPECIES_PATTERN_3.matcher(rawScientificName);
            if (matcher.find()) {
                String genus = matcher.group(1);
                String species = matcher.group(2);
                String hybridFormula = matcher.group(3).toLowerCase(Locale.ENGLISH);
                String secondaryGenus = matcher.group(6);
                String secondarySpecies = matcher.group(7);
                String speciesName = genus + " " + species + " " + hybridFormula + " " + (secondaryGenus == null ? "" : secondaryGenus + " ") + secondarySpecies;
                return new ScientificNameParseResult(genus, speciesName, speciesName, Taxon.TaxonRank.SPECIES);
            }
            matcher = CULTIVAR_SPECIES_PATTERN.matcher(rawScientificName);
            if (matcher.find()) {
                String genus = matcher.group(1);
                String species = matcher.group(2);
                String cultivarName = matcher.group(3);
                String speciesName = genus + " " + species;
                String canonicalScientificName = speciesName + " " + cultivarName;
                return new ScientificNameParseResult(genus, speciesName, canonicalScientificName, Taxon.TaxonRank.CULTIVAR);
            }
            ParsingError error = this.createFieldParsingError(SpeciesFileColumn.SCIENTIFIC_NAME, "scientific name", rawScientificName);
            throw new ParsingException(error);
        }

        protected Integer extractTaxonId(boolean required) throws ParsingException {
            return (Integer)this.getColumnValue(SpeciesFileColumn.NO.getColumnName(), required, Integer.class);
        }

        protected String extractCode(boolean required) throws ParsingException {
            return (String)this.getColumnValue(SpeciesFileColumn.CODE.getColumnName(), required, String.class);
        }

        protected String extractFamilyName() throws ParsingException {
            return (String)this.getColumnValue(SpeciesFileColumn.FAMILY.getColumnName(), true, String.class);
        }

        protected String extractRawScientificName() throws ParsingException {
            return (String)this.getColumnValue(SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), false, String.class);
        }

        protected Map<String, List<String>> extractLanguageToVernacularNames() throws ParsingException {
            VernacularLanguagesMap result = this.extractVernacularNamesFromColumns();
            return result.getMap();
        }

        protected VernacularLanguagesMap extractVernacularNamesFromColumns() throws ParsingException {
            VernacularLanguagesMap result = new VernacularLanguagesMap();
            List<String> languageColumnNames = ((SpeciesCSVReader)this.getReader()).getLanguageColumnNames();
            for (String langCode : languageColumnNames) {
                List<String> vernacularNames = this.extractVernacularNames(langCode);
                result.put(langCode, vernacularNames);
            }
            List<String> synonyms = this.extractVernacularNames(SpeciesFileColumn.SYNONYMS.getColumnName());
            result.addSynonyms(synonyms);
            return result;
        }

        protected List<String> extractVernacularNames(String colName) throws ParsingException {
            String[] split;
            String colValue = StringUtils.normalizeSpace((String)((String)this.getColumnValue(colName, false, String.class)));
            if (StringUtils.isBlank((CharSequence)colValue)) {
                return new ArrayList<String>();
            }
            ArrayList<String> result = new ArrayList<String>();
            String normalized = colValue.replaceAll(OTHER_VERNACULAR_NAMES_SEPARATOR_EXPRESSION, DEFAULT_VERNACULAR_NAMES_SEPARATOR);
            for (String splitPart : split = StringUtils.split((String)normalized, (String)DEFAULT_VERNACULAR_NAMES_SEPARATOR)) {
                String trimmedPart = this.extractVernacularName(colName, splitPart);
                if (trimmedPart == null) continue;
                result.add(trimmedPart);
            }
            return result;
        }

        private String extractVernacularName(String colName, String splitPart) throws ParsingException {
            String trimmed = splitPart.replaceAll(VERNACULAR_NAME_TRIM_EXPRESSION, "");
            if (trimmed.length() > 0) {
                Matcher matcher = SYNONYM_PATTERN.matcher(trimmed);
                if (matcher.find()) {
                    if (SYNONYM_COL_NAME.equals(colName)) {
                        matcher.replaceAll("");
                    } else {
                        ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, this.lineNumber, colName, UNEXPECTED_SYNONYM_MESSAGE_KEY);
                        throw new ParsingException(error);
                    }
                }
                return trimmed;
            }
            return null;
        }

        protected ParsingError createFieldParsingError(SpeciesFileColumn column, String fieldName, String value) {
            ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, this.lineNumber, column.getColumnName(), "Error parsing " + fieldName + " from " + value);
            return error;
        }

        protected void throwEmptyColumnParsingException(SpeciesFileColumn column) throws ParsingException {
            ParsingError error = new ParsingError(ParsingError.ErrorType.EMPTY, this.lineNumber, column.getColumnName());
            throw new ParsingException(error);
        }
    }
}

