/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.openforis.collect.command.AddAttributeCommand;
import org.openforis.collect.command.AddEntityCommand;
import org.openforis.collect.command.Command;
import org.openforis.collect.command.CommandDispatcher;
import org.openforis.collect.command.CreateRecordCommand;
import org.openforis.collect.command.CreateRecordPreviewCommand;
import org.openforis.collect.command.DeleteAttributeCommand;
import org.openforis.collect.command.DeleteEntityCommand;
import org.openforis.collect.command.DeleteRecordCommand;
import org.openforis.collect.command.RecordCommand;
import org.openforis.collect.command.UpdateAttributeCommand;
import org.openforis.collect.command.UpdateBooleanAttributeCommand;
import org.openforis.collect.command.UpdateCodeAttributeCommand;
import org.openforis.collect.command.UpdateCoordinateAttributeCommand;
import org.openforis.collect.command.UpdateDateAttributeCommand;
import org.openforis.collect.command.UpdateFileAttributeCommand;
import org.openforis.collect.command.UpdateIntegerAttributeCommand;
import org.openforis.collect.command.UpdateRealAttributeCommand;
import org.openforis.collect.command.UpdateTaxonAttributeCommand;
import org.openforis.collect.command.UpdateTextAttributeCommand;
import org.openforis.collect.command.UpdateTimeAttributeCommand;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.manager.RecordFileManager;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SessionRecordFileManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Files;
import org.openforis.collect.web.manager.SessionRecordProvider;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.web.Response;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.model.BooleanValue;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.Date;
import org.openforis.idm.model.FileAttribute;
import org.openforis.idm.model.IntegerValue;
import org.openforis.idm.model.RealValue;
import org.openforis.idm.model.TaxonOccurrence;
import org.openforis.idm.model.TextValue;
import org.openforis.idm.model.Time;
import org.openforis.idm.model.Value;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/command"})
public class CommandController {
    @Autowired
    private transient SurveyManager surveyManager;
    @Autowired
    private transient RecordFileManager recordFileManager;
    @Autowired
    private SessionRecordProvider sessionRecordProvider;
    @Autowired
    private SessionRecordFileManager sessionRecordFileManager;
    @Autowired
    private transient CommandDispatcher commandDispatcher;
    @Autowired
    private transient SessionManager sessionManager;
    @Autowired
    private transient AppWS appWS;

    @RequestMapping(value={"record"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response createRecord(@RequestBody CreateRecordCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record_preview"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public List<RecordEventView> createRecordPreview(@RequestBody CreateRecordPreviewCommand command) {
        return this.submitCommandSync((Command)command);
    }

    @RequestMapping(value={"record"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response deleteRecord(@RequestBody DeleteRecordCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attribute/new"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response addAttribute(@RequestBody AddAttributeCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attributes"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response addOrUpdateAttributes(@RequestBody UpdateAttributesCommandWrapper commandsWrapper) {
        List<UpdateAttributeCommandWrapper> commands = commandsWrapper.getCommands();
        if (!commands.isEmpty()) {
            CollectSurvey survey = this.getSurvey((RecordCommand)commands.get(0));
            commands.forEach(c -> {
                UpdateAttributeCommand<Value> command = c.toCommand(survey);
                this.submitCommand((Command)command);
            });
        }
        return new Response();
    }

    @RequestMapping(value={"record/attribute"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object updateAttribute(@RequestBody UpdateAttributeCommandWrapper commandWrapper) {
        CollectSurvey survey = this.getSurvey((RecordCommand)commandWrapper);
        UpdateAttributeCommand<Value> command = commandWrapper.toCommand(survey);
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attribute/file"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @Transactional
    @ResponseBody
    public Response updateAttributeFile(@RequestParam(value="command") String commandWrapperJsonString, @RequestParam(value="file") MultipartFile multipartFile) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        UpdateAttributeCommandWrapper commandWrapper = (UpdateAttributeCommandWrapper)((Object)objectMapper.readValue(commandWrapperJsonString, UpdateAttributeCommandWrapper.class));
        CollectSurvey survey = this.getSurvey((RecordCommand)commandWrapper);
        UpdateAttributeCommand<Value> command = commandWrapper.toCommand(survey);
        FileAttributeDefinition attrDef = (FileAttributeDefinition)survey.getSchema().getDefinitionById(command.getNodeDefId());
        if (multipartFile.getSize() <= (long)attrDef.getMaxSize().intValue()) {
            org.openforis.idm.model.File value;
            CollectRecord record = this.sessionRecordProvider.provide(survey, command.getRecordId(), CollectRecord.Step.fromRecordStep((RecordStep)command.getRecordStep()));
            FileAttribute fileAttr = (FileAttribute)record.findNodeByPath(command.getNodePath());
            if (record.isPreview()) {
                File tempFile = this.sessionRecordFileManager.saveToTempFile(multipartFile.getInputStream(), multipartFile.getOriginalFilename(), record, fileAttr.getInternalId().intValue());
                value = new org.openforis.idm.model.File(tempFile.getName(), Long.valueOf(multipartFile.getSize()));
            } else {
                File tempFile = Files.writeToTempFile((InputStream)multipartFile.getInputStream(), (String)multipartFile.getOriginalFilename(), (String)"ofc_data_entry_file");
                value = this.recordFileManager.moveFileIntoRepository(fileAttr, tempFile, multipartFile.getOriginalFilename(), false);
            }
            command.setValue((Value)value);
            return this.submitCommand((Command)command);
        }
        throw new IllegalArgumentException(String.format("File size (%d) exceeds expected maximum size: %d", multipartFile.getSize(), attrDef.getMaxSize()));
    }

    @RequestMapping(value={"record/attribute/file/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object deleteAttributeFile(@RequestBody DeleteAttributeCommand command) throws Exception {
        CollectSurvey survey = this.getSurvey((RecordCommand)command);
        CollectRecord record = this.sessionRecordProvider.provide(survey, command.getRecordId(), CollectRecord.Step.fromRecordStep((RecordStep)command.getRecordStep()));
        FileAttribute fileAttr = (FileAttribute)record.findNodeByPath(command.getNodePath());
        if (record.isPreview()) {
            this.sessionRecordFileManager.deleteTempFile(record, fileAttr.getInternalId().intValue());
        } else {
            this.recordFileManager.deleteRepositoryFile(fileAttr);
        }
        UpdateFileAttributeCommand updateAttributeCommand = new UpdateFileAttributeCommand();
        PropertyUtils.copyProperties((Object)updateAttributeCommand, (Object)command);
        updateAttributeCommand.setValue(null);
        return this.submitCommand((Command)updateAttributeCommand);
    }

    @RequestMapping(value={"record/attribute/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object deleteAttribute(@RequestBody DeleteAttributeCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/entity"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object addEntity(@RequestBody AddEntityCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/entity/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object deleteEntity(@RequestBody DeleteEntityCommand command) {
        return this.submitCommand((Command)command);
    }

    private Response submitCommand(Command command) {
        if (command instanceof RecordCommand) {
            ((RecordCommand)command).setUsername(this.sessionManager.getLoggedUsername());
        }
        this.commandDispatcher.submit(command, new EventListener(){

            public void onEvent(RecordEvent event) {
                CommandController.this.appWS.sendMessage(new AppWS.RecordEventMessage(new RecordEventView(event)));
            }
        });
        return new Response();
    }

    private List<RecordEventView> submitCommandSync(Command command) {
        if (command instanceof RecordCommand) {
            ((RecordCommand)command).setUsername(this.sessionManager.getLoggedUsername());
        }
        List events = this.commandDispatcher.submitSync(command);
        ArrayList<RecordEventView> result = new ArrayList<RecordEventView>(events.size());
        for (RecordEvent event : events) {
            result.add(new RecordEventView(event));
        }
        return result;
    }

    private CollectSurvey getSurvey(RecordCommand command) {
        return this.surveyManager.getOrLoadSurveyById(command.getSurveyId());
    }

    static class UpdateAttributeCommandWrapper
    extends UpdateAttributeCommand<Value> {
        private static final long serialVersionUID = 1L;
        AttributeType attributeType;
        NumericAttributeDefinition.Type numericType;
        Map<String, Object> valueByField;

        UpdateAttributeCommandWrapper() {
        }

        Value extractValue(CollectSurvey survey) {
            if (this.valueByField == null) {
                return null;
            }
            switch (this.attributeType) {
                case BOOLEAN: {
                    return new BooleanValue((Boolean)this.valueByField.get("value"));
                }
                case CODE: {
                    return new Code((String)this.valueByField.get("code"), (String)this.valueByField.get("qualifier"));
                }
                case COORDINATE: {
                    Number xValue = (Number)this.valueByField.get("x");
                    Number yValue = (Number)this.valueByField.get("y");
                    Number altitudeValue = (Number)this.valueByField.get("altitude");
                    Number accuracyValue = (Number)this.valueByField.get("accuracy");
                    String srsId = (String)this.valueByField.get("srs");
                    Double x = xValue == null ? null : Double.valueOf(xValue.doubleValue());
                    Double y = yValue == null ? null : Double.valueOf(yValue.doubleValue());
                    Double altitude = altitudeValue == null ? null : Double.valueOf(altitudeValue.doubleValue());
                    Double accuracy = accuracyValue == null ? null : Double.valueOf(accuracyValue.doubleValue());
                    return new Coordinate(x, y, srsId, altitude, accuracy);
                }
                case DATE: {
                    return new Date((Integer)this.valueByField.get("year"), (Integer)this.valueByField.get("month"), (Integer)this.valueByField.get("day"));
                }
                case FILE: {
                    return new org.openforis.idm.model.File((String)this.valueByField.get("file_name"), (Long)this.valueByField.get("file_size"));
                }
                case NUMBER: {
                    Integer unitId = (Integer)this.valueByField.get("unit");
                    Number number = (Number)this.valueByField.get("value");
                    return this.numericType == NumericAttributeDefinition.Type.INTEGER ? new IntegerValue(number == null ? null : Integer.valueOf(number.intValue()), unitId) : new RealValue(number == null ? null : Double.valueOf(number.doubleValue()), unitId);
                }
                case TAXON: {
                    String code = (String)this.valueByField.get("code");
                    String scientificName = (String)this.valueByField.get("scientific_name");
                    String vernacularName = (String)this.valueByField.get("vernacular_name");
                    String languageCode = (String)this.valueByField.get("language_code");
                    String languageVariety = (String)this.valueByField.get("language_variety");
                    String familyCode = (String)this.valueByField.get("family_code");
                    String familyScientificName = (String)this.valueByField.get("family_scientific_name");
                    TaxonOccurrence taxonOccurrence = new TaxonOccurrence(code, scientificName, vernacularName, languageCode, languageVariety);
                    taxonOccurrence.setFamilyCode(familyCode);
                    taxonOccurrence.setFamilyScientificName(familyScientificName);
                    return taxonOccurrence;
                }
                case TEXT: {
                    return new TextValue((String)this.valueByField.get("value"));
                }
                case TIME: {
                    Integer hour = (Integer)this.valueByField.get("hour");
                    Integer minute = (Integer)this.valueByField.get("minute");
                    return new Time(hour, minute);
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
        }

        public UpdateAttributeCommand<Value> toCommand(CollectSurvey survey) {
            Class<UpdateAttributeCommand<?>> commandType = this.toCommandType();
            try {
                UpdateAttributeCommand<?> c = commandType.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties((Object)((Object)this), c, (String[])new String[]{"attributeType", "value"});
                c.setValue(this.extractValue(survey));
                return c;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class<? extends UpdateAttributeCommand<?>> toCommandType() {
            switch (this.attributeType) {
                case BOOLEAN: {
                    return UpdateBooleanAttributeCommand.class;
                }
                case CODE: {
                    return UpdateCodeAttributeCommand.class;
                }
                case COORDINATE: {
                    return UpdateCoordinateAttributeCommand.class;
                }
                case DATE: {
                    return UpdateDateAttributeCommand.class;
                }
                case FILE: {
                    return UpdateFileAttributeCommand.class;
                }
                case NUMBER: {
                    return this.numericType == NumericAttributeDefinition.Type.INTEGER ? UpdateIntegerAttributeCommand.class : UpdateRealAttributeCommand.class;
                }
                case TAXON: {
                    return UpdateTaxonAttributeCommand.class;
                }
                case TEXT: {
                    return UpdateTextAttributeCommand.class;
                }
                case TIME: {
                    return UpdateTimeAttributeCommand.class;
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public void setAttributeType(AttributeType attributeType) {
            this.attributeType = attributeType;
        }

        public NumericAttributeDefinition.Type getNumericType() {
            return this.numericType;
        }

        public void setNumericType(NumericAttributeDefinition.Type numericType) {
            this.numericType = numericType;
        }

        public Map<String, Object> getValueByField() {
            return this.valueByField;
        }

        public void setValueByField(Map<String, Object> valueByField) {
            this.valueByField = valueByField;
        }
    }

    static class UpdateAttributesCommandWrapper {
        List<UpdateAttributeCommandWrapper> commands = new ArrayList<UpdateAttributeCommandWrapper>();

        UpdateAttributesCommandWrapper() {
        }

        public List<UpdateAttributeCommandWrapper> getCommands() {
            return this.commands;
        }

        public void setCommands(List<UpdateAttributeCommandWrapper> commands) {
            this.commands = commands;
        }
    }

    static class RecordEventView {
        private RecordEvent event;

        public RecordEventView(RecordEvent event) {
            this.event = event;
        }

        public String getEventType() {
            return this.event.getClass().getSimpleName();
        }

        public RecordEvent getEvent() {
            return this.event;
        }
    }
}

