/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.designer.component.SchemaTreeModel;
import org.openforis.collect.designer.component.SurveyObjectTreeModelCreator;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.openforis.idm.metamodel.VersionableSurveyObject;

public class UITreeModelCreator
extends SurveyObjectTreeModelCreator {
    public UITreeModelCreator(SurveyManager surveyManager, User loggedUser, ModelVersion version, Predicate<SurveyObject> includeNodePredicate, boolean includeRootEntity, boolean includeEmptyNodes, String labelLanguage) {
        this(surveyManager, loggedUser, version, null, includeNodePredicate, includeRootEntity, includeEmptyNodes, labelLanguage);
    }

    public UITreeModelCreator(SurveyManager surveyManager, User loggedUser, ModelVersion version, Predicate<SurveyObject> disabledNodePredicate, Predicate<SurveyObject> includeNodePredicate, boolean includeRootEntity, boolean includeEmptyNodes, String labelLanguage) {
        super(surveyManager, loggedUser, version, disabledNodePredicate, includeNodePredicate, includeRootEntity, includeEmptyNodes, labelLanguage);
    }

    @Override
    protected List<SchemaTreeModel.SchemaTreeNode> createChildNodes(SurveyObject surveyObject) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> childNodes = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
        if (surveyObject instanceof EntityDefinition) {
            List<SchemaTreeModel.SchemaTreeNode> entityChildrenNodes = this.createChildNodes((EntityDefinition)surveyObject);
            childNodes.addAll(entityChildrenNodes);
        } else if (surveyObject instanceof UITab) {
            List<SchemaTreeModel.SchemaTreeNode> childTabNodes = this.createChildNodes((UITab)surveyObject);
            childNodes.addAll(childTabNodes);
        } else if (surveyObject instanceof AttributeDefinition) {
            childNodes = null;
        }
        return childNodes;
    }

    private List<SchemaTreeModel.SchemaTreeNode> createChildNodes(EntityDefinition entityDefn) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> childNodes = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
        CollectSurvey survey = (CollectSurvey)entityDefn.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        UITab assignedTab = uiOptions.getAssignedTab((NodeDefinition)entityDefn);
        List childDefns = entityDefn.getChildDefinitions();
        List<SchemaTreeModel.SchemaTreeNode> schemaTreeNodes = this.createNodes(assignedTab, childDefns);
        childNodes.addAll(schemaTreeNodes);
        if (entityDefn.isMultiple() && uiOptions.getLayout(entityDefn) == UIOptions.Layout.FORM) {
            List tabs = uiOptions.getTabsAssignableToChildren(entityDefn, false);
            List<SchemaTreeModel.SchemaTreeNode> tabNodes = this.createNodes(tabs);
            childNodes.addAll(tabNodes);
        }
        return childNodes;
    }

    @Override
    protected List<SchemaTreeModel.SchemaTreeNode> createFirstLevelNodes(EntityDefinition rootEntity) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> firstLevelTreeNodes = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
        if (this.includeRootEntity) {
            SchemaTreeModel.SchemaTreeNode node = this.createRootNode(rootEntity);
            if (node != null) {
                firstLevelTreeNodes.add(node);
            }
        } else {
            CollectSurvey survey = (CollectSurvey)rootEntity.getSurvey();
            UIOptions uiOptions = survey.getUIOptions();
            UITabSet tabSet = uiOptions.getAssignedRootTabSet(rootEntity);
            for (UITab tab : tabSet.getTabs()) {
                SchemaTreeModel.SchemaTreeNode node = this.createNode(tab);
                if (node == null) continue;
                firstLevelTreeNodes.add(node);
            }
        }
        return firstLevelTreeNodes;
    }

    private SchemaTreeModel.SchemaTreeNode createRootNode(EntityDefinition rootEntity) {
        SchemaTreeModel.SchemaNodeData data = new SchemaTreeModel.SchemaNodeData((SurveyObject)rootEntity, rootEntity.getName(), false, false);
        SchemaTreeModel.SchemaTreeNode treeNode = (SchemaTreeModel.SchemaTreeNode)this.createNode(data, false);
        return treeNode;
    }

    private List<SchemaTreeModel.SchemaTreeNode> createChildNodes(UITab tab) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> result = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
        UIOptions uiOptions = tab.getUIOptions();
        List childDefns = uiOptions.getNodesPerTab(tab, false);
        List<SchemaTreeModel.SchemaTreeNode> childSchemaNodes = this.createNodes(tab, childDefns);
        result.addAll(childSchemaNodes);
        ArrayList<UITab> nestedTabs = new ArrayList<UITab>();
        for (UITab childTab : tab.getTabs()) {
            List nodes = uiOptions.getNodesPerTab(childTab, false);
            boolean toBeAdded = true;
            block1: for (NodeDefinition nestedTabChildNode : nodes) {
                for (NodeDefinition childDefn : childDefns) {
                    if (childDefn != nestedTabChildNode && (!(childDefn instanceof EntityDefinition) || !nestedTabChildNode.isDescendantOf((EntityDefinition)childDefn))) continue;
                    toBeAdded = false;
                    continue block1;
                }
            }
            if (!toBeAdded) continue;
            nestedTabs.add(childTab);
        }
        List<SchemaTreeModel.SchemaTreeNode> tabNodes = this.createNodes(nestedTabs);
        result.addAll(tabNodes);
        return result;
    }

    protected List<SchemaTreeModel.SchemaTreeNode> createNodes(UITab parentTab, List<? extends NodeDefinition> nodes) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> result = null;
        if (nodes != null) {
            result = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
            for (NodeDefinition nodeDefinition : nodes) {
                SchemaTreeModel.SchemaNodeData data;
                SchemaTreeModel.SchemaTreeNode treeNode;
                CollectSurvey survey;
                UIOptions uiOptions;
                UITab assignedTab;
                if (this.includeNodePredicate != null && !this.includeNodePredicate.evaluate(nodeDefinition) || (assignedTab = (uiOptions = (survey = (CollectSurvey)nodeDefinition.getSurvey()).getUIOptions()).getAssignedTab(nodeDefinition)) != parentTab || this.version != null && !this.version.isApplicable((VersionableSurveyObject)nodeDefinition) || (treeNode = (SchemaTreeModel.SchemaTreeNode)this.createNode(data = new SchemaTreeModel.SchemaNodeData((SurveyObject)nodeDefinition, nodeDefinition.getName(), false, false), false)) == null) continue;
                result.add(treeNode);
            }
        }
        return result;
    }

    private SchemaTreeModel.SchemaTreeNode createNode(UITab tab) {
        SchemaTreeModel.SchemaNodeData data = new SchemaTreeModel.SchemaNodeData((SurveyObject)tab, tab.getLabel(this.labelLanguage), false, false);
        return (SchemaTreeModel.SchemaTreeNode)this.createNode(data, false);
    }

    private List<SchemaTreeModel.SchemaTreeNode> createNodes(List<UITab> tabs) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> result = null;
        if (tabs != null) {
            result = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
            for (UITab tab : tabs) {
                SchemaTreeModel.SchemaTreeNode node = this.createNode(tab);
                if (node == null) continue;
                result.add(node);
            }
        }
        return result;
    }
}

