/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.SurveyObjectFormValidator;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.CodeList;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class CodeListFormValidator
extends SurveyObjectFormValidator<CodeList> {
    protected static final String NAME_FIELD = "name";
    protected static final String[] RESERVED_NAMES = new String[]{"sampling_design"};

    @Override
    protected void internalValidate(ValidationContext ctx) {
        this.validateName(ctx);
    }

    protected boolean validateName(ValidationContext ctx) {
        boolean result = this.validateRequired(ctx, NAME_FIELD);
        if (result && (result = this.validateInternalName(ctx, NAME_FIELD)) && (result = this.validateNameNotReserved(ctx, NAME_FIELD, RESERVED_NAMES))) {
            result = this.validateNameUniqueness(ctx);
        }
        return result;
    }

    protected boolean validateNameUniqueness(ValidationContext ctx) {
        String name;
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        CodeList editedItem = (CodeList)viewModel.getEditedItem();
        CollectSurvey survey = viewModel.getSurvey();
        CodeList existingItem = survey.getCodeList(name = (String)this.getValue(ctx, NAME_FIELD));
        if (existingItem != null && existingItem.getId() != editedItem.getId()) {
            String message = Labels.getLabel((String)"global.item.validation.name_already_defined");
            this.addInvalidMessage(ctx, NAME_FIELD, message);
            return false;
        }
        return true;
    }
}

