/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.CodeListFormObject;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.validator.BaseValidator;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.ComponentUtil;
import org.openforis.collect.designer.util.MediaUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.designer.viewmodel.SurveyErrorsPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.designer.viewmodel.referencedata.ReferenceDataImportErrorsPopUpVM;
import org.openforis.collect.io.metadata.codelist.CodeListBatchExportJob;
import org.openforis.collect.io.metadata.codelist.CodeListBatchImportJob;
import org.openforis.collect.io.metadata.codelist.CodeListImportTask;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.dataexport.codelist.CodeListExportProcess;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.FileWrapper;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLevel;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.PersistedCodeListItem;
import org.openforis.idm.metamodel.Schema;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Window;

public class CodeListsVM
extends SurveyObjectBaseVM<CodeList> {
    public static final String EDITING_ATTRIBUTE_PARAM = "editingAttribute";
    public static final String SELECTED_CODE_LIST_PARAM = "selectedCodeList";
    private static final String CODE_LISTS_UPDATED_GLOBAL_COMMAND = "codeListsUpdated";
    private static final String SURVEY_CODE_LIST_GENERATED_LEVEL_NAME_LABEL_KEY = "survey.code_list.generated_level_name";
    public static final String CLOSE_CODE_LIST_ITEM_POP_UP_COMMAND = "closeCodeListItemPopUp";
    public static final String CLOSE_CODE_LIST_IMPORT_POP_UP_COMMAND = "closeCodeListImportPopUp";
    private List<List<CodeListItem>> itemsPerLevel;
    private boolean newChildItem;
    private CodeListItem editedChildItem;
    private CodeListItem editedChildItemParentItem;
    private int editedChildItemLevelIndex;
    private List<CodeListItem> selectedItemsPerLevel;
    private Window codeListItemPopUp;
    private Window referencedNodesPopUp;
    private Window codeListImportPopUp;
    private boolean editingAttribute;
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private CodeListManager codeListManager;
    private Window jobStatusPopUp;
    private Window dataImportErrorPopUp;

    public CodeListsVM() {
        this.formObject = this.createFormObject();
        this.fieldLabelKeyPrefixes.addAll(0, Arrays.asList("survey.code_list"));
    }

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="editingAttribute") Boolean editingAttribute, @ExecutionArgParam(value="selectedCodeList") CodeList selectedCodeList) {
        super.init();
        if (selectedCodeList != null) {
            this.selectionChanged(selectedCodeList);
        }
        this.editingAttribute = editingAttribute != null && editingAttribute != false;
    }

    @Override
    @AfterCompose
    public void doAfterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        super.doAfterCompose(view);
    }

    @Override
    protected List<CodeList> getItemsInternal() {
        CollectSurvey survey = this.getSurvey();
        if (survey == null) {
            return Collections.emptyList();
        }
        List<CodeList> codeLists = survey.getCodeLists(false);
        codeLists = this.sortByName(codeLists);
        return codeLists;
    }

    @Override
    protected void addNewItemToSurvey() {
        CollectSurvey survey = this.getSurvey();
        survey.addCodeList((CodeList)this.editedItem);
        CodeListsVM.dispatchCodeListsUpdatedCommand();
        SurveyEditVM.dispatchSurveySaveCommand();
        this.initItemsPerLevel();
    }

    @Override
    protected void deleteItemFromSurvey(CodeList item) {
        this.codeListManager.delete(item);
        CodeListsVM.dispatchCodeListsUpdatedCommand();
        SurveyEditVM.dispatchSurveySaveCommand();
    }

    @Override
    protected FormObject<CodeList> createFormObject() {
        return new CodeListFormObject();
    }

    public static void dispatchCodeListsUpdatedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)CODE_LISTS_UPDATED_GLOBAL_COMMAND, null);
    }

    @Override
    @Command
    protected void performNewItemCreation(Binder binder) {
        super.performNewItemCreation(binder);
        this.notifyChange("listLevels", "itemsPerLevel", "selectedItemsPerLevel");
    }

    @Override
    protected CodeList createItemInstance() {
        CodeList instance = this.survey.createCodeList();
        instance.setCodeScope(CodeList.CodeScope.LOCAL);
        return instance;
    }

    @Override
    protected void performItemSelection(CodeList item) {
        super.performItemSelection(item);
        this.notifyChange("listLevels", "itemsPerLevel", "selectedItemsPerLevel");
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
        this.survey.moveCodeList((CodeList)this.selectedItem, indexTo);
    }

    @Command
    public void deleteCodeList(@BindingParam(value="item") CodeList item) {
        List<NodeDefinition> references = this.getReferences(item);
        if (!references.isEmpty()) {
            String title = Labels.getLabel((String)"global.message.title.warning");
            String message = Labels.getLabel((String)"survey.code_list.alert.cannot_delete_used_list");
            this.referencedNodesPopUp = SurveyErrorsPopUpVM.openPopUp(title, message, references, new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    CodeListsVM.this.closeReferencedNodesPopUp();
                }
            }, true);
        } else {
            super.deleteItem(item);
        }
    }

    protected void closeReferencedNodesPopUp() {
        CodeListsVM.closePopUp(this.referencedNodesPopUp);
        this.referencedNodesPopUp = null;
    }

    protected List<NodeDefinition> getReferences(CodeList item) {
        ArrayList<NodeDefinition> references = new ArrayList<NodeDefinition>();
        Schema schema = this.survey.getSchema();
        List rootEntities = schema.getRootEntityDefinitions();
        Stack stack = new Stack();
        stack.addAll(rootEntities);
        while (!stack.isEmpty()) {
            CodeList list;
            NodeDefinition defn = (NodeDefinition)stack.pop();
            if (defn instanceof EntityDefinition) {
                stack.addAll(((EntityDefinition)defn).getChildDefinitions());
                continue;
            }
            if (!(defn instanceof CodeAttributeDefinition) || !(list = ((CodeAttributeDefinition)defn).getList()).equals((Object)item)) continue;
            references.add(defn);
        }
        return references;
    }

    @Command
    public void typeChanged(@BindingParam(value="type") String type) {
        CodeListFormObject.Type typeEnum = CodeListFormObject.Type.valueOf(type);
        switch (typeEnum) {
            case HIERARCHICAL: {
                this.addLevel();
                break;
            }
            default: {
                ((CodeList)this.editedItem).removeLevel(0);
            }
        }
        CodeListFormObject fo = (CodeListFormObject)this.formObject;
        fo.setType(type);
        this.notifyChange("formObject", "listLevels");
    }

    @Command
    @NotifyChange(value={"listLevels"})
    public void addLevel() {
        List levels = ((CodeList)this.editedItem).getHierarchy();
        int levelPosition = levels.size() + 1;
        CodeListLevel level = new CodeListLevel();
        String generatedName = Labels.getLabel((String)SURVEY_CODE_LIST_GENERATED_LEVEL_NAME_LABEL_KEY, (Object[])new Object[]{levelPosition});
        level.setName(generatedName);
        ((CodeList)this.editedItem).addLevel(level);
    }

    @Command
    public void removeLevel() {
        List levels = ((CodeList)this.editedItem).getHierarchy();
        if (!levels.isEmpty()) {
            final int levelIndex = levels.size() - 1;
            if (this.codeListManager.hasChildItemsInLevel((CodeList)this.editedItem, levelIndex + 1)) {
                MessageUtil.ConfirmHandler handler = new MessageUtil.ConfirmHandler(){

                    @Override
                    public void onOk() {
                        CodeListsVM.this.performRemoveLevel(levelIndex);
                    }
                };
                MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(handler, "survey.code_list.alert.cannot_delete_non_empty_level");
                params.setOkLabelKey("global.delete_item");
                MessageUtil.showConfirm(params);
            } else {
                this.performRemoveLevel(levelIndex);
            }
        }
    }

    public String getHierarchyLevelNameValidationKey(int levelIdx) {
        return "hiearchyLevelName_" + levelIdx;
    }

    public Validator getHierarchyLevelNameValidator(final int levelIdx) {
        return new BaseValidator(){

            public void validate(ValidationContext ctx) {
                String validationKey = CodeListsVM.this.getHierarchyLevelNameValidationKey(levelIdx);
                if (this.validateRequired(ctx, null, validationKey)) {
                    this.validateInternalName(ctx, null, validationKey);
                }
            }
        };
    }

    protected void performRemoveLevel(int levelIndex) {
        this.codeListManager.removeLevel((CodeList)this.editedItem, levelIndex + 1);
        this.deselectItemsAfterLevel(levelIndex);
        this.initItemsPerLevel();
        this.notifyChange("listLevels", "selectedItemsPerLevel");
    }

    @Command
    @NotifyChange(value={"itemsPerLevel"})
    public void addItemInLevel(@BindingParam(value="levelIndex") int levelIndex) {
        if (this.checkCanLeaveForm()) {
            this.newChildItem = true;
            this.editedChildItemLevelIndex = levelIndex;
            this.editedChildItem = this.createChildItem();
            this.editedChildItemParentItem = this.editedChildItemLevelIndex == 0 ? null : this.selectedItemsPerLevel.get(this.editedChildItemLevelIndex - 1);
            this.openChildItemEditPopUp();
        }
    }

    protected CodeListItem createChildItem() {
        if (((CodeList)this.editedItem).isExternal()) {
            throw new UnsupportedOperationException("Cannot instantiate ExternalCodeListItem object");
        }
        if (((CodeList)this.editedItem).isEmpty()) {
            return new PersistedCodeListItem((CodeList)this.editedItem, this.editedChildItemLevelIndex + 1);
        }
        return ((CodeList)this.editedItem).createItem(this.editedChildItemLevelIndex + 1);
    }

    @Command
    @NotifyChange(value={"itemsPerLevel"})
    public void deleteCodeListItem(final @BindingParam(value="item") CodeListItem item) {
        if (this.isSurveyPublished() && this.isEnumeratingCodeList()) {
            MessageUtil.showWarning("survey.code_list.cannot_delete_enumerating_code_list_items", new Object[0]);
        } else {
            String messageKey = this.codeListManager.hasChildItems(item) ? "survey.code_list.confirm.delete_non_empty_item" : "survey.code_list.confirm.delete_item";
            MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    CodeListsVM.this.performDeleteCodeListItem(item);
                }
            }, messageKey);
            params.setOkLabelKey("global.delete_item");
            MessageUtil.showConfirm(params);
        }
    }

    protected boolean isEnumeratingCodeList() {
        return ((CodeList)this.editedItem).isEnumeratingList();
    }

    protected void performDeleteCodeListItem(CodeListItem item) {
        boolean selected = this.isCodeListItemSelected(item);
        int itemLevelIndex = this.getLevelIndex(item);
        this.codeListManager.delete(item);
        if (selected) {
            this.deselectItemsAfterLevel(itemLevelIndex);
        }
        this.initItemsPerLevel();
        this.notifyChange("selectedItemsPerLevel");
        BindUtils.postNotifyChange(null, null, (Object)this.editedItem, (String)".");
    }

    @Command
    public void moveChildItem(@ContextParam(value=ContextType.TRIGGER_EVENT) DropEvent event) {
        Listitem dragged = (Listitem)event.getDragged();
        Listitem dropped = (Listitem)event.getTarget();
        CodeListItem draggedItem = (CodeListItem)dragged.getValue();
        CodeListItem droppedItem = (CodeListItem)dropped.getValue();
        int indexTo = this.getItemIndex(droppedItem);
        this.moveChildItem(draggedItem, indexTo);
    }

    @Override
    public void setEditedItem(CodeList editedItem) {
        super.setEditedItem(editedItem);
        this.selectedItemsPerLevel = new ArrayList<CodeListItem>();
        this.initItemsPerLevel();
    }

    @Command
    public void editCodeListItem(@BindingParam(value="item") CodeListItem item) {
        this.newChildItem = false;
        this.editedChildItem = item;
        this.editedChildItemParentItem = this.codeListManager.loadParentItem(item);
        this.openChildItemEditPopUp();
    }

    @Command
    public void batchImportFileUploaded(@ContextParam(value=ContextType.TRIGGER_EVENT) UploadEvent event) {
        File tempFile = MediaUtil.copyToTempFile(event.getMedia());
        CodeListBatchImportJob batchImportJob = new CodeListBatchImportJob();
        batchImportJob.setJobManager((JobManager)this.jobManager);
        batchImportJob.setCodeListManager(this.codeListManager);
        batchImportJob.setSurvey(this.survey);
        batchImportJob.setOverwriteData(true);
        batchImportJob.setFile(tempFile);
        this.jobManager.start((Job)batchImportJob);
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp("survey.code_list.import_data.title", batchImportJob, true, new JobStatusPopUpVM.JobEndHandler<CodeListBatchImportJob>(){

            @Override
            public void onJobEnd(CodeListBatchImportJob job) {
                CodeListsVM.this.closeJobStatusPopUp();
                switch (job.getStatus()) {
                    case COMPLETED: {
                        MessageUtil.showInfo("survey.code_list.batch_import_completed", new Object[0]);
                        CodeListsVM.this.codeListsUpdated();
                        CodeListsVM.this.resetEditedItem();
                        SurveyEditVM.dispatchSurveySaveCommand();
                        break;
                    }
                    case FAILED: {
                        if (job.getCurrentTask() != null) {
                            CodeListImportTask lastTask = (CodeListImportTask)job.getCurrentTask();
                            CodeListsVM.this.dataImportErrorPopUp = ReferenceDataImportErrorsPopUpVM.showPopUp(lastTask.getErrors(), Labels.getLabel((String)"survey.code_list.import_data.error_popup.title", (Object[])new String[]{lastTask.getEntryName()}));
                            break;
                        }
                        CodeListsVM.this.showJobErrorMessage(job);
                        break;
                    }
                }
            }
        });
    }

    @Command
    public void batchExport() {
        final CodeListBatchExportJob batchExportJob = new CodeListBatchExportJob();
        batchExportJob.setJobManager((JobManager)this.jobManager);
        batchExportJob.setCodeListManager(this.codeListManager);
        batchExportJob.setSurvey(this.survey);
        this.jobManager.start((Job)batchExportJob);
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp("survey.code_list.batch_export", batchExportJob, true, new JobStatusPopUpVM.JobEndHandler<CodeListBatchExportJob>(){

            @Override
            public void onJobEnd(CodeListBatchExportJob job) {
                CodeListsVM.this.closeJobStatusPopUp();
                switch (job.getStatus()) {
                    case COMPLETED: {
                        CodeListsVM.this.downloadFile(batchExportJob.getOutputFile(), CodeListsVM.this.survey.getName() + "_code_lists.zip");
                        break;
                    }
                    case FAILED: {
                        CodeListsVM.this.showJobErrorMessage(job);
                        break;
                    }
                }
            }
        });
    }

    @Override
    @GlobalCommand
    public void codeListsUpdated() {
        this.notifyChange("items");
    }

    private void downloadFile(File file, String fileName) {
        try {
            Filedownload.save((InputStream)new FileInputStream(file), (String)"application/zip", (String)fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateItemCode(CodeListItem item) {
        return "item_" + item.getId();
    }

    public void openChildItemEditPopUp() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("item", this.editedChildItem);
        args.put("parentItem", this.editedChildItemParentItem);
        args.put("enumeratingCodeList", this.isSurveyPublished() && this.isEnumeratingCodeList());
        this.codeListItemPopUp = CodeListsVM.openPopUp(Resources.Component.CODE_LIST_ITEM_EDIT_POP_UP.getLocation(), true, args);
        Binder binder = ComponentUtil.getBinder((Component)this.codeListItemPopUp);
        this.validateForm(binder);
    }

    @Command
    @NotifyChange(value={"itemsPerLevel", "selectedItemsPerLevel"})
    public void listItemSelected(@BindingParam(value="item") CodeListItem item, @BindingParam(value="levelIndex") int levelIndex) {
        this.deselectItemsAfterLevel(levelIndex);
        this.selectedItemsPerLevel.add(item);
        this.initItemsPerLevel();
    }

    @DependsOn(value={"listLevels"})
    public boolean isMultipleLevelsPresent() {
        if (this.editedItem != null) {
            return ((CodeList)this.editedItem).getHierarchy().size() > 1;
        }
        return false;
    }

    protected void deselectItemsAfterLevel(int levelIndex) {
        int maxSelectedLevelIndex;
        for (int i = maxSelectedLevelIndex = this.selectedItemsPerLevel.size() - 1; i >= levelIndex; --i) {
            this.selectedItemsPerLevel.remove(i);
        }
    }

    protected void moveChildItem(CodeListItem item, int toIndex) {
        this.codeListManager.shiftItem(item, toIndex);
        int levelIdx = this.getLevelIndex(item);
        List<CodeListItem> siblings = this.itemsPerLevel.get(levelIdx);
        CollectionUtils.shiftItem(siblings, (Object)item, (int)toIndex);
        this.itemsPerLevel.set(levelIdx, siblings);
        if (item instanceof PersistedCodeListItem) {
            this.reloadSiblingsSortOrder((PersistedCodeListItem)item);
        }
        this.notifyChange("itemsPerLevel");
    }

    protected void reloadSiblingsSortOrder(PersistedCodeListItem item) {
        List newItems;
        int levelIdx = this.getLevelIndex((CodeListItem)item);
        if (levelIdx == 0) {
            newItems = this.codeListManager.loadRootItems(item.getCodeList());
        } else {
            CodeListItem parentItem = this.codeListManager.loadParentItem((CodeListItem)item);
            newItems = this.codeListManager.loadChildItems(parentItem);
        }
        List<CodeListItem> items = this.itemsPerLevel.get(levelIdx);
        for (int i = 0; i < items.size(); ++i) {
            CodeListItem oldItem = items.get(i);
            CodeListItem newItem = (CodeListItem)newItems.get(i);
            ((PersistedCodeListItem)oldItem).setSortOrder(((PersistedCodeListItem)newItem).getSortOrder());
        }
    }

    protected int getLevelIndex(CodeListItem item) {
        for (int index = 0; index < this.itemsPerLevel.size(); ++index) {
            List<CodeListItem> items = this.itemsPerLevel.get(index);
            if (!items.contains(item)) continue;
            return index;
        }
        throw new IllegalArgumentException("Item not found in cache");
    }

    protected List<CodeListItem> getSiblings(CodeListItem item) {
        int levelIdx = this.getLevelIndex(item);
        List<CodeListItem> siblings = this.itemsPerLevel.get(levelIdx);
        return siblings;
    }

    protected int getItemIndex(CodeListItem item) {
        List<CodeListItem> siblings = this.getSiblings(item);
        int index = siblings.indexOf(item);
        return index;
    }

    @GlobalCommand
    public void closeCodeListItemPopUp(@BindingParam(value="undoChanges") boolean undoChanges, @BindingParam(value="imageModified") boolean imageModified, @BindingParam(value="imageFileWrapper") FileWrapper imageFileWrapper) {
        if (this.codeListItemPopUp == null) {
            return;
        }
        CodeListsVM.closePopUp(this.codeListItemPopUp);
        this.codeListItemPopUp = null;
        if (undoChanges) {
            this.dispatchCurrentFormValidatedCommand(true);
        } else {
            if (this.newChildItem) {
                this.addChildItemToCodeList();
            } else {
                SurveyEditVM.dispatchSurveySaveCommand();
                if (this.editedChildItem instanceof PersistedCodeListItem) {
                    this.codeListManager.save((PersistedCodeListItem)this.editedChildItem);
                }
                BindUtils.postNotifyChange(null, null, (Object)this.editedChildItem, (String)"*");
            }
            if (imageModified) {
                PersistedCodeListItem persistedItem;
                if (this.editedChildItem instanceof PersistedCodeListItem) {
                    persistedItem = (PersistedCodeListItem)this.editedChildItem;
                } else {
                    CodeList codeList = this.editedChildItem.getCodeList();
                    this.codeListManager.persistCodeListItems(codeList);
                    this.reloadSelectedItems();
                    this.initItemsPerLevel();
                    persistedItem = (PersistedCodeListItem)this.codeListManager.loadItem(codeList, this.editedChildItem.getId());
                }
                if (imageFileWrapper == null) {
                    this.codeListManager.deleteImageContent(persistedItem);
                } else {
                    this.codeListManager.saveImageContent(persistedItem, imageFileWrapper);
                }
            }
        }
    }

    @Override
    public void commitChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        super.commitChanges(binder);
        CodeListsVM.dispatchCodeListsUpdatedCommand();
    }

    @Command
    public void openCodeListImportPopUp() {
        if (this.canImportCodeList()) {
            HashMap<String, Integer> args = new HashMap<String, Integer>();
            args.put("codeListId", ((CodeList)this.editedItem).getId());
            this.codeListImportPopUp = CodeListsVM.openPopUp(Resources.Component.CODE_LIST_IMPORT_POPUP.getLocation(), true, args);
        } else if (((CodeList)this.editedItem).isExternal()) {
            MessageUtil.showWarning("survey.code_list.cannot_import_items_on_external_code_list", new Object[0]);
        } else {
            MessageUtil.showWarning("survey.code_list.cannot_import_items_on_enumerating_code_list", new Object[0]);
        }
    }

    @Command
    public void exportCodeListToCsv() throws IOException {
        this.exportCodeList(CodeListExportProcess.OutputFormat.CSV);
    }

    @Command
    public void exportCodeListToExcel() throws IOException {
        this.exportCodeList(CodeListExportProcess.OutputFormat.EXCEL);
    }

    private void exportCodeList(CodeListExportProcess.OutputFormat outputFormat) throws IOException {
        CollectSurvey survey = this.getSurvey();
        CodeListExportProcess exportProcess = new CodeListExportProcess(this.codeListManager);
        boolean csv = outputFormat == CodeListExportProcess.OutputFormat.CSV;
        String extension = csv ? "csv" : "xlsx";
        File tempFile = File.createTempFile("code_list_" + ((CodeList)this.editedItem).getName(), "." + extension);
        FileOutputStream os = new FileOutputStream(tempFile);
        exportProcess.export(os, survey, ((CodeList)this.editedItem).getId(), outputFormat);
        Filedownload.save((File)tempFile, (String)(csv ? "text/csv" : "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
    }

    @GlobalCommand
    public void closeReferenceDataImportErrorPopUp() {
        CodeListsVM.closePopUp(this.dataImportErrorPopUp);
        this.dataImportErrorPopUp = null;
    }

    protected boolean canImportCodeList() {
        return !((CodeList)this.editedItem).isExternal() && !this.isUsedAsEnumeratorInPublishedSurvey();
    }

    private boolean isUsedAsEnumeratorInPublishedSurvey() {
        return this.isSurveyPublished() && this.isEnumeratingCodeList() && this.isCodeListInPublishedSurvey();
    }

    protected boolean isCodeListInPublishedSurvey() {
        SessionStatus sessionStatus = this.getSessionStatus();
        Integer publishedSurveyId = sessionStatus.getPublishedSurveyId();
        if (publishedSurveyId != null) {
            CollectSurvey publishedSurvey = this.surveyManager.getById(publishedSurveyId.intValue());
            CodeList oldPublishedCodeList = publishedSurvey.getCodeListById(((CodeList)this.editedItem).getId());
            return oldPublishedCodeList != null;
        }
        return false;
    }

    @GlobalCommand
    public void closeCodeListImportPopUp() {
        CodeListsVM.closePopUp(this.codeListImportPopUp);
        this.codeListImportPopUp = null;
        if (this.editedItem != null) {
            boolean hasMultipleLevels = ((CodeList)this.editedItem).getHierarchy().size() > 1;
            CodeListFormObject.Type type = hasMultipleLevels ? CodeListFormObject.Type.HIERARCHICAL : CodeListFormObject.Type.FLAT;
            CodeListFormObject fo = (CodeListFormObject)this.formObject;
            fo.setType(type.name());
            this.selectedItemsPerLevel = new ArrayList<CodeListItem>();
            this.initItemsPerLevel();
            this.notifyChange("formObject", "listLevels", "selectedItemsPerLevel");
        }
    }

    @GlobalCommand
    public void closeCodeListsManagerPopUp() {
        this.resetEditedItem();
        this.codeListsUpdated();
    }

    private void addChildItemToCodeList() {
        if (((CodeList)this.editedItem).isEmpty() && this.isSurveyStored()) {
            PersistedCodeListItem persistedChildItem = (PersistedCodeListItem)this.editedChildItem;
            if (this.editedChildItemParentItem != null) {
                persistedChildItem.setParentId(((PersistedCodeListItem)this.editedChildItemParentItem).getSystemId());
            }
            this.codeListManager.save(persistedChildItem);
            SurveyEditVM.dispatchSurveySaveCommand();
        } else if (this.editedChildItemParentItem == null) {
            ((CodeList)this.editedItem).addItem(this.editedChildItem);
        } else {
            this.editedChildItemParentItem.addChildItem(this.editedChildItem);
        }
        List<CodeListItem> itemsForCurrentLevel = this.itemsPerLevel.get(this.editedChildItemLevelIndex);
        itemsForCurrentLevel.add(this.editedChildItem);
        this.deselectItemsAfterLevel(this.editedChildItemLevelIndex);
        this.selectedItemsPerLevel.add(this.editedChildItem);
        this.initItemsPerLevel();
        this.notifyChange("selectedItemsPerLevel");
        BindUtils.postNotifyChange(null, null, (Object)this.editedItem, (String)".");
    }

    private void reloadSelectedItems() {
        ArrayList<CodeListItem> newItems = new ArrayList<CodeListItem>(this.selectedItemsPerLevel.size());
        for (CodeListItem item : this.selectedItemsPerLevel) {
            CodeListItem newItem = this.codeListManager.loadItem(item.getCodeList(), item.getId());
            newItems.add(newItem);
        }
        this.selectedItemsPerLevel = newItems;
        this.notifyChange("selectedItemsPerLevel");
    }

    protected void initItemsPerLevel() {
        this.itemsPerLevel = new ArrayList<List<CodeListItem>>();
        if (this.editedItem != null && !((CodeList)this.editedItem).isExternal()) {
            List rootItems = this.codeListManager.loadRootItems((CodeList)this.editedItem);
            this.itemsPerLevel.add(new ArrayList(rootItems));
            for (CodeListItem selectedItem : this.selectedItemsPerLevel) {
                List childItems = this.codeListManager.loadChildItems(selectedItem);
                this.itemsPerLevel.add(new ArrayList(childItems));
            }
        } else {
            this.itemsPerLevel.add(new ArrayList());
        }
        this.notifyChange("itemsPerLevel");
    }

    public List<CodeListLevel> getListLevels() {
        List levels = null;
        if (this.editedItem != null && (levels = ((CodeList)this.editedItem).getHierarchy()).isEmpty()) {
            CodeListLevel fakeFirstLevel = new CodeListLevel();
            return Arrays.asList(fakeFirstLevel);
        }
        return levels;
    }

    public List<CodeListItem> getSelectedItemsPerLevel() {
        return this.selectedItemsPerLevel;
    }

    @DependsOn(value={"selectedItemsPerLevel"})
    public int getLastSelectedLevelIndex() {
        return this.selectedItemsPerLevel.size() - 1;
    }

    public List<List<CodeListItem>> getItemsPerLevel() {
        return this.itemsPerLevel;
    }

    public boolean isCodeListItemSelected(CodeListItem item) {
        return this.selectedItemsPerLevel.contains(item);
    }

    public boolean hasChildItems(CodeListItem item) {
        boolean result = this.codeListManager.hasChildItems(item);
        return result;
    }

    public String getCodeListItemLabel(CodeListItem item) {
        String label = item.getLabel(this.currentLanguageCode);
        return label;
    }

    public boolean isEditingAttribute() {
        return this.editingAttribute;
    }

    public boolean hasWarnings(CodeList list) {
        return !this.codeListManager.isInUse(list) || this.codeListManager.isEmpty(list);
    }

    public String getWarnings(CodeList list) {
        String messageKey = this.codeListManager.isEmpty(list) ? "survey.validation.error.empty_code_list" : (!this.codeListManager.isInUse(list) ? "survey.validation.error.unused_code_list" : null);
        return messageKey == null ? null : Labels.getLabel((String)messageKey);
    }

    @GlobalCommand
    public void codeListAssigned(@BindingParam(value="list") CodeList list, @BindingParam(value="oldList") CodeList oldList) {
        BindUtils.postNotifyChange(null, null, (Object)list, (String)".");
        BindUtils.postNotifyChange(null, null, (Object)oldList, (String)".");
    }

    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        event.stopPropagation();
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(CodeListsVM.EDITING_ATTRIBUTE_PARAM, CodeListsVM.this.editingAttribute);
                params.put(CodeListsVM.SELECTED_CODE_LIST_PARAM, CodeListsVM.this.selectedItem);
                BindUtils.postGlobalCommand((String)null, (String)null, (String)"closeCodeListsManagerPopUp", params);
            }
        });
    }

    private void showJobErrorMessage(Job job) {
        String errorMessageKey = job.getErrorMessage();
        String errorMessage = (String)StringUtils.defaultIfBlank((CharSequence)Labels.getLabel((String)errorMessageKey), (CharSequence)errorMessageKey);
        MessageUtil.showError("global.job_status.failed.message", errorMessage);
    }

    protected void closeJobStatusPopUp() {
        CodeListsVM.closePopUp(this.jobStatusPopUp);
        this.jobStatusPopUp = null;
    }
}

