/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.HashMap;
import org.openforis.collect.designer.util.PopUpUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.concurrency.Job;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Window;

public class JobStatusPopUpVM<J extends Job>
extends BaseVM {
    public static final String JOB_FAILED_COMMAND = "jobFailed";
    public static final String JOB_COMPLETED_COMMAND = "jobCompleted";
    public static final String JOB_ABORTED_COMMAND = "jobAborted";
    public static final String UPDATE_PROGRESS_COMMAND = "updateProgress";
    public static final String JOB_ARG = "job";
    public static final String JOB_END_HANDLER_ARG = "jobEndHandler";
    public static final String MESSAGE_ARG = "message";
    public static final String CANCELABLE_ARG = "cancelable";
    private String message;
    private boolean cancelable;
    private J job;
    private JobEndHandler<J> jobEndHandler;

    public static <J extends Job> Window openPopUp(String messageKey, J job, boolean cancelable) {
        return JobStatusPopUpVM.openPopUp(messageKey, job, cancelable, null);
    }

    public static <J extends Job> Window openPopUp(String messageKey, J job, boolean cancelable, JobEndHandler<J> jobEndHandler) {
        String message = Labels.getLabel((String)messageKey);
        if (message == null) {
            message = messageKey;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(MESSAGE_ARG, message);
        args.put(JOB_ARG, job);
        args.put(JOB_END_HANDLER_ARG, jobEndHandler);
        args.put(CANCELABLE_ARG, cancelable);
        return PopUpUtil.openPopUp(Resources.Component.JOB_STATUS_POPUP.getLocation(), true, args);
    }

    @Init
    public void init(@ExecutionArgParam(value="message") String message, @ExecutionArgParam(value="job") J job, @ExecutionArgParam(value="jobEndHandler") JobEndHandler<J> jobEndHandler, @ExecutionArgParam(value="cancelable") boolean cancelable) {
        this.message = message;
        this.job = job;
        this.jobEndHandler = jobEndHandler;
        this.cancelable = cancelable;
    }

    @GlobalCommand
    public void updateProgress() {
        switch (this.job.getStatus()) {
            case COMPLETED: {
                this.dispatchJobCompletedCommand();
                break;
            }
            case FAILED: {
                this.dispatchJobFailedCommand();
                break;
            }
            case ABORTED: {
                this.dispatchJobAbortedCommand();
                break;
            }
        }
        this.notifyChange("progress");
        if (this.jobEndHandler != null && this.job.isEnded()) {
            this.jobEndHandler.onJobEnd(this.job);
        }
    }

    private void dispatchJobCompletedCommand() {
        HashMap<String, J> args = new HashMap<String, J>();
        args.put(JOB_ARG, this.job);
        BindUtils.postGlobalCommand(null, null, (String)JOB_COMPLETED_COMMAND, args);
    }

    private void dispatchJobFailedCommand() {
        HashMap<String, J> args = new HashMap<String, J>();
        args.put(JOB_ARG, this.job);
        BindUtils.postGlobalCommand(null, null, (String)JOB_FAILED_COMMAND, args);
    }

    private void dispatchJobAbortedCommand() {
        HashMap<String, J> args = new HashMap<String, J>();
        args.put(JOB_ARG, this.job);
        BindUtils.postGlobalCommand(null, null, (String)JOB_ABORTED_COMMAND, args);
    }

    public int getProgress() {
        return this.job.getProgressPercent();
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    @Command
    public void abort() {
        this.job.abort();
        this.dispatchJobAbortedCommand();
    }

    public static interface JobEndHandler<J extends Job> {
        public void onJobEnd(J var1);
    }
}

