/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.SpatialReferenceSystemFormObject;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.geospatial.GeoToolsCoordinateOperations;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;

public class SpatialReferenceSystemsVM
extends SurveyObjectBaseVM<SpatialReferenceSystem> {
    private String selectedPredefinedSrsCode;

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @Override
    public List<SpatialReferenceSystem> getItemsInternal() {
        CollectSurvey survey = this.getSurvey();
        List spatialReferenceSystems = survey.getSpatialReferenceSystems();
        return spatialReferenceSystems;
    }

    @Override
    protected SpatialReferenceSystem createItemInstance() {
        return new SpatialReferenceSystem();
    }

    @Override
    protected void addNewItemToSurvey() {
        CollectSurvey survey = this.getSurvey();
        survey.addSpatialReferenceSystem((SpatialReferenceSystem)this.editedItem);
    }

    @Override
    protected void deleteItemFromSurvey(SpatialReferenceSystem item) {
        CollectSurvey survey = this.getSurvey();
        survey.removeSpatialReferenceSystem(item);
    }

    @Override
    protected FormObject<SpatialReferenceSystem> createFormObject() {
        return new SpatialReferenceSystemFormObject();
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
        this.survey.moveSpatialReferenceSystem((SpatialReferenceSystem)this.selectedItem, indexTo);
    }

    public List<String> getAvailablePredefinedSRSs() {
        List currentSRSs = this.survey.getSpatialReferenceSystems();
        ArrayList<String> insertedSRSCodes = new ArrayList<String>();
        for (SpatialReferenceSystem srs : currentSRSs) {
            insertedSRSCodes.add(srs.getId());
        }
        GeoToolsCoordinateOperations coordinateOperations = (GeoToolsCoordinateOperations)this.survey.getContext().getCoordinateOperations();
        Set<String> availableSRSs = coordinateOperations.getAvailableSRSs();
        ArrayList<String> result = new ArrayList<String>(availableSRSs);
        result.removeAll(insertedSRSCodes);
        Collections.sort(result);
        return result;
    }

    @Command
    public void addPredefinedSrs() {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                HashSet<String> languages = new HashSet<String>(SpatialReferenceSystemsVM.this.survey.getLanguages());
                GeoToolsCoordinateOperations coordinateOperations = (GeoToolsCoordinateOperations)SpatialReferenceSystemsVM.this.survey.getContext().getCoordinateOperations();
                SpatialReferenceSystem srs = coordinateOperations.fetchSRS(SpatialReferenceSystemsVM.this.selectedPredefinedSrsCode, languages);
                SpatialReferenceSystemsVM.this.survey.addSpatialReferenceSystem(srs);
                SpatialReferenceSystemsVM.this.selectedPredefinedSrsCode = null;
                SpatialReferenceSystemsVM.this.notifyChange("items", "selectedPredefinedSrsCode", "availablePredefinedSRSs");
                SpatialReferenceSystemsVM.this.dispatchSurveyChangedCommand();
            }
        });
    }

    public String getSelectedPredefinedSrsCode() {
        return this.selectedPredefinedSrsCode;
    }

    public void setSelectedPredefinedSrsCode(String selectedPredefinedSrsCode) {
        this.selectedPredefinedSrsCode = selectedPredefinedSrsCode;
    }

    @Command
    public void apply(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                BindUtils.postGlobalCommand(null, null, (String)"closeSRSManagerPopUp", null);
            }
        });
    }
}

