/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.data.proxy;

import java.util.List;
import org.openforis.collect.io.ReferenceDataImportStatus;
import org.openforis.collect.io.data.CSVDataImportJob;
import org.openforis.collect.io.data.proxy.DataParsingErrorProxy;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.manager.process.ProcessStatus;
import org.openforis.collect.manager.process.proxy.ProcessStatusProxy;
import org.openforis.collect.utils.Proxies;
import org.openforis.concurrency.Worker;

public class DataImportStatusProxy
extends ProcessStatusProxy {
    private List<DataParsingErrorProxy> errors;

    public DataImportStatusProxy(CSVDataImportJob job) {
        super((ProcessStatus)DataImportStatusProxy.createImportStatus(job));
        this.errors = Proxies.fromList(job.getParsingErrors(), DataParsingErrorProxy.class);
    }

    private static ReferenceDataImportStatus<ParsingError> createImportStatus(CSVDataImportJob job) {
        ReferenceDataImportStatus processStatus = new ReferenceDataImportStatus();
        processStatus.setStep(DataImportStatusProxy.toStep(job.getStatus()));
        processStatus.setTotal(100L);
        processStatus.setProcessed((long)job.getProgressPercent());
        processStatus.setErrorMessage(job.getErrorMessage());
        processStatus.setErrorMessageArgs((Object[])job.getErrorMessageArgs());
        return processStatus;
    }

    private static ProcessStatus.Step toStep(Worker.Status status) {
        switch (status) {
            case ABORTED: {
                return ProcessStatus.Step.CANCEL;
            }
            case COMPLETED: {
                return ProcessStatus.Step.COMPLETE;
            }
            case FAILED: {
                return ProcessStatus.Step.ERROR;
            }
            case PENDING: {
                return ProcessStatus.Step.INIT;
            }
            case RUNNING: {
                return ProcessStatus.Step.RUN;
            }
        }
        return null;
    }

    public List<DataParsingErrorProxy> getErrors() {
        return this.errors;
    }
}

