/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.io.metadata.codelist.CodeListExportTask;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.CodeList;

public class CodeListExportJob
extends Job {
    private CodeList list;
    private CodeListManager codeListManager;
    private File outputFile;
    private FileOutputStream outputStream;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.outputFile = File.createTempFile("batch_code_list_export", ".zip");
        this.outputStream = new FileOutputStream(this.outputFile);
    }

    protected void buildTasks() throws Throwable {
        CodeListExportTask t = (CodeListExportTask)this.createTask(CodeListExportTask.class);
        t.setOut(this.outputStream);
        t.setCodeListManager(this.codeListManager);
        t.setList(this.list);
        this.addTask((Worker)t);
    }

    protected void onCompleted() {
        super.onCompleted();
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void setList(CodeList list) {
        this.list = list;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

