/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.proxy.BooleanAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.CodeAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.CoordinateAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.DateAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.EntityDefinitionProxy;
import org.openforis.collect.metamodel.proxy.FileAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.LanguageSpecificTextProxy;
import org.openforis.collect.metamodel.proxy.NodeLabelProxy;
import org.openforis.collect.metamodel.proxy.NumberAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.PromptProxy;
import org.openforis.collect.metamodel.proxy.RangeAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.TaxonAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.TextAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.TimeAttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.VersionableSurveyObjectProxy;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.BooleanAttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.RangeAttributeDefinition;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.openforis.idm.metamodel.TimeAttributeDefinition;
import org.openforis.idm.metamodel.VersionableSurveyObject;

public class NodeDefinitionProxy
extends VersionableSurveyObjectProxy {
    protected transient NodeDefinition nodeDefinition;
    protected EntityDefinitionProxy parent;

    public NodeDefinitionProxy(EntityDefinitionProxy parent, NodeDefinition nodeDefinition) {
        super((VersionableSurveyObject)nodeDefinition);
        this.parent = parent;
        this.nodeDefinition = nodeDefinition;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<NodeDefinitionProxy> fromList(EntityDefinitionProxy parent, List<? extends NodeDefinition> list) {
        ArrayList<NodeDefinitionProxy> proxies = new ArrayList<NodeDefinitionProxy>();
        if (list == null) return proxies;
        for (NodeDefinition nodeDefinition : list) {
            void var5_5;
            Object var5_6 = null;
            CollectSurvey survey = (CollectSurvey)nodeDefinition.getSurvey();
            UIOptions uiOptions = survey.getUIOptions();
            boolean hidden = uiOptions.isHidden(nodeDefinition);
            if (hidden) continue;
            if (nodeDefinition instanceof AttributeDefinition) {
                if (nodeDefinition instanceof BooleanAttributeDefinition) {
                    BooleanAttributeDefinitionProxy booleanAttributeDefinitionProxy = new BooleanAttributeDefinitionProxy(parent, (BooleanAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof CodeAttributeDefinition) {
                    CodeAttributeDefinitionProxy codeAttributeDefinitionProxy = new CodeAttributeDefinitionProxy(parent, (CodeAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof CoordinateAttributeDefinition) {
                    CoordinateAttributeDefinitionProxy coordinateAttributeDefinitionProxy = new CoordinateAttributeDefinitionProxy(parent, (CoordinateAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof DateAttributeDefinition) {
                    DateAttributeDefinitionProxy dateAttributeDefinitionProxy = new DateAttributeDefinitionProxy(parent, (DateAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof FileAttributeDefinition) {
                    FileAttributeDefinitionProxy fileAttributeDefinitionProxy = new FileAttributeDefinitionProxy(parent, (FileAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof NumberAttributeDefinition) {
                    NumberAttributeDefinitionProxy numberAttributeDefinitionProxy = new NumberAttributeDefinitionProxy(parent, (NumberAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof RangeAttributeDefinition) {
                    RangeAttributeDefinitionProxy rangeAttributeDefinitionProxy = new RangeAttributeDefinitionProxy(parent, (RangeAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof TaxonAttributeDefinition) {
                    TaxonAttributeDefinitionProxy taxonAttributeDefinitionProxy = new TaxonAttributeDefinitionProxy(parent, (TaxonAttributeDefinition)nodeDefinition);
                } else if (nodeDefinition instanceof TextAttributeDefinition) {
                    TextAttributeDefinitionProxy textAttributeDefinitionProxy = new TextAttributeDefinitionProxy(parent, (TextAttributeDefinition)nodeDefinition);
                } else {
                    if (!(nodeDefinition instanceof TimeAttributeDefinition)) throw new RuntimeException("AttributeDefinition not supported: " + nodeDefinition.getClass().getSimpleName());
                    TimeAttributeDefinitionProxy timeAttributeDefinitionProxy = new TimeAttributeDefinitionProxy(parent, (TimeAttributeDefinition)nodeDefinition);
                }
            } else if (nodeDefinition instanceof EntityDefinition) {
                EntityDefinitionProxy entityDefinitionProxy = new EntityDefinitionProxy(parent, (EntityDefinition)nodeDefinition);
            }
            if (var5_5 == null) continue;
            proxies.add((NodeDefinitionProxy)var5_5);
        }
        return proxies;
    }

    public Set<QName> getAnnotationNames() {
        return this.nodeDefinition.getAnnotationNames();
    }

    @ExternalizedProperty
    public String getName() {
        return this.nodeDefinition.getName();
    }

    @ExternalizedProperty
    public boolean isMultiple() {
        return this.nodeDefinition.isMultiple();
    }

    @ExternalizedProperty
    public List<NodeLabelProxy> getLabels() {
        return NodeLabelProxy.fromNodeLabelList(this.nodeDefinition.getLabels());
    }

    @ExternalizedProperty
    public List<PromptProxy> getPrompts() {
        return PromptProxy.fromList(this.nodeDefinition.getPrompts());
    }

    @ExternalizedProperty
    public List<LanguageSpecificTextProxy> getDescriptions() {
        return LanguageSpecificTextProxy.fromList(this.nodeDefinition.getDescriptions());
    }

    @ExternalizedProperty
    public String getPath() {
        return this.nodeDefinition.getPath();
    }

    @ExternalizedProperty
    public String getUiTabName() {
        String tabName = this.nodeDefinition.getAnnotation(CollectAnnotations.Annotation.TAB_NAME.getQName());
        if (tabName != null) {
            return tabName;
        }
        return this.parent.getUiTabName();
    }

    @ExternalizedProperty
    public boolean isHideWhenNotRelevant() {
        boolean result = this.getUIOptions().isHideWhenNotRelevant(this.nodeDefinition);
        return result;
    }

    @ExternalizedProperty
    public int getColumn() {
        int result = this.getUIOptions().getColumn(this.nodeDefinition);
        return result;
    }

    @ExternalizedProperty
    public int getColumnSpan() {
        int result = this.getUIOptions().getColumnSpan(this.nodeDefinition);
        return result;
    }

    @ExternalizedProperty
    public Integer getWidth() {
        Integer width = this.getUIOptions().getWidth(this.nodeDefinition);
        return width;
    }

    @ExternalizedProperty
    public Integer getLabelWidth() {
        Integer width = this.getUIOptions().getLabelWidth(this.nodeDefinition);
        return width;
    }

    @ExternalizedProperty
    public UIOptions.Orientation getLabelOrientation() {
        UIOptions.Orientation orientation = this.getUIOptions().getLabelOrientation(this.nodeDefinition);
        return orientation;
    }

    public EntityDefinitionProxy getParent() {
        return this.parent;
    }

    protected UIOptions getUIOptions() {
        CollectSurvey survey = (CollectSurvey)this.nodeDefinition.getSurvey();
        return survey.getUIOptions();
    }

    protected CollectAnnotations getAnnotations() {
        CollectSurvey survey = (CollectSurvey)this.nodeDefinition.getSurvey();
        return survey.getAnnotations();
    }
}

