/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.OutputStream;
import java.util.List;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordIteratorJob;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.CoordinateAttribute;
import org.openforis.idm.model.Node;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class RecordCoordinatesKmlGeneratorJob
extends RecordIteratorJob {
    private CoordinateAttributeDefinition nodeDefinition;
    private OutputStream output;
    private CoordinateOperations coordinateOperations;
    private Document kmlDoc;
    private Kml kml;

    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        CollectSurvey survey = (CollectSurvey)this.nodeDefinition.getSurvey();
        this.kml = new Kml();
        this.kmlDoc = this.kml.createAndSetDocument().withName(survey.getName());
        if (this.coordinateOperations == null) {
            this.coordinateOperations = this.nodeDefinition.getSurvey().getContext().getCoordinateOperations();
        }
    }

    protected void processRecord(CollectRecord record) {
        List nodes = record.findNodesByPath(this.nodeDefinition.getPath());
        for (Node node : nodes) {
            this.processAttribute((CoordinateAttribute)node);
        }
    }

    private void processAttribute(CoordinateAttribute coordAttr) {
        if (coordAttr.isFilled()) {
            Coordinate coordinate = coordAttr.getValue();
            Coordinate wgs84Coordinate = this.coordinateOperations.convertTo(coordinate, "EPSG:4326");
            this.kmlDoc.createAndAddPlacemark().withName(((CollectRecord)coordAttr.getRecord()).getRootEntityKeyValues().toString()).withOpen(Boolean.TRUE).createAndSetPoint().addToCoordinates(wgs84Coordinate.getY().doubleValue(), wgs84Coordinate.getX().doubleValue());
        }
    }

    protected void onCompleted() {
        super.onCompleted();
        try {
            this.kml.marshal(this.output);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setNodeDefinition(CoordinateAttributeDefinition nodeDefinition) {
        this.nodeDefinition = nodeDefinition;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public void setCoordinateOperations(CoordinateOperations coordinateOperations) {
        this.coordinateOperations = coordinateOperations;
    }
}

