/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.metamodel.proxy.ModelVersionProxy;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.User;
import org.openforis.collect.model.proxy.BasicUserProxy;
import org.openforis.collect.model.proxy.EntityProxy;
import org.openforis.collect.model.proxy.UserProxy;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.model.Entity;

public class RecordProxy
implements Proxy {
    private transient CollectRecord record;
    private transient ProxyContext context;
    private boolean newRecord;
    private Integer errors;
    private Integer skipped;
    private Integer missing;
    private Integer missingErrors;
    private Integer missingWarnings;
    private Integer warnings;
    private UserProxy owner;

    public RecordProxy(CollectRecord record, ProxyContext context) {
        this(record, context, false);
    }

    public RecordProxy(CollectRecord record, ProxyContext context, boolean newRecord) {
        this.record = record;
        this.context = context;
        this.newRecord = newRecord;
        this.errors = record.getErrors();
        this.skipped = record.getSkipped();
        this.missing = record.getMissing();
        this.missingErrors = record.getMissingErrors();
        this.missingWarnings = record.getMissingWarnings();
        this.warnings = record.getWarnings();
        this.owner = record.getOwner() == null ? null : new UserProxy(record.getOwner());
    }

    public static List<RecordProxy> fromList(List<CollectRecord> records, ProxyContext context) {
        ArrayList<RecordProxy> result = new ArrayList<RecordProxy>();
        if (records != null) {
            for (CollectRecord collectRecord : records) {
                result.add(new RecordProxy(collectRecord, context));
            }
        }
        return result;
    }

    @ExternalizedProperty
    public int getSurveyId() {
        return this.record.getSurvey().getId();
    }

    @ExternalizedProperty
    public boolean isNewRecord() {
        return this.newRecord;
    }

    @ExternalizedProperty
    public boolean isPreview() {
        return this.record.isPreview();
    }

    @ExternalizedProperty
    public CollectRecord.Step getStep() {
        return this.record.getStep();
    }

    @ExternalizedProperty
    public CollectRecord.Step getDataStep() {
        return this.record.getDataStep();
    }

    @ExternalizedProperty
    public CollectRecord.State getState() {
        return this.record.getState();
    }

    @ExternalizedProperty
    public Date getCreationDate() {
        return this.record.getCreationDate();
    }

    @ExternalizedProperty
    public BasicUserProxy getCreatedBy() {
        User createdBy = this.record.getCreatedBy();
        return createdBy == null ? null : new BasicUserProxy(createdBy);
    }

    @ExternalizedProperty
    public Date getModifiedDate() {
        return this.record.getModifiedDate();
    }

    @ExternalizedProperty
    public Integer getId() {
        return this.record.getId();
    }

    @ExternalizedProperty
    public BasicUserProxy getModifiedBy() {
        User modifiedBy = this.record.getModifiedBy();
        return modifiedBy == null ? null : new BasicUserProxy(modifiedBy);
    }

    @ExternalizedProperty
    public EntityProxy getRootEntity() {
        Entity rootEntity = this.record.getRootEntity();
        return rootEntity == null ? null : new EntityProxy(null, this.record.getRootEntity(), this.context);
    }

    @ExternalizedProperty
    public ModelVersionProxy getVersion() {
        ModelVersion version = this.record.getVersion();
        return version == null ? null : new ModelVersionProxy(version);
    }

    @ExternalizedProperty
    public List<String> getRootEntityKeys() {
        return this.record.getRootEntityKeyValues();
    }

    @ExternalizedProperty
    public List<Integer> getEntityCounts() {
        return this.record.getEntityCounts();
    }

    @ExternalizedProperty
    public List<String> getSummaryValues() {
        return this.record.getSummaryValues();
    }

    @ExternalizedProperty
    public boolean isEntryComplete() {
        if (this.record.getStep() != null) {
            switch (this.record.getStep()) {
                case ENTRY: {
                    return false;
                }
                case CLEANSING: 
                case ANALYSIS: {
                    return true;
                }
            }
        }
        return false;
    }

    @ExternalizedProperty
    public boolean isCleansingComplete() {
        if (this.record.getStep() != null) {
            switch (this.record.getStep()) {
                case ANALYSIS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Integer getErrors() {
        return this.errors;
    }

    public void setErrors(Integer errors) {
        this.errors = errors;
    }

    public Integer getSkipped() {
        return this.skipped;
    }

    public void setSkipped(Integer skipped) {
        this.skipped = skipped;
    }

    public Integer getMissing() {
        return this.missing;
    }

    public void setMissing(Integer missing) {
        this.missing = missing;
    }

    public Integer getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Integer warnings) {
        this.warnings = warnings;
    }

    public Integer getMissingErrors() {
        return this.missingErrors;
    }

    public void setMissingErrors(Integer missingErrors) {
        this.missingErrors = missingErrors;
    }

    public Integer getMissingWarnings() {
        return this.missingWarnings;
    }

    public void setMissingWarnings(Integer missingWarnings) {
        this.missingWarnings = missingWarnings;
    }

    public UserProxy getOwner() {
        return this.owner;
    }

    public void setOwner(UserProxy owner) {
        this.owner = owner;
    }
}

