/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.openforis.collect.Proxy;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.io.SurveyBackupJob;
import org.openforis.collect.io.data.CSVDataExportProcess;
import org.openforis.collect.io.data.DataExportStatus;
import org.openforis.collect.io.data.backup.BackupStorageManager;
import org.openforis.collect.io.data.csv.CSVDataExportParameters;
import org.openforis.collect.io.data.csv.CSVDataExportParametersBase;
import org.openforis.collect.io.data.proxy.DataExportProcessProxy;
import org.openforis.collect.io.proxy.SurveyBackupJobProxy;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.User;
import org.openforis.collect.remoting.service.RemoteCollectCloneDataRestoreJob;
import org.openforis.collect.utils.ExecutorServiceUtil;
import org.openforis.collect.web.session.SessionState;
import org.openforis.concurrency.Job;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.Schema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.annotation.Transactional;

public class DataExportService {
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private CollectJobManager jobManager;
    @Autowired
    private BackupStorageManager backupStorageManager;
    private CSVDataExportProcess dataExportProcess;
    private SurveyBackupJob backupJob;

    @Transactional
    public Proxy export(String rootEntityName, int stepNumber, Integer entityId, boolean includeAllAncestorAttributes, boolean includeEnumeratedEntities, boolean includeCompositeAttributeMergedColumn, boolean codeAttributeExpanded, boolean onlyOwnedRecords, String[] rootEntityKeyValues, boolean includeKMLColumnForCoordinates, boolean includeCodeItemLabelColumn, String headingSource, String languageCode, boolean includeGroupingLabels) throws IOException {
        if (this.dataExportProcess == null || !((DataExportStatus)this.dataExportProcess.getStatus()).isRunning()) {
            this.resetJobs();
            SessionState sessionState = this.sessionManager.getSessionState();
            CollectSurvey survey = sessionState.getActiveSurvey();
            File outputFile = File.createTempFile("collect_data_export_" + survey.getName(), ".zip");
            CollectRecord.Step step = CollectRecord.Step.valueOf((int)stepNumber);
            Schema schema = survey.getSchema();
            EntityDefinition rootEntityDefn = schema.getRootEntityDefinition(rootEntityName);
            RecordFilter recordFilter = this.createRecordFilter(survey, rootEntityDefn.getId(), onlyOwnedRecords, rootEntityKeyValues);
            recordFilter.setStepGreaterOrEqual(step);
            CSVDataExportProcess process = (CSVDataExportProcess)this.appContext.getBean(CSVDataExportProcess.class);
            process.setOutputFile(outputFile);
            process.setRecordFilter(recordFilter);
            process.setEntityId(entityId);
            process.setAlwaysGenerateZipFile(true);
            CSVDataExportParameters config = new CSVDataExportParameters();
            config.setIncludeAllAncestorAttributes(includeAllAncestorAttributes);
            config.setIncludeEnumeratedEntities(includeEnumeratedEntities);
            config.setIncludeCompositeAttributeMergedColumn(includeCompositeAttributeMergedColumn);
            config.setIncludeKMLColumnForCoordinates(includeKMLColumnForCoordinates);
            config.setCodeAttributeExpanded(codeAttributeExpanded);
            config.setIncludeCodeItemLabelColumn(includeCodeItemLabelColumn);
            config.setHeadingSource(CSVDataExportParametersBase.HeadingSource.valueOf((String)headingSource));
            config.setLanguageCode(languageCode);
            config.setIncludeGroupingLabels(includeGroupingLabels);
            process.setConfiguration(config);
            process.init();
            this.dataExportProcess = process;
            ExecutorServiceUtil.executeInCachedPool((Callable)process);
        }
        return this.getCurrentJob();
    }

    @Transactional
    public Proxy backup(String surveyName) {
        CollectSurvey survey = this.surveyManager.get(surveyName);
        return this.fullExport(survey, true, false, null, true);
    }

    @Transactional
    public Proxy fullExport(boolean includeRecordFiles, boolean onlyOwnedRecords, String[] rootEntityKeyValues) {
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectSurvey survey = sessionState.getActiveSurvey();
        return this.fullExport(survey, includeRecordFiles, onlyOwnedRecords, rootEntityKeyValues, false);
    }

    @Transactional
    public Proxy fullExport(CollectSurvey survey, boolean includeRecordFiles, boolean onlyOwnedRecords, String[] rootEntityKeyValues, boolean full) {
        if (this.backupJob == null || !this.backupJob.isRunning()) {
            this.resetJobs();
            RecordFilter filter = this.createRecordFilter(survey, null, onlyOwnedRecords, rootEntityKeyValues);
            SurveyBackupJob job = (SurveyBackupJob)this.jobManager.createJob(SurveyBackupJob.class);
            job.setFull(full);
            if (full) {
                job.setOutputFormat(SurveyBackupJob.OutputFormat.DESKTOP_FULL);
            } else {
                job.setOutputFormat(SurveyBackupJob.OutputFormat.ONLY_DATA);
            }
            job.setSurvey(survey);
            job.setIncludeData(true);
            job.setIncludeRecordFiles(includeRecordFiles);
            job.setRecordFilter(filter);
            this.backupJob = job;
            this.jobManager.start((Job)job);
        }
        return this.getCurrentJob();
    }

    public Map<String, Object> getLastBackupInfo(String surveyName) {
        final Date date = this.backupStorageManager.getLastBackupDate(surveyName);
        CollectSurvey survey = this.surveyManager.get(surveyName);
        RecordFilter filter = new RecordFilter(survey);
        filter.setModifiedSince(date);
        final int updatedRecordsSinceBackupDateCount = this.recordManager.countRecords(filter);
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("date", date);
                this.put("updatedRecordsSinceBackup", updatedRecordsSinceBackupDateCount);
            }
        };
        return map;
    }

    @Secured(value={"ROLE_ADMIN"})
    public String sendBackupToRemoteClone(String surveyName) {
        RemoteCollectCloneDataRestoreJob job = (RemoteCollectCloneDataRestoreJob)this.jobManager.createJob(RemoteCollectCloneDataRestoreJob.class);
        job.setSurveyName(surveyName);
        this.jobManager.start((Job)job);
        return job.getId().toString();
    }

    private RecordFilter createRecordFilter(CollectSurvey survey, Integer rootEntityId, boolean onlyOwnedRecords, String[] rootEntityKeyValues) {
        RecordFilter recordFilter = new RecordFilter(survey, rootEntityId);
        if (onlyOwnedRecords) {
            SessionState sessionState = this.sessionManager.getSessionState();
            User user = sessionState.getUser();
            recordFilter.setOwnerId(user.getId().intValue());
        }
        recordFilter.setKeyValues(rootEntityKeyValues);
        return recordFilter;
    }

    private void resetJobs() {
        this.backupJob = null;
        this.dataExportProcess = null;
    }

    public void abort() {
        if (this.dataExportProcess != null) {
            this.dataExportProcess.cancel();
        }
        if (this.backupJob != null) {
            this.backupJob.abort();
        }
    }

    public Proxy getCurrentJob() {
        if (this.backupJob != null) {
            return new SurveyBackupJobProxy(this.backupJob);
        }
        if (this.dataExportProcess != null) {
            return new DataExportProcessProxy(this.dataExportProcess);
        }
        return null;
    }
}

