/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import org.openforis.collect.manager.RecordIndexException;
import org.openforis.collect.manager.RecordIndexManager;
import org.openforis.collect.model.CollectRecord;

public class RecordIndexProcess
implements Runnable {
    private RecordIndexManager indexManager;
    private CollectRecord record;
    private boolean running;

    public RecordIndexProcess(RecordIndexManager indexManager, CollectRecord record) {
        this.indexManager = indexManager;
        this.record = record;
        this.running = false;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.indexManager.index(this.record);
        }
        catch (RecordIndexException e) {
            throw new RuntimeException(e);
        }
        this.running = false;
    }

    public void cancel() {
        this.running = false;
        this.indexManager.cancelIndexing();
    }

    public boolean isRunning() {
        return this.running;
    }
}

