/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.util.List;
import org.openforis.collect.manager.CannotDeleteUserException;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.manager.UserPersistenceException;
import org.openforis.collect.model.User;
import org.openforis.collect.model.proxy.UserProxy;
import org.openforis.collect.utils.Proxies;
import org.openforis.idm.metamodel.PersistedObject;
import org.springframework.beans.factory.annotation.Autowired;

public class UserService {
    @Autowired
    private UserManager userManager;
    @Autowired
    private SessionManager sessionManager;

    public UserProxy loadById(int userId) {
        User user = (User)this.userManager.loadById((Object)userId);
        return this.getProxy(user);
    }

    public UserProxy loadByUserName(String userName) {
        User user = this.userManager.loadByUserName(userName);
        return this.getProxy(user);
    }

    public List<UserProxy> loadAll() {
        List<UserProxy> result = null;
        List users = this.userManager.loadAll();
        if (users != null) {
            result = Proxies.fromList(users, UserProxy.class);
        }
        return result;
    }

    public UserProxy save(UserProxy user) throws UserPersistenceException {
        User u = user.toUser();
        this.userManager.save((PersistedObject)u, this.sessionManager.getLoggedUser());
        UserProxy proxy = new UserProxy(u);
        return proxy;
    }

    public void delete(int id) throws CannotDeleteUserException {
        this.userManager.deleteById((Object)id);
    }

    private UserProxy getProxy(User user) {
        if (user != null) {
            UserProxy proxy = new UserProxy(user);
            return proxy;
        }
        return null;
    }
}

