/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.ws;

import java.util.Timer;
import java.util.TimerTask;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.web.ws.WebSocketMessageSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppWS {
    @Autowired
    private WebSocketMessageSender messageSender;

    public void sendMessage(MessageType type) {
        this.sendMessage(type, 0);
    }

    public void sendMessage(MessageType type, int delay) {
        this.sendMessage(new WebSocketMessageSender.Message(type.name()), delay);
    }

    public void sendMessage(WebSocketMessageSender.Message message) {
        this.sendMessage(message, 0);
    }

    private void sendMessage(final WebSocketMessageSender.Message message, int delay) {
        if (delay > 0) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    AppWS.this.messageSender.send(message);
                }
            }, delay);
        } else {
            this.messageSender.send(message);
        }
    }

    public static class RecordEventMessage
    extends WebSocketMessageSender.Message {
        private Object event;

        public RecordEventMessage(Object event) {
            super(MessageType.RECORD_UPDATED.name());
            this.event = event;
        }

        public Object getEvent() {
            return this.event;
        }
    }

    public static class RecordUnlockedMessage
    extends RecordMessage {
        public RecordUnlockedMessage(int recordId) {
            super(MessageType.RECORD_UNLOCKED, recordId);
        }
    }

    public static class RecordLockedMessage
    extends RecordMessage {
        private String lockedBy;

        public RecordLockedMessage(int recordId, String lockedBy) {
            super(MessageType.RECORD_LOCKED, recordId);
            this.lockedBy = lockedBy;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }
    }

    private static abstract class RecordMessage
    extends WebSocketMessageSender.Message {
        private Integer recordId;

        public RecordMessage(MessageType type, int recordId) {
            super(type.name());
            this.recordId = recordId;
        }

        public Integer getRecordId() {
            return this.recordId;
        }
    }

    public static class SurveyUpdateMessage
    extends WebSocketMessageSender.Message {
        private SurveySummary survey;

        public SurveyUpdateMessage(MessageType updateType, SurveySummary survey) {
            super(updateType.name());
            this.survey = survey;
        }

        public SurveySummary getSurvey() {
            return this.survey;
        }
    }

    public static enum MessageType {
        SURVEYS_UPDATED,
        RECORD_LOCKED,
        RECORD_UNLOCKED,
        RECORD_UPDATED;

    }
}

