/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.model.CollectSurvey;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zkplus.databind.BindingListModelList;

public abstract class SurveyObjectBaseVM<T>
extends SurveyBaseVM {
    private static final String NAME_TEXTBOX_ID = "nameTextbox";
    public static final String VALIDATE_COMMAND = "validate";
    public static final String APPLY_CHANGES_COMMAND = "applyChanges";
    public static final String COMMIT_CHANGES_COMMAND = "commitChanges";
    protected boolean newItem;
    protected T selectedItem;
    protected T editedItem;
    protected boolean changed;
    protected FormObject<T> formObject;
    protected boolean commitChangesOnApply = true;
    @Wire
    private Component formContainer;

    protected void doAfterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        Selectors.wireComponents((Component)view, (Object)this, (boolean)false);
        Selectors.wireEventListeners((Component)view, (Object)this);
    }

    @Override
    public void undoLastChanges() {
        super.undoLastChanges();
        this.resetEditedItem();
    }

    public BindingListModelList<T> getItems() {
        List<T> items = this.getItemsInternal();
        return new BindingListModelList(items, false);
    }

    protected abstract List<T> getItemsInternal();

    @Command
    public void newItem(final @ContextParam(value=ContextType.BINDER) Binder binder) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                SurveyObjectBaseVM.this.performNewItemCreation(binder);
            }
        });
    }

    protected void performNewItemCreation(Binder binder) {
        T newInstance = this.createItemInstance();
        this.newItem = true;
        this.setEditedItem(newInstance);
        this.setSelectedItem(null);
        this.changed = false;
        this.notifyChange("editedItem", "formObject", "items", "selectedItem", "changed");
        this.validateForm(binder);
        this.setFocusOnNameTextbox();
    }

    protected void validateForm(Binder binder) {
        this.dispatchValidateCommand(binder);
    }

    protected void dispatchValidateCommand(Binder binder) {
        binder.postCommand(VALIDATE_COMMAND, null);
    }

    protected void dispatchApplyChangesCommand(Binder binder) {
        binder.postCommand(APPLY_CHANGES_COMMAND, null);
    }

    @Override
    @GlobalCommand
    public void currentLanguageChanged() {
        super.currentLanguageChanged();
        if (this.isEditingItem()) {
            this.performItemSelection(this.editedItem);
        }
    }

    @GlobalCommand
    public void validateAll(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.dispatchValidateCommand(binder);
    }

    @Command
    public void validate() {
    }

    @Command
    public void applyChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.changed = true;
        if (this.commitChangesOnApply) {
            this.commitChanges(binder);
        }
    }

    @Command
    public void commitChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.formObject.saveTo(this.editedItem, this.currentLanguageCode);
        if (this.newItem) {
            this.addNewItemToSurvey();
            this.setSelectedItem(this.editedItem);
            this.newItem = false;
            this.notifyChange("newItem");
        }
        this.notifyChange("items", "selectedItem", "changed");
        this.dispatchSurveyChangedCommand();
    }

    @Command
    public void selectionChanged(final @BindingParam(value="selectedItem") T item) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormCompleteConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                SurveyObjectBaseVM.this.performItemSelection(item);
            }

            @Override
            public void onCancel() {
                SurveyObjectBaseVM.this.setSelectedItem(SurveyObjectBaseVM.this.selectedItem);
                SurveyObjectBaseVM.this.notifyChange("selectedItem");
            }
        });
    }

    protected void performItemSelection(T item) {
        this.newItem = false;
        this.changed = false;
        this.setSelectedItem(item);
        this.setEditedItem(item);
        this.notifyChange("selectedItem", "formObject", "editedItem");
        this.dispatchCurrentFormValidatedCommand(true);
    }

    @Command
    @NotifyChange(value={"items"})
    public void moveSelectedItemUp() {
        this.moveSelectedItem(true);
    }

    @Command
    @NotifyChange(value={"items"})
    public void moveSelectedItemDown() {
        this.moveSelectedItem(false);
    }

    protected int getSelectedItemIndex() {
        List<T> items = this.getItemsInternal();
        int index = items.indexOf(this.selectedItem);
        return index;
    }

    protected void moveSelectedItem(boolean up) {
        int indexFrom = this.getSelectedItemIndex();
        int indexTo = up ? indexFrom - 1 : indexFrom + 1;
        this.moveSelectedItem(indexTo);
    }

    protected void moveSelectedItem(int indexTo) {
        this.dispatchSurveyChangedCommand();
        this.moveSelectedItemInSurvey(indexTo);
    }

    protected abstract void moveSelectedItemInSurvey(int var1);

    @DependsOn(value={"items", "selectedItem"})
    public boolean isMoveSelectedItemUpDisabled() {
        int index = this.getSelectedItemIndex();
        return index <= 0;
    }

    @DependsOn(value={"items", "selectedItem"})
    public boolean isMoveSelectedItemDownDisabled() {
        if (this.selectedItem != null) {
            List<T> items = this.getItemsInternal();
            int size = items.size();
            int index = this.getSelectedItemIndex();
            return index < 0 || index >= size - 1;
        }
        return true;
    }

    protected abstract FormObject<T> createFormObject();

    protected abstract T createItemInstance();

    @NotifyChange(value={"items"})
    protected abstract void addNewItemToSurvey();

    @Command
    public void deleteItem(final @BindingParam(value="item") T item) {
        MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                SurveyObjectBaseVM.this.performDeleteItem(item);
            }
        }, this.getConfirmDeleteMessageKey());
        params.setOkLabelKey("global.delete_item");
        MessageUtil.showConfirm(params);
    }

    protected String getConfirmDeleteMessageKey() {
        return "global.item.confirm_remove";
    }

    protected void performDeleteItem(T item) {
        this.deleteItemFromSurvey(item);
        this.changed = false;
        this.notifyChange("items", "changed");
        if (item.equals(this.selectedItem)) {
            this.resetEditedItem();
            this.dispatchCurrentFormValidatedCommand(true);
            this.notifyChange("currentFormValid");
        }
        this.dispatchSurveyChangedCommand();
    }

    protected void resetEditedItem() {
        this.formObject = this.createFormObject();
        this.editedItem = null;
        this.selectedItem = null;
        this.notifyChange("formObject", "editedItem", "selectedItem");
    }

    protected String suggestInternalName(String label) {
        String name = label.trim().toLowerCase(Locale.ENGLISH).replaceAll("\\W", "_");
        name = StringUtils.strip((String)name, (String)"_");
        return name;
    }

    protected String suggestLabel(String internalName) {
        String label = internalName.replaceAll("_", " ");
        label = WordUtils.capitalize((String)label);
        return label;
    }

    protected abstract void deleteItemFromSurvey(T var1);

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(T item) {
        this.selectedItem = item;
    }

    public FormObject<T> getFormObject() {
        return this.formObject;
    }

    public T getEditedItem() {
        return this.editedItem;
    }

    public void setEditedItem(T editedItem) {
        CollectSurvey survey;
        this.editedItem = editedItem;
        this.formObject = this.createFormObject();
        if (editedItem != null && (survey = this.getSurvey()) != null) {
            this.formObject.loadFrom(editedItem, this.currentLanguageCode);
        }
        this.notifyChange("editedItem", "formObject");
    }

    protected void setFocusOnNameTextbox() {
        HtmlBasedComponent textbox = this.getNameTextbox();
        if (textbox != null) {
            textbox.setFocus(true);
        }
    }

    protected HtmlBasedComponent getNameTextbox() {
        if (this.formContainer == null) {
            return null;
        }
        HtmlBasedComponent textbox = (HtmlBasedComponent)Path.getComponent((IdSpace)this.formContainer.getSpaceOwner(), (String)NAME_TEXTBOX_ID);
        return textbox;
    }

    @DependsOn(value={"editedItem"})
    public boolean isEditingItem() {
        return this.editedItem != null;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public boolean isCommitChangesOnApply() {
        return this.commitChangesOnApply;
    }

    public void setCommitChangesOnApply(boolean commitChangesOnApply) {
        this.commitChangesOnApply = commitChangesOnApply;
    }
}

