/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openforis.collect.designer.component.SchemaTreeModel;
import org.openforis.collect.designer.component.SurveyObjectTreeModelCreator;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.User;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.openforis.idm.metamodel.VersionableSurveyObject;

public class SchemaTreeModelCreator
extends SurveyObjectTreeModelCreator {
    public SchemaTreeModelCreator(SurveyManager surveyManager, User loggedUser, ModelVersion version, Predicate<SurveyObject> includeNodePredicate, boolean includeRootEntity, boolean includeEmptyNodes, String labelLanguage) {
        this(surveyManager, loggedUser, version, null, includeNodePredicate, includeRootEntity, includeEmptyNodes, labelLanguage);
    }

    public SchemaTreeModelCreator(SurveyManager surveyManager, User loggedUser, ModelVersion version, Predicate<SurveyObject> disabledNodePredicate, Predicate<SurveyObject> includeNodePredicate, boolean includeRootEntity, boolean includeEmptyNodes, String labelLanguage) {
        super(surveyManager, loggedUser, version, disabledNodePredicate, includeNodePredicate, includeRootEntity, includeEmptyNodes, labelLanguage);
    }

    @Override
    protected List<SchemaTreeModel.SchemaTreeNode> createFirstLevelNodes(EntityDefinition rootEntity) {
        if (this.includeRootEntity) {
            return Arrays.asList(this.createChildNode((NodeDefinition)rootEntity));
        }
        return this.createChildNodes((SurveyObject)rootEntity);
    }

    @Override
    protected List<SchemaTreeModel.SchemaTreeNode> createChildNodes(SurveyObject surveyObject) {
        ArrayList<SchemaTreeModel.SchemaTreeNode> childNodes = new ArrayList<SchemaTreeModel.SchemaTreeNode>();
        if (surveyObject instanceof EntityDefinition) {
            List childDefinitions = ((EntityDefinition)surveyObject).getChildDefinitions();
            for (NodeDefinition nodeDefn : childDefinitions) {
                SchemaTreeModel.SchemaTreeNode childNode = this.createChildNode(nodeDefn);
                if (childNode == null) continue;
                childNodes.add(childNode);
            }
        } else if (surveyObject instanceof AttributeDefinition) {
            childNodes = null;
        }
        return childNodes;
    }

    private SchemaTreeModel.SchemaTreeNode createChildNode(NodeDefinition nodeDefn) {
        if (this.version == null || this.version.isApplicable((VersionableSurveyObject)nodeDefn)) {
            SchemaTreeModel.SchemaNodeData data = new SchemaTreeModel.SchemaNodeData((SurveyObject)nodeDefn, nodeDefn.getName(), false, false);
            SchemaTreeModel.SchemaTreeNode childNode = (SchemaTreeModel.SchemaTreeNode)this.createNode(data, false);
            return childNode;
        }
        return null;
    }
}

