/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.openforis.collect.client.AbstractClient;
import org.openforis.collect.config.CollectConfiguration;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;

public class ClientUserGroupManager
extends AbstractClient
implements UserGroupManager {
    private UserGroup defaultPublicUserGroup;

    public UserGroup getDefaultPublicUserGroup() {
        if (this.defaultPublicUserGroup == null) {
            this.defaultPublicUserGroup = this.findByName("default_public_group");
        }
        return this.defaultPublicUserGroup;
    }

    public String getDefaultPrivateUserGroupName(User user) {
        return user.getUsername() + "_private_group";
    }

    public UserGroup loadById(Integer id) {
        return this.getOne(CollectConfiguration.getUsersRestfulApiUrl() + "/group/" + id, UserGroup.class);
    }

    public List<UserGroup> loadAll() {
        return this.getList(CollectConfiguration.getUsersRestfulApiUrl() + "/group", UserGroup.class);
    }

    public UserInGroup findUserInGroup(int userGroupId, final int userId) {
        List<UserInGroup> userInGroups = this.findUsersInGroup(userGroupId);
        return (UserInGroup)CollectionUtils.find(userInGroups, (Predicate)new Predicate(){

            public boolean evaluate(Object userInGroup) {
                return ((UserInGroup)userInGroup).getUserId().equals(userId);
            }
        });
    }

    public List<UserInGroup> findUsersInGroup(int userGroupId) {
        List<Map> userGroupRelations = this.getList(CollectConfiguration.getUsersRestfulApiUrl() + "/group/" + userGroupId + "/users", Map.class);
        ArrayList<UserInGroup> result = new ArrayList<UserInGroup>();
        for (Map userGroupRelation : userGroupRelations) {
            UserInGroup userInGroup = new UserInGroup();
            userInGroup.setGroupId(Integer.valueOf(userGroupId));
            userInGroup.setUserId(Integer.valueOf(((Double)userGroupRelation.get("userId")).intValue()));
            userInGroup.setJoinStatus(UserInGroup.UserGroupJoinRequestStatus.fromCode((String)((String)userGroupRelation.get("statusCode"))));
            userInGroup.setRole(UserInGroup.UserGroupRole.fromCode((String)((String)userGroupRelation.get("roleCode"))));
            result.add(userInGroup);
        }
        return result;
    }

    public List<UserGroup> findAllUserDefinedGroups() {
        return null;
    }

    public List<UserGroup> findAllRelatedUserGroups(User user) {
        return this.findByUser(user);
    }

    public List<UserGroup> findDescendantGroups(UserGroup group) {
        return null;
    }

    public UserInGroup findUserInGroupOrDescendants(int userGroupId, int userId) {
        return this.findUserInGroup(userGroupId, userId);
    }

    public UserGroup findByName(final String name) {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        };
        List<UserGroup> list = this.getList(CollectConfiguration.getUsersRestfulApiUrl() + "/group", (Map<String, Object>)params, UserGroup.class);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<UserGroup> findByUser(User user) {
        List<Map> userGroupRelations = this.getList(CollectConfiguration.getUsersRestfulApiUrl() + "/user/" + user.getId() + "/groups", Map.class);
        ArrayList<UserGroup> result = new ArrayList<UserGroup>();
        for (Map userGroupRelation : userGroupRelations) {
            Double groupId = (Double)userGroupRelation.get("groupId");
            UserGroup group = this.loadById(groupId.intValue());
            result.add(group);
        }
        result.add(this.getDefaultPublicUserGroup());
        return result;
    }

    public List<UserGroup> findPublicUserGroups() {
        List<UserGroup> result = this.getList(CollectConfiguration.getUsersRestfulApiUrl() + "/group", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("visibility", "PUBLIC");
                this.put("systemDefined", false);
            }
        }, UserGroup.class);
        return result;
    }

    public UserGroup save(UserGroup userGroup, User activeUser) {
        Integer id = userGroup.getId();
        if (id == null) {
            return this.post(CollectConfiguration.getUsersRestfulApiUrl() + "/group", userGroup, UserGroup.class);
        }
        return this.patch(CollectConfiguration.getUsersRestfulApiUrl() + "/group/" + id, userGroup, UserGroup.class);
    }

    public void delete(UserGroup obj) {
        this.deleteById(obj.getId());
    }

    public void deleteById(Integer userGroupId) {
        this.delete(CollectConfiguration.getUsersRestfulApiUrl() + "/group/" + userGroupId);
    }

    public void deleteRelation(int userGroupId, int userId) {
    }

    public void deleteAllUserRelations(User user) {
    }

    public Map<String, String> getQualifiers(int groupId, int userId) {
        return null;
    }

    public UserGroup findUserGroupByResource(String resourceType, String resourceId) {
        Map result = this.getOne(CollectConfiguration.getUsersRestfulApiUrl() + "/resource/" + resourceType + "/" + resourceId, Map.class);
        if (result == null) {
            return null;
        }
        String groupIdStr = (String)result.get("groupId");
        int userGroupId = Integer.parseInt(groupIdStr);
        return this.loadById(userGroupId);
    }

    public List<String> findResourcesByUserGroup(int userGroupId, String resourceType) {
        return this.getList(CollectConfiguration.getUsersRestfulApiUrl() + "/group" + userGroupId + "/resource/" + resourceType, String.class);
    }

    public void associateResource(int userGroupId, String resourceType, String resourceId) {
        String url = CollectConfiguration.getUsersRestfulApiUrl() + "/group" + userGroupId + "/resource/" + resourceType + "/" + resourceId;
        this.post(url, null, Boolean.class);
    }

    public void disassociateResource(int userGroupId, String resourceType, String resourceId) {
        String url = CollectConfiguration.getUsersRestfulApiUrl() + "/group" + userGroupId + "/resource/" + resourceType + "/" + resourceId;
        super.delete(url);
    }

    public UserGroup createDefaultPrivateUserGroup(User user, User createdByUser) {
        return null;
    }

    public void joinToDefaultPublicGroup(User user, UserInGroup.UserGroupRole role) {
    }
}

