/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.BooleanAttributeDefinition;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.springframework.stereotype.Component;

@Component
public class CollectEarthSurveyValidator
extends SurveyValidator {
    private Pattern INVALID_NODE_NAME_PATTERN = Pattern.compile(".*_\\d*$");
    public static final CollectEarthField[] REQUIRED_FIELDS = new CollectEarthField[]{new CollectEarthField("id", TextAttributeDefinition.class), new CollectEarthField("operator", TextAttributeDefinition.class), new CollectEarthField("location", CoordinateAttributeDefinition.class), new CollectEarthField("plot_file", TextAttributeDefinition.class), new CollectEarthField("actively_saved", BooleanAttributeDefinition.class), new CollectEarthField("actively_saved_on", DateAttributeDefinition.class)};
    public static final List<String> REQUIRED_FIELD_NAMES = CollectionUtils.project(Arrays.asList(REQUIRED_FIELDS), (String)"name");

    public SurveyValidator.SurveyValidationResults validate(CollectSurvey survey, SurveyValidator.ValidationParameters parameters) {
        SurveyValidator.SurveyValidationResults results = super.validate(survey, parameters);
        results.addResults(this.validateAllRequiredFieldsDefined(survey));
        return results;
    }

    protected List<SurveyValidator.SurveyValidationResult> validateEntity(EntityDefinition def, SurveyValidator.ValidationParameters validationParameters) {
        List results = super.validateEntity(def, validationParameters);
        EntityDefinition rootEntityDef = def.getRootEntity();
        if (def != rootEntityDef) {
            if (def.getAncestorEntityDefinitions().size() > 1) {
                results.add(new SurveyValidator.SurveyValidationResult(def.getPath(), "survey.validation.collect_earth.nested_entities_not_supported", new String[0]));
            } else if (def.isMultiple() && !def.isEnumerable()) {
                results.add(new SurveyValidator.SurveyValidationResult(def.getPath(), "survey.validation.collect_earth.multiple_entities_not_supported", new String[0]));
            }
        }
        return results;
    }

    private List<SurveyValidator.SurveyValidationResult> validateAllRequiredFieldsDefined(CollectSurvey survey) {
        ArrayList<SurveyValidator.SurveyValidationResult> results = new ArrayList<SurveyValidator.SurveyValidationResult>();
        EntityDefinition rootEntityDef = this.getMainRootEntityDefinition(survey);
        for (CollectEarthField field : REQUIRED_FIELDS) {
            String fieldName = field.getName();
            try {
                String foundType;
                NodeDefinition foundFieldDef = rootEntityDef.getChildDefinition(fieldName);
                if (field.getType().isAssignableFrom(foundFieldDef.getClass())) continue;
                Class<? extends AttributeDefinition> type = field.getType();
                AttributeType expectedAttributeType = AttributeType.valueOf(type);
                String expectedType = expectedAttributeType.getLabel();
                if (foundFieldDef instanceof AttributeDefinition) {
                    AttributeType foundTypeEnum = AttributeType.valueOf((AttributeDefinition)foundFieldDef);
                    foundType = foundTypeEnum.getLabel();
                } else {
                    foundType = NodeType.ENTITY.getLabel();
                }
                results.add(new SurveyValidator.SurveyValidationResult(rootEntityDef.getPath() + "/" + fieldName, "survey.validation.collect_earth.unexpected_field_type", new String[]{expectedType, foundType}));
            }
            catch (Exception e) {
                results.add(new SurveyValidator.SurveyValidationResult(rootEntityDef.getPath() + "/" + fieldName, "survey.validation.collect_earth.missing_required_field", new String[0]));
            }
        }
        return results;
    }

    public boolean validateRootEntityName(String name) {
        return "plot".equals(name);
    }

    public boolean validateNodeName(String name) {
        return super.validateNodeName(name) && !this.INVALID_NODE_NAME_PATTERN.matcher(name).matches();
    }

    protected String getInvalidNodeNameMessageKey() {
        return "survey.validation.collect_earth.invalid_node_name";
    }

    protected EntityDefinition getMainRootEntityDefinition(CollectSurvey survey) {
        return survey.getSchema().getFirstRootEntityDefinition();
    }

    private static class CollectEarthField {
        private String name;
        private Class<? extends AttributeDefinition> type;

        public CollectEarthField(String name, Class<? extends AttributeDefinition> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends AttributeDefinition> getType() {
            return this.type;
        }
    }
}

