/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIConfiguration;
import org.openforis.collect.metamodel.ui.UIModelObject;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.uiconfiguration.view.Views;
import org.openforis.collect.metamodel.view.AttributeDefView;
import org.openforis.collect.metamodel.view.CodeAttributeDefView;
import org.openforis.collect.metamodel.view.CodeListItemView;
import org.openforis.collect.metamodel.view.CodeListView;
import org.openforis.collect.metamodel.view.CoordinateAttributeDefView;
import org.openforis.collect.metamodel.view.EntityDefView;
import org.openforis.collect.metamodel.view.FileAttributeDefView;
import org.openforis.collect.metamodel.view.ModelVersionView;
import org.openforis.collect.metamodel.view.NodeDefView;
import org.openforis.collect.metamodel.view.NumberAttributeDefView;
import org.openforis.collect.metamodel.view.PrecisionView;
import org.openforis.collect.metamodel.view.SpatialReferenceSystemView;
import org.openforis.collect.metamodel.view.SurveyView;
import org.openforis.collect.metamodel.view.TaxonAttributeDefView;
import org.openforis.collect.metamodel.view.TextAttributeDefView;
import org.openforis.collect.metamodel.view.UnitView;
import org.openforis.collect.metamodel.view.ViewContext;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLabel;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.openforis.idm.metamodel.Unit;

public class SurveyViewGenerator {
    private boolean includeCodeListValues = false;
    private String languageCode;

    public SurveyViewGenerator(String languageCode) {
        this.languageCode = languageCode;
    }

    public List<SurveyView> generateViews(List<CollectSurvey> surveys) {
        ArrayList<SurveyView> result = new ArrayList<SurveyView>();
        for (CollectSurvey s : surveys) {
            result.add(this.generateView(s));
        }
        return result;
    }

    public SurveyView generateView(CollectSurvey survey) {
        return this.generateView(survey, null, null);
    }

    public SurveyView generateView(CollectSurvey survey, UserGroup userGroup, UserInGroup.UserGroupRole userInSurveyGroupRole) {
        String defaultLanguage = survey.getDefaultLanguage();
        final CollectAnnotations annotations = survey.getAnnotations();
        final UIConfiguration uiConfiguration = survey.getUIConfiguration();
        final UIOptions uiOptions = survey.getUIOptions();
        final SurveyView surveyView = new SurveyView(survey, new ViewContext(this.languageCode));
        if (userGroup != null) {
            surveyView.setUserGroupQualifierName(userGroup.getQualifierName());
            surveyView.setUserGroupQualifierValue(userGroup.getQualifierValue());
            surveyView.setUserInGroupRole(userInSurveyGroupRole);
        }
        for (CodeList codeList : survey.getCodeLists()) {
            CodeListView codeListView = new CodeListView();
            codeListView.setId(codeList.getId());
            codeListView.setName(codeList.getName());
            codeListView.setLabel(codeList.getLabel(CodeListLabel.Type.ITEM, this.languageCode));
            if (this.includeCodeListValues && !codeList.isExternal()) {
                CodeListService service = survey.getContext().getCodeListService();
                List items = service.loadRootItems(codeList);
                for (CodeListItem item : items) {
                    codeListView.addItem(this.createCodeListItemView(item));
                }
            }
            surveyView.addCodeList(codeListView);
        }
        for (ModelVersion version : survey.getVersions()) {
            ModelVersionView versionView = new ModelVersionView();
            versionView.setId(version.getId());
            versionView.setName(version.getName());
            versionView.setLabel(version.getLabel(this.languageCode));
            versionView.setDate(version.getDate());
            surveyView.addModelVersion(versionView);
        }
        for (Unit unit : survey.getUnits()) {
            UnitView unitView = new UnitView();
            unitView.setId(unit.getId());
            unitView.setConversionFactor(unit.getConversionFactor());
            unitView.setAbbreviation(unit.getAbbreviation(this.languageCode, defaultLanguage));
            unitView.setLabel(unit.getLabel(this.languageCode, defaultLanguage));
            surveyView.addUnit(unitView);
        }
        for (SpatialReferenceSystem srs : survey.getSpatialReferenceSystems()) {
            SpatialReferenceSystemView srsView = new SpatialReferenceSystemView();
            srsView.setId(srs.getId());
            srsView.setLabel(srs.getLabel(this.languageCode, defaultLanguage));
            srsView.setDescription(srs.getDescription(this.languageCode, defaultLanguage));
            surveyView.addSpatialReferenceSystem(srsView);
        }
        final HashMap viewById = new HashMap();
        survey.getSchema().traverse(new NodeDefinitionVisitor(){

            public void visit(NodeDefinition def) {
                NodeDefView view;
                int id = def.getId();
                String name = def.getName();
                String label = SurveyViewGenerator.this.getLabel(def);
                boolean multiple = def.isMultiple();
                if (def instanceof EntityDefinition) {
                    EntityDefinition entityDefinition = (EntityDefinition)def;
                    EntityDefView entityDefView = new EntityDefView(entityDefinition.isRoot(), id, name, label, multiple);
                    entityDefView.setEnumerate(annotations.isEnumerate(entityDefinition));
                    view = entityDefView;
                } else {
                    AttributeDefinition attrDef = (AttributeDefinition)def;
                    boolean qualifier = annotations.isQualifier(attrDef);
                    boolean showInSummary = annotations.isShowInSummary(attrDef);
                    AttributeType attributeType = AttributeType.valueOf(attrDef);
                    List fieldNames = attrDef.getFieldNames();
                    boolean key = attrDef.isKey();
                    if (def instanceof CodeAttributeDefinition) {
                        CodeAttributeDefinition codeAttrDef = (CodeAttributeDefinition)def;
                        int codeListId = codeAttrDef.getList() == null ? -1 : codeAttrDef.getList().getId();
                        CodeAttributeDefView attrDefView = new CodeAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                        attrDefView.setCodeListId(codeListId);
                        attrDefView.setEnumerator(codeAttrDef.isEnumerator());
                        Integer codeParentDefId = codeAttrDef.getParentCodeAttributeDefinition() == null ? null : Integer.valueOf(codeAttrDef.getParentCodeAttributeDefinition().getId());
                        attrDefView.setParentCodeAttributeDefinitionId(codeParentDefId);
                        attrDefView.setShowCode(uiOptions.getShowCode(codeAttrDef));
                        attrDefView.setLayout(uiOptions.getLayoutType(codeAttrDef));
                        attrDefView.setItemsOrientation(uiOptions.getLayoutDirection(codeAttrDef));
                        view = attrDefView;
                    } else if (def instanceof CoordinateAttributeDefinition) {
                        CoordinateAttributeDefinition coordDef = (CoordinateAttributeDefinition)def;
                        CoordinateAttributeDefView attrDefView = new CoordinateAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                        attrDefView.setFieldsOrder(uiOptions.getFieldsOrder(coordDef));
                        attrDefView.setShowSrsField(annotations.isShowSrsField(coordDef));
                        attrDefView.setIncludeAccuracyField(annotations.isIncludeCoordinateAccuracy(coordDef));
                        attrDefView.setIncludeAltitudeField(annotations.isIncludeCoordinateAltitude(coordDef));
                        view = attrDefView;
                    } else if (def instanceof FileAttributeDefinition) {
                        FileAttributeDefinition fileDef = (FileAttributeDefinition)def;
                        FileAttributeDefView attrDefView = new FileAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                        attrDefView.setFileType(annotations.getFileType(fileDef));
                        attrDefView.setMaxSize(fileDef.getMaxSize());
                        attrDefView.setExtensions(fileDef.getExtensions());
                        view = attrDefView;
                    } else if (def instanceof NumberAttributeDefinition) {
                        NumberAttributeDefinition numberDef = (NumberAttributeDefinition)def;
                        List precisions = numberDef.getPrecisionDefinitions();
                        List<PrecisionView> precisionViews = Views.fromObjects(precisions, PrecisionView.class);
                        NumberAttributeDefView attrDefView = new NumberAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                        attrDefView.setNumericType(numberDef.getType());
                        attrDefView.setPrecisions(precisionViews);
                        view = attrDefView;
                    } else if (def instanceof TaxonAttributeDefinition) {
                        TaxonAttributeDefinition taxonDef = (TaxonAttributeDefinition)def;
                        TaxonAttributeDefView attrDefView = new TaxonAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                        attrDefView.setTaxonomyName(taxonDef.getTaxonomy());
                        attrDefView.setHighestRank(taxonDef.getHighestTaxonRank());
                        attrDefView.setShowFamily(annotations.isShowFamily(taxonDef));
                        attrDefView.setIncludeUniqueVernacularName(annotations.isIncludeUniqueVernacularName(taxonDef));
                        attrDefView.setAllowUnlisted(annotations.isAllowUnlisted(taxonDef));
                        view = attrDefView;
                    } else if (def instanceof TextAttributeDefinition) {
                        TextAttributeDefinition textDef = (TextAttributeDefinition)def;
                        TextAttributeDefView attrDefView = new TextAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                        attrDefView.setTextType(textDef.getType());
                        view = attrDefView;
                    } else {
                        view = new AttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
                    }
                    AttributeDefView attrDefView = (AttributeDefView)view;
                    attrDefView.setShowInRecordSummaryList(showInSummary);
                    attrDefView.setQualifier(qualifier);
                    List fieldLabels = attrDef.getFieldLabels();
                    HashMap<String, Boolean> visibilityByField = new HashMap<String, Boolean>();
                    ArrayList<String> fieldLabelsView = new ArrayList<String>(fieldLabels.size());
                    for (String fieldName : attrDef.getFieldNames()) {
                        fieldLabelsView.add(attrDef.getFieldLabel(fieldName, SurveyViewGenerator.this.languageCode));
                        visibilityByField.put(fieldName, uiOptions.isVisibleField(attrDef, fieldName));
                    }
                    attrDefView.setFieldLabels(fieldLabelsView);
                    attrDefView.setVisibilityByField(visibilityByField);
                    attrDefView.setCalculated(attrDef.isCalculated());
                }
                UIModelObject uiModelObject = uiConfiguration.getModelObjectByNodeDefinitionId(def.getId());
                view.setHideWhenNotRelevant(uiModelObject != null && uiModelObject.isHideWhenNotRelevant());
                NodeDefinition parentDef = def.getParentDefinition();
                if (parentDef == null) {
                    surveyView.getSchema().addRootEntity((EntityDefView)view);
                } else {
                    EntityDefView parentView = (EntityDefView)viewById.get(parentDef.getId());
                    parentView.addChild(view);
                }
                viewById.put(id, view);
            }
        });
        return surveyView;
    }

    private CodeListItemView createCodeListItemView(CodeListItem item) {
        CodeListService service = item.getSurvey().getContext().getCodeListService();
        CodeListItemView itemView = new CodeListItemView();
        itemView.id = item.getId();
        itemView.code = item.getCode();
        itemView.label = item.getLabel(this.languageCode);
        itemView.description = item.getDescription(this.languageCode);
        itemView.color = item.getColor();
        ArrayList<CodeListItemView> childItemsView = new ArrayList<CodeListItemView>();
        List childItems = service.loadChildItems(item);
        for (CodeListItem childItem : childItems) {
            childItemsView.add(this.createCodeListItemView(childItem));
        }
        itemView.items.addAll(childItemsView);
        return itemView;
    }

    private String getLabel(NodeDefinition def) {
        String label = def.getLabel(NodeLabel.Type.INSTANCE, this.languageCode);
        if (label == null && !def.getSurvey().isDefaultLanguage(this.languageCode)) {
            label = def.getLabel(NodeLabel.Type.INSTANCE);
        }
        return label;
    }

    public void setIncludeCodeListValues(boolean includeCodeListValues) {
        this.includeCodeListValues = includeCodeListValues;
    }
}

