/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.AttributeDefinitionFormValidator;
import org.openforis.collect.designer.viewmodel.CodeAttributeVM;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class CodeAttributeDefinitionFormValidator
extends AttributeDefinitionFormValidator {
    private static final String PARENT_CODE_ATTRIBUTE_DEFINITION_PATH_FIELD = "parentCodeAttributeDefinitionPath";
    protected static final String LIST_FIELD = "list";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        super.internalValidate(ctx);
        this.validateRequired(ctx, LIST_FIELD);
        this.validateParentAttributeDefinition(ctx);
    }

    private void validateParentAttributeDefinition(ValidationContext ctx) {
        CodeAttributeVM vm;
        CollectSurvey survey;
        CodeAttributeDefinition parentDef;
        String parentCodeAttributeDefPath = (String)this.getValue(ctx, PARENT_CODE_ATTRIBUTE_DEFINITION_PATH_FIELD);
        if (parentCodeAttributeDefPath != null && (parentDef = (CodeAttributeDefinition)(survey = (vm = (CodeAttributeVM)this.getVM(ctx)).getSurvey()).getSchema().getDefinitionByPath(parentCodeAttributeDefPath)) != null) {
            CodeList list = (CodeList)this.getValue(ctx, LIST_FIELD);
            if (list.isHierarchical()) {
                try {
                    Integer parentHierarchicalLevelIdx = parentDef.getListLevelIndex();
                    if (parentHierarchicalLevelIdx + 1 >= list.getHierarchy().size()) {
                        this.addInvalidMessage(ctx, PARENT_CODE_ATTRIBUTE_DEFINITION_PATH_FIELD, Labels.getLabel((String)"survey.validation.attribute.code.invalid_parent_attribute_relation"));
                    }
                }
                catch (Exception e) {
                    this.addInvalidMessage(ctx, PARENT_CODE_ATTRIBUTE_DEFINITION_PATH_FIELD, Labels.getLabel((String)"survey.validation.attribute.code.invalid_parent_attribute_relation_in_referenced_parent_attribute"));
                }
            } else {
                this.addInvalidMessage(ctx, PARENT_CODE_ATTRIBUTE_DEFINITION_PATH_FIELD, Labels.getLabel((String)"survey.validation.attribute.code.parent_attribute_specified_for_a_flat_list"));
            }
        }
    }
}

