/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.io.File;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.io.data.CSVDataImportJob;
import org.openforis.collect.io.data.TransactionalCSVDataImportJob;
import org.openforis.collect.io.data.csv.CSVDataImportSettings;
import org.openforis.collect.io.data.proxy.DataImportStatusProxy;
import org.openforis.collect.io.exception.DataImportExeption;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.web.session.SessionState;
import org.openforis.concurrency.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;

public class CSVDataImportService {
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private CollectJobManager jobManager;
    private CSVDataImportJob importJob;

    protected void init() {
    }

    @Secured(value={"ROLE_ADMIN"})
    public DataImportStatusProxy start(String tempFileName, int parentEntityId, CollectRecord.Step step, boolean transactional, boolean validateRecords, boolean insertNewRecords, String newRecordVersionName, boolean deleteExistingEntities) throws DataImportExeption {
        if (this.importJob == null || !this.importJob.isRunning()) {
            CollectRecord.Step[] stepArray;
            File importFile = new File(tempFileName);
            SessionState sessionState = this.sessionManager.getSessionState();
            CollectSurvey survey = sessionState.getActiveSurvey();
            this.importJob = transactional ? (CSVDataImportJob)this.jobManager.createJob(TransactionalCSVDataImportJob.class) : (CSVDataImportJob)this.jobManager.createJob("csvDataImportJob", CSVDataImportJob.class);
            CSVDataImportSettings settings = new CSVDataImportSettings();
            settings.setRecordValidationEnabled(validateRecords);
            settings.setInsertNewRecords(insertNewRecords);
            settings.setNewRecordVersionName(newRecordVersionName);
            settings.setDeleteExistingEntities(deleteExistingEntities);
            if (step == null) {
                stepArray = CollectRecord.Step.values();
            } else {
                CollectRecord.Step[] stepArray2 = new CollectRecord.Step[1];
                stepArray = stepArray2;
                stepArray2[0] = step;
            }
            CollectRecord.Step[] steps = stepArray;
            CSVDataImportJob.CSVDataImportInput input = new CSVDataImportJob.CSVDataImportInput(importFile, survey, steps, Integer.valueOf(parentEntityId), settings);
            this.importJob.setInput(input);
            this.jobManager.start((Job)this.importJob);
        }
        return this.getStatus();
    }

    @Secured(value={"ROLE_ADMIN"})
    public DataImportStatusProxy getStatus() {
        return this.importJob == null ? null : new DataImportStatusProxy(this.importJob);
    }

    @Secured(value={"ROLE_ADMIN"})
    public void cancel() {
        if (this.importJob != null) {
            this.importJob.abort();
        }
    }
}

