/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.openforis.collect.io.AbstractSurveyRestoreJob;
import org.openforis.collect.io.CESurveyRestoreJob;
import org.openforis.collect.io.SurveyBackupInfo;
import org.openforis.collect.io.SurveyBackupInfoExtractorJob;
import org.openforis.collect.io.SurveyBackupJob;
import org.openforis.collect.io.SurveyRestoreJob;
import org.openforis.collect.io.XMLSurveyRestoreJob;
import org.openforis.collect.io.ZipFileExtractor;
import org.openforis.collect.manager.CollectEarthSurveyExportJob;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.manager.validation.CollectEarthSurveyValidator;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.metamodel.SimpleSurveyCreationParameters;
import org.openforis.collect.metamodel.SurveyTarget;
import org.openforis.collect.metamodel.view.SurveyView;
import org.openforis.collect.metamodel.view.SurveyViewGenerator;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.persistence.SurveyImportException;
import org.openforis.collect.persistence.SurveyStoreException;
import org.openforis.collect.relational.print.RDBPrintJob;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Dates;
import org.openforis.collect.utils.Files;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.collect.web.controller.CollectJobController;
import org.openforis.collect.web.service.SurveyService;
import org.openforis.collect.web.validator.SimpleSurveyCreationParametersValidator;
import org.openforis.collect.web.validator.SurveyCloneParametersValidator;
import org.openforis.collect.web.validator.SurveyCreationParametersValidator;
import org.openforis.collect.web.validator.SurveyImportParametersValidator;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.commons.web.Response;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.concurrency.WorkerStatusChangeEvent;
import org.openforis.concurrency.WorkerStatusChangeListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/survey"})
@Scope(value="session")
@Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
public class SurveyController
extends BasicController {
    private static final String COLLECT_EARTH_PROJECT_FILE_EXTENSION = "cep";
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private UserGroupManager userGroupManager;
    @Autowired
    private JobManager jobManager;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SurveyService surveyService;
    @Autowired
    private AppWS appWS;
    @Autowired
    private SurveyCreationParametersValidator surveyCreationParametersValidator;
    @Autowired
    private SimpleSurveyCreationParametersValidator simpleSurveyCreationParametersValidator;
    @Autowired
    private SurveyImportParametersValidator surveyImportParametersValidator;
    @Autowired
    private SurveyCloneParametersValidator surveyCloneParametersValidator;
    @Autowired
    private SurveyValidator surveyValidator;
    @Autowired
    private CollectEarthSurveyValidator collectEarthSurveyValidator;
    private SurveyBackupInfoExtractorJob surveyBackupInfoExtractorJob;
    private File uploadedSurveyFile;
    private SurveyBackupInfo uploadedSurveyInfo;
    private AbstractSurveyRestoreJob surveyImportJob;
    private Job surveyBackupJob;
    private SurveyCloneJob surveyCloneJob;

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        Object target = binder.getTarget();
        if (target != null) {
            if (target instanceof SurveyCreationParameters) {
                binder.setValidator((Validator)this.surveyCreationParametersValidator);
            } else if (target instanceof SimpleSurveyCreationParameters) {
                binder.setValidator((Validator)this.simpleSurveyCreationParametersValidator);
            } else if (target instanceof SurveyImportParameters) {
                binder.setValidator((Validator)this.surveyImportParametersValidator);
            } else if (target instanceof SurveyCloneParameters) {
                binder.setValidator((Validator)this.surveyCloneParametersValidator);
            }
        }
    }

    @RequestMapping(method={RequestMethod.GET})
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    @ResponseBody
    public List<?> loadSurveys(@RequestParam(value="userId", required=false) Integer userId, @RequestParam(value="groupId", required=false) Integer groupId, @RequestParam(value="full", required=false) boolean fullSurveys, @RequestParam(value="includeCodeListValues", required=false) boolean includeCodeListValues, @RequestParam(value="includeTemporary", required=false) boolean includeTemporary) throws Exception {
        String languageCode = Locale.ENGLISH.getLanguage();
        if (userId == null) {
            userId = this.sessionManager.getLoggedUser().getId();
        }
        Set<Integer> groupIds = this.getAvailableUserGroupIds(userId, groupId);
        ArrayList publishedSummaries = new ArrayList(this.surveyManager.getSurveySummaries(languageCode, userId.intValue(), groupIds));
        ArrayList allSummaries = new ArrayList(publishedSummaries);
        if (includeTemporary) {
            List tempSummaries = this.surveyManager.loadTemporarySummaries(languageCode, true, userId.intValue(), groupIds);
            allSummaries.addAll(tempSummaries);
        }
        ArrayList<SurveyView> views = new ArrayList<SurveyView>(allSummaries.size());
        if (fullSurveys) {
            for (SurveySummary surveySummary : allSummaries) {
                CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveySummary.getId().intValue());
                views.add(this.generateView(survey, includeCodeListValues));
            }
        } else {
            views.addAll(allSummaries);
        }
        views.sort(Collections.reverseOrder(new BeanComparator("modifiedDate")));
        return views;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public SurveyView loadSurvey(@PathVariable int id, @RequestParam(value="includeCodeListValues", required=false, defaultValue="true") boolean includeCodeListValues) throws Exception {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(id);
        return this.generateView(survey, includeCodeListValues);
    }

    @RequestMapping(method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public Response createSurvey(@Valid SurveyCreationParameters params, BindingResult bindingResult) throws Exception {
        if (bindingResult.hasErrors()) {
            Response res = new Response();
            res.setErrorStatus();
            res.addObject("errors", (Object)bindingResult.getFieldErrors());
            return res;
        }
        CollectSurvey survey = this.surveyService.createNewSurvey(params);
        SurveySummary surveySummary = SurveySummary.createFromSurvey((CollectSurvey)survey);
        this.sendSurveysUpdatedMessage();
        Response res = new Response();
        res.setObject((Object)surveySummary);
        return res;
    }

    @RequestMapping(value={"cloneintotemporary/{surveyId}"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public Response cloneIntoTemporarySurvey(@PathVariable int surveyId) throws Exception {
        Response response = new Response();
        User loggedUser = this.sessionManager.getLoggedUser();
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        if (survey.isPublished()) {
            String surveyUri = survey.getUri();
            CollectSurvey temporarySurvey = this.surveyManager.createTemporarySurveyFromPublished(surveyUri, loggedUser);
            this.sendSurveysUpdatedMessage();
            response.setObject((Object)temporarySurvey.getId());
        } else {
            response.setErrorStatus();
            response.setErrorMessage(String.format("Survey with id %d is not published as expected", surveyId));
        }
        return response;
    }

    @RequestMapping(value={"validatecreation"}, method={RequestMethod.POST})
    @ResponseBody
    public Response validateSurveyCreationParameters(@Valid SurveyCreationParameters params, BindingResult result) {
        return this.generateFormValidationResponse(result);
    }

    @RequestMapping(value={"publish/{id}"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public SurveyPublishResult publishSurvey(@PathVariable int id, @RequestParam boolean ignoreWarnings) throws SurveyImportException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(id);
        CollectSurvey publishedSurvey = survey.isPublished() ? this.surveyManager.getByUri(survey.getUri()) : null;
        SurveyValidator validator = this.getSurveyValidator(survey);
        SurveyValidator.ValidationParameters validationParameters = new SurveyValidator.ValidationParameters();
        validationParameters.setWarningsIgnored(ignoreWarnings);
        SurveyValidator.SurveyValidationResults results = validator.validateCompatibilityForPublishing(publishedSurvey, survey, validationParameters);
        if (results.hasErrors() || results.hasWarnings()) {
            return new SurveyPublishResult(results);
        }
        User activeUser = this.sessionManager.getLoggedUser();
        this.surveyManager.publish(survey, activeUser);
        this.sendSurveysUpdatedMessage();
        return new SurveyPublishResult(this.generateView(survey, false));
    }

    @RequestMapping(value={"unpublish/{id}"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public SurveyView unpublishSurvey(@PathVariable int id) throws SurveyStoreException {
        User activeUser = this.sessionManager.getLoggedUser();
        CollectSurvey survey = this.surveyManager.unpublish(id, activeUser);
        this.sendSurveysUpdatedMessage();
        return this.generateView(survey, false);
    }

    @RequestMapping(value={"close/{id}"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public SurveyView closeSurvey(@PathVariable int id) throws SurveyImportException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(id);
        this.surveyManager.close(survey);
        this.sendSurveysUpdatedMessage();
        return this.generateView(survey, false);
    }

    @RequestMapping(value={"archive/{id}"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public SurveyView archiveSurvey(@PathVariable int id) throws SurveyImportException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(id);
        this.surveyManager.archive(survey);
        this.sendSurveysUpdatedMessage();
        return this.generateView(survey, false);
    }

    @RequestMapping(value={"delete/{id}"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public Response deleteSurvey(@PathVariable int id) throws SurveyImportException {
        this.surveyManager.deleteSurvey(id);
        this.sendSurveysUpdatedMessage();
        return new Response();
    }

    @RequestMapping(value={"clone"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public CollectJobController.JobView cloneSurvey(@Valid SurveyCloneParameters params) {
        this.surveyCloneJob = new SurveyCloneJob(this.surveyManager);
        this.surveyCloneJob.setOriginalSurveyName(params.originalSurveyName);
        this.surveyCloneJob.setNewName(params.newSurveyName);
        this.surveyCloneJob.setOriginalSurveyType(params.originalSurveyType);
        this.surveyCloneJob.setActiveUser(this.sessionManager.getLoggedUser());
        this.surveyCloneJob.addStatusChangeListener(new WorkerStatusChangeListener(){

            public void statusChanged(WorkerStatusChangeEvent event) {
                if (event.getTo() == Worker.Status.COMPLETED) {
                    SurveyController.this.sendSurveysUpdatedMessage();
                }
            }
        });
        this.jobManager.start((Job)this.surveyCloneJob);
        return new CollectJobController.JobView(this.surveyCloneJob);
    }

    @RequestMapping(value={"cloned/id"}, method={RequestMethod.GET})
    @ResponseBody
    public Response getClonedSurveyId() {
        Response response = new Response();
        if (this.surveyCloneJob == null || !this.surveyCloneJob.isCompleted()) {
            response.setErrorStatus();
            response.setErrorMessage("Survey clone job not found");
        } else {
            response.setObject((Object)this.surveyCloneJob.getOutputSurvey().getId());
        }
        return response;
    }

    @RequestMapping(value={"validate/clone"}, method={RequestMethod.POST})
    @ResponseBody
    public Response validateSurveyCloneParameters(@Valid SurveyCloneParameters params, BindingResult result) {
        return this.generateFormValidationResponse(result);
    }

    @RequestMapping(value={"prepareimport"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public Response prepareSurveyImport(@RequestParam(value="file") MultipartFile multipartFile) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        File tempFile = Files.writeToTempFile((InputStream)multipartFile.getInputStream(), (String)multipartFile.getOriginalFilename(), (String)"ofc_csv_data_import");
        String extension = FilenameUtils.getExtension((String)fileName);
        this.uploadedSurveyFile = tempFile;
        if (this.surveyBackupInfoExtractorJob != null && this.surveyBackupInfoExtractorJob.isRunning()) {
            this.surveyBackupInfoExtractorJob.abort();
        }
        this.surveyBackupInfoExtractorJob = (SurveyBackupInfoExtractorJob)this.jobManager.createJob(SurveyBackupInfoExtractorJob.class);
        if (COLLECT_EARTH_PROJECT_FILE_EXTENSION.equalsIgnoreCase(extension)) {
            File idmFile = this.extractIdmFromCEPFile(tempFile);
            this.surveyBackupInfoExtractorJob.setFile(idmFile);
        } else {
            this.surveyBackupInfoExtractorJob.setFile(tempFile);
        }
        this.surveyBackupInfoExtractorJob.setValidate(false);
        this.jobManager.start((Job)this.surveyBackupInfoExtractorJob, false);
        Response response = new Response();
        if (this.surveyBackupInfoExtractorJob.isCompleted()) {
            this.uploadedSurveyInfo = this.surveyBackupInfoExtractorJob.getInfo();
            response.addObject("surveyBackupInfo", (Object)this.uploadedSurveyInfo);
            SurveySummary existingSummary = this.surveyManager.loadSummaryByUri(this.uploadedSurveyInfo.getSurveyUri());
            response.addObject("importingIntoExistingSurvey", (Object)(existingSummary != null ? 1 : 0));
            response.addObject("existingSurveyUserGroupId", (Object)(existingSummary == null ? null : existingSummary.getUserGroupId()));
            return response;
        }
        response.setErrorStatus();
        response.setErrorMessage(this.surveyBackupInfoExtractorJob.getErrorMessage());
        return response;
    }

    @RequestMapping(value={"validateimport"}, method={RequestMethod.POST})
    @ResponseBody
    public Response validateSurveyImportParameters(@Valid SurveyImportParameters params, BindingResult result) {
        return this.generateFormValidationResponse(result);
    }

    @RequestMapping(value={"startimport"}, method={RequestMethod.POST})
    @ResponseBody
    public Response startSurveyFileImport(@Valid SurveyImportParameters params, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            Response res = new Response();
            res.setErrorStatus();
            res.addObject("errors", (Object)bindingResult.getFieldErrors());
            return res;
        }
        String surveyName = params.getName();
        UserGroup userGroup = (UserGroup)this.userGroupManager.loadById((Object)params.getUserGroupId());
        String uploadedFileNameExtension = FilenameUtils.getExtension((String)this.uploadedSurveyFile.getName());
        AbstractSurveyRestoreJob job = "xml".equalsIgnoreCase(uploadedFileNameExtension) ? (AbstractSurveyRestoreJob)this.jobManager.createJob(XMLSurveyRestoreJob.class) : (COLLECT_EARTH_PROJECT_FILE_EXTENSION.equalsIgnoreCase(uploadedFileNameExtension) ? (AbstractSurveyRestoreJob)this.jobManager.createJob(CESurveyRestoreJob.class) : (AbstractSurveyRestoreJob)this.jobManager.createJob(SurveyRestoreJob.class));
        job.setFile(this.uploadedSurveyFile);
        job.setSurveyName(surveyName);
        job.setSurveyUri(this.uploadedSurveyInfo == null ? null : this.uploadedSurveyInfo.getSurveyUri());
        job.setUserGroup(userGroup);
        job.setRestoreIntoPublishedSurvey(false);
        job.setValidateSurvey(false);
        job.setActiveUser(this.sessionManager.getLoggedUser());
        job.addStatusChangeListener(new WorkerStatusChangeListener(){

            public void statusChanged(WorkerStatusChangeEvent event) {
                if (event.getTo() == Worker.Status.COMPLETED) {
                    SurveyController.this.sendSurveysUpdatedMessage();
                }
            }
        });
        this.jobManager.start((Job)job);
        this.surveyImportJob = job;
        Response res = new Response();
        res.setObject((Object)new SurveyImportJobView(job));
        return res;
    }

    @RequestMapping(value={"importstatus"}, method={RequestMethod.GET})
    @ResponseBody
    public SurveyImportJobView getSurveyImportStatus() {
        if (this.surveyImportJob == null) {
            return null;
        }
        return new SurveyImportJobView(this.surveyImportJob);
    }

    @RequestMapping(value={"{surveyName}/changeusergroup"}, method={RequestMethod.POST})
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @ResponseBody
    public SurveySummary changeSurveyUserGroup(@PathVariable String surveyName, @RequestParam int userGroupId) throws SurveyStoreException {
        SurveySummary surveySummary = this.surveyManager.updateUserGroup(surveyName, userGroupId);
        this.sendSurveysUpdatedMessage();
        return surveySummary;
    }

    @RequestMapping(value={"export/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public CollectJobController.JobView startExport(@Valid SurveyExportParameters params, BindingResult result) {
        this.surveyBackupJob = null;
        String uri = params.getSurveyUri();
        SurveySummary surveySummary = this.surveyManager.loadSummaryByUri(uri);
        CollectSurvey loadedSurvey = surveySummary.isTemporary() && params.getSurveyType() == SurveyCloneParameters.SurveyType.TEMPORARY ? this.surveyManager.loadSurvey(surveySummary.getId().intValue()) : this.surveyManager.getByUri(uri);
        switch (params.getOutputFormat()) {
            case EARTH: {
                CollectEarthSurveyExportJob job = (CollectEarthSurveyExportJob)this.jobManager.createJob(CollectEarthSurveyExportJob.class);
                job.setSurvey(loadedSurvey);
                job.setLanguageCode(params.getLanguageCode());
                this.jobManager.start((Job)job, String.valueOf(loadedSurvey.getId()));
                this.surveyBackupJob = job;
                return new CollectJobController.JobView(job);
            }
            case RDB: {
                RDBPrintJob job = (RDBPrintJob)this.jobManager.createJob(RDBPrintJob.class);
                job.setSurvey(loadedSurvey);
                job.setRecordFilter(new RecordFilter(loadedSurvey));
                job.setIncludeData(params.isIncludeData());
                job.setDialect(params.getRdbDialectEnum());
                job.setDateTimeFormat(params.getRdbDateTimeFormat());
                job.setTargetSchemaName(params.getRdbTargetSchemaName());
                this.jobManager.start((Job)job, String.valueOf(loadedSurvey.getId()));
                this.surveyBackupJob = job;
                return new CollectJobController.JobView((Job)job);
            }
        }
        SurveyBackupJob job = (SurveyBackupJob)this.jobManager.createJob(SurveyBackupJob.class);
        job.setSurvey(loadedSurvey);
        job.setOutputFormat(SurveyBackupJob.OutputFormat.valueOf((String)params.getOutputFormat().name()));
        job.setOutputSurveyDefaultLanguage(StringUtils.defaultIfEmpty((String)params.getLanguageCode(), (String)loadedSurvey.getDefaultLanguage()));
        this.jobManager.start((Job)job, String.valueOf(loadedSurvey.getId()));
        this.surveyBackupJob = job;
        return new CollectJobController.JobView((Job)job);
    }

    @RequestMapping(value={"export/{surveyId}/result"}, method={RequestMethod.GET})
    public void downloadExportResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        if (this.surveyBackupJob != null) {
            String projectName;
            CollectSurvey survey;
            String outputFileExtension;
            File outputFile;
            CollectEarthSurveyExportJob backupJob;
            if (this.surveyBackupJob instanceof CollectEarthSurveyExportJob) {
                backupJob = (CollectEarthSurveyExportJob)this.surveyBackupJob;
                outputFile = backupJob.getOutputFile();
                outputFileExtension = COLLECT_EARTH_PROJECT_FILE_EXTENSION;
                survey = backupJob.getSurvey();
                projectName = survey.getName();
            } else if (this.surveyBackupJob instanceof RDBPrintJob) {
                RDBPrintJob rdbPrintJob = (RDBPrintJob)this.surveyBackupJob;
                outputFile = rdbPrintJob.getOutputFile();
                outputFileExtension = FilenameUtils.getExtension((String)outputFile.getName());
                survey = rdbPrintJob.getSurvey();
                projectName = survey.getName();
            } else {
                backupJob = (SurveyBackupJob)this.surveyBackupJob;
                outputFile = backupJob.getOutputFile();
                outputFileExtension = backupJob.getOutputFormat().getOutputFileExtension();
                survey = backupJob.getSurvey();
                projectName = survey.getName();
                if (backupJob.getOutputFormat() == SurveyBackupJob.OutputFormat.MOBILE) {
                    projectName = projectName + "_" + backupJob.getOutputSurveyDefaultLanguage();
                }
            }
            String fileName = String.format("%s_%s.%s", projectName, Dates.formatCompactDateTime((Date)survey.getModifiedDate()), outputFileExtension);
            Controllers.writeFileToResponse(response, outputFile, fileName, "application/zip");
        }
    }

    private SurveyView generateView(CollectSurvey survey, boolean includeCodeListValues) {
        if (survey == null) {
            return null;
        }
        SurveyViewGenerator viewGenerator = new SurveyViewGenerator(Locale.ENGLISH.getLanguage());
        viewGenerator.setIncludeCodeListValues(includeCodeListValues);
        UserInGroup userInSurveyGroup = this.userGroupManager.findUserInGroupOrDescendants(survey.getUserGroupId().intValue(), this.sessionManager.getLoggedUser().getId().intValue());
        UserGroup userGroup = userInSurveyGroup == null ? null : (UserGroup)this.userGroupManager.loadById((Object)userInSurveyGroup.getGroupId());
        SurveyView view = viewGenerator.generateView(survey, userGroup, userInSurveyGroup == null ? null : userInSurveyGroup.getRole());
        return view;
    }

    private Set<Integer> getAvailableUserGroupIds(Integer userId, Integer groupId) {
        if (groupId != null) {
            return Collections.singleton(groupId);
        }
        if (userId != null) {
            User availableToUser = userId == null ? null : (User)this.userManager.loadById((Object)userId);
            List groups = this.userGroupManager.findAllRelatedUserGroups(availableToUser);
            List groupIds = CollectionUtils.project((Collection)groups, (String)"id");
            return new HashSet<Integer>(groupIds);
        }
        return null;
    }

    private File extractIdmFromCEPFile(File surveyFile) {
        try {
            ZipFileExtractor zipFileExtractor = new ZipFileExtractor(surveyFile);
            File idmFile = zipFileExtractor.extract("placemark.idm.xml");
            return idmFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting placemark.idm.xml from cep file", e);
        }
    }

    private void sendSurveysUpdatedMessage() {
        this.appWS.sendMessage(AppWS.MessageType.SURVEYS_UPDATED, 500);
    }

    private SurveyValidator getSurveyValidator(CollectSurvey survey) {
        return survey.getTarget() == SurveyTarget.COLLECT_EARTH ? this.collectEarthSurveyValidator : this.surveyValidator;
    }

    public class SurveyPublishResult {
        private SurveyView survey;
        private SurveyValidator.SurveyValidationResults validationResult;

        public SurveyPublishResult(SurveyView survey) {
            this.survey = survey;
        }

        public SurveyPublishResult(SurveyValidator.SurveyValidationResults validationResult) {
            this.validationResult = validationResult;
        }

        public SurveyView getSurvey() {
            return this.survey;
        }

        public SurveyValidator.SurveyValidationResults getValidationResult() {
            return this.validationResult;
        }
    }

    public static class SurveyCloneJob
    extends Job {
        private SurveyManager surveyManager;
        private String originalSurveyName;
        private SurveyCloneParameters.SurveyType originalSurveyType;
        private String newName;
        private User activeUser;
        private CollectSurvey outputSurvey;

        public SurveyCloneJob(SurveyManager surveyManager) {
            this.surveyManager = surveyManager;
        }

        protected void buildTasks() throws Throwable {
            this.addTask((Worker)new Task(){

                protected void execute() throws Throwable {
                    outputSurvey = surveyManager.duplicateSurveyIntoTemporary(originalSurveyName, originalSurveyType == SurveyCloneParameters.SurveyType.TEMPORARY, newName, activeUser);
                }
            });
        }

        public void setOriginalSurveyName(String originalSurveyName) {
            this.originalSurveyName = originalSurveyName;
        }

        public void setOriginalSurveyType(SurveyCloneParameters.SurveyType originalSurveyType) {
            this.originalSurveyType = originalSurveyType;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public void setActiveUser(User activeUser) {
            this.activeUser = activeUser;
        }

        public CollectSurvey getOutputSurvey() {
            return this.outputSurvey;
        }
    }

    public static class SurveyImportJobView
    extends CollectJobController.JobView {
        private Integer surveyId;

        public SurveyImportJobView(AbstractSurveyRestoreJob job) {
            super((Job)job);
            this.surveyId = job == null || job.getSurvey() == null ? null : job.getSurvey().getId();
        }

        public Integer getSurveyId() {
            return this.surveyId;
        }
    }

    public static class SurveyCloneParameters {
        private String originalSurveyName;
        private SurveyType originalSurveyType;
        private String newSurveyName;

        public String getOriginalSurveyName() {
            return this.originalSurveyName;
        }

        public void setOriginalSurveyName(String originalSurveyName) {
            this.originalSurveyName = originalSurveyName;
        }

        public SurveyType getOriginalSurveyType() {
            return this.originalSurveyType;
        }

        public void setOriginalSurveyType(SurveyType originalSurveyType) {
            this.originalSurveyType = originalSurveyType;
        }

        public String getNewSurveyName() {
            return this.newSurveyName;
        }

        public void setNewSurveyName(String newSurveyName) {
            this.newSurveyName = newSurveyName;
        }

        public static enum SurveyType {
            TEMPORARY,
            PUBLISHED;

        }
    }

    public static class SurveyExportParameters {
        private String surveyUri;
        private Integer surveyId;
        private SurveyCloneParameters.SurveyType surveyType;
        private OutputFormat outputFormat;
        private String languageCode;
        private boolean skipValidation;
        private boolean includeData;
        private String rdbDialect;
        private String rdbDateTimeFormat;
        private String rdbTargetSchemaName;

        public String getSurveyUri() {
            return this.surveyUri;
        }

        public RDBPrintJob.RdbDialect getRdbDialectEnum() {
            return this.rdbDialect == null ? null : RDBPrintJob.RdbDialect.valueOf((String)this.rdbDialect);
        }

        public void setSurveyUri(String surveyUri) {
            this.surveyUri = surveyUri;
        }

        public Integer getSurveyId() {
            return this.surveyId;
        }

        public void setSurveyId(Integer surveyId) {
            this.surveyId = surveyId;
        }

        public SurveyCloneParameters.SurveyType getSurveyType() {
            return this.surveyType;
        }

        public void setSurveyType(SurveyCloneParameters.SurveyType surveyType) {
            this.surveyType = surveyType;
        }

        public OutputFormat getOutputFormat() {
            return this.outputFormat;
        }

        public void setOutputFormat(OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public boolean isSkipValidation() {
            return this.skipValidation;
        }

        public void setSkipValidation(boolean skipValidation) {
            this.skipValidation = skipValidation;
        }

        public boolean isIncludeData() {
            return this.includeData;
        }

        public void setIncludeData(boolean includeData) {
            this.includeData = includeData;
        }

        public String getRdbDateTimeFormat() {
            return this.rdbDateTimeFormat;
        }

        public void setRdbDateTimeFormat(String rdbDateTimeFormat) {
            this.rdbDateTimeFormat = rdbDateTimeFormat;
        }

        public String getRdbTargetSchemaName() {
            return this.rdbTargetSchemaName;
        }

        public void setRdbTargetSchemaName(String rdbTargetSchemaName) {
            this.rdbTargetSchemaName = rdbTargetSchemaName;
        }

        public static enum OutputFormat {
            MOBILE,
            DESKTOP,
            RDB,
            EARTH;

        }
    }

    public static class SurveyImportParameters {
        private String name;
        private Integer userGroupId;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getUserGroupId() {
            return this.userGroupId;
        }

        public void setUserGroupId(Integer userGroupId) {
            this.userGroupId = userGroupId;
        }
    }

    public static class SurveyCreationParameters {
        private String name;
        private TemplateType templateType;
        private String defaultLanguageCode;
        private Integer userGroupId;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TemplateType getTemplateType() {
            return this.templateType;
        }

        public void setTemplateType(TemplateType templateType) {
            this.templateType = templateType;
        }

        public String getDefaultLanguageCode() {
            return this.defaultLanguageCode;
        }

        public void setDefaultLanguageCode(String defaultLanguageCode) {
            this.defaultLanguageCode = defaultLanguageCode;
        }

        public Integer getUserGroupId() {
            return this.userGroupId;
        }

        public void setUserGroupId(Integer userGroupId) {
            this.userGroupId = userGroupId;
        }

        public static enum TemplateType {
            BLANK,
            BIOPHYSICAL,
            COLLECT_EARTH,
            COLLECT_EARTH_IPCC;

        }
    }
}

