/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.idm.model.TaxonOccurrence;
import org.openforis.idm.model.species.Taxon;

public class TaxonOccurrenceProxy
implements Proxy {
    private transient TaxonOccurrence occurrence;

    public TaxonOccurrenceProxy(TaxonOccurrence occurence) {
        this.occurrence = occurence;
    }

    @ExternalizedProperty
    public String getCode() {
        return this.occurrence.getCode();
    }

    @ExternalizedProperty
    public String getScientificName() {
        return this.occurrence.getScientificName();
    }

    @ExternalizedProperty
    public String getVernacularName() {
        return this.occurrence.getVernacularName();
    }

    @ExternalizedProperty
    public String getLanguageCode() {
        return this.occurrence.getLanguageCode();
    }

    @ExternalizedProperty
    public String getLanguageVariety() {
        return this.occurrence.getLanguageVariety();
    }

    @ExternalizedProperty
    public Taxon.TaxonRank getTaxonRank() {
        return this.occurrence.getTaxonRank();
    }

    @ExternalizedProperty
    public String getFamilyCode() {
        if (this.occurrence.getTaxonRank() == Taxon.TaxonRank.FAMILY) {
            return this.occurrence.getCode();
        }
        TaxonOccurrence familyTaxon = this.occurrence.getAncestorTaxon(Taxon.TaxonRank.FAMILY);
        return familyTaxon == null ? null : familyTaxon.getCode();
    }

    @ExternalizedProperty
    public String getFamilyScientificName() {
        if (this.occurrence.getTaxonRank() == Taxon.TaxonRank.FAMILY) {
            return this.occurrence.getScientificName();
        }
        TaxonOccurrence familyTaxon = this.occurrence.getAncestorTaxon(Taxon.TaxonRank.FAMILY);
        return familyTaxon == null ? null : familyTaxon.getScientificName();
    }
}

