/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingItem;
import org.openforis.collect.datacleansing.DataCleansingMetadata;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.datacleansing.form.DataCleansingChainForm;
import org.openforis.collect.datacleansing.form.DataCleansingItemForm;
import org.openforis.collect.datacleansing.form.DataCleansingStepForm;
import org.openforis.collect.datacleansing.form.DataQueryForm;
import org.openforis.collect.datacleansing.form.DataQueryGroupForm;
import org.openforis.collect.datacleansing.form.DataQueryTypeForm;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.collection.CollectionUtils;

public class DataCleansingMetadataView {
    private List<DataQueryTypeForm> dataQueryTypes;
    private List<DataQueryForm> dataQueries;
    private List<DataQueryGroupForm> dataQueryGroups;
    private List<DataCleansingStepForm> cleansingSteps;
    private List<DataCleansingChainForm> cleansingChains;

    public static DataCleansingMetadataView fromMetadata(DataCleansingMetadata metadata) {
        DataCleansingMetadataView view = new DataCleansingMetadataView();
        view.dataQueryTypes = PersistedSurveyObjects.convert(metadata.getDataQueryTypes(), DataQueryTypeForm.class);
        view.dataQueries = PersistedSurveyObjects.convert(metadata.getDataQueries(), DataQueryForm.class);
        view.dataQueryGroups = PersistedSurveyObjects.convert(metadata.getDataQueryGroups(), DataQueryGroupForm.class);
        view.cleansingSteps = PersistedSurveyObjects.convert(metadata.getCleansingSteps(), DataCleansingStepForm.class);
        view.cleansingChains = PersistedSurveyObjects.convert(metadata.getCleansingChains(), DataCleansingChainForm.class);
        return view;
    }

    public DataCleansingMetadata toMetadata(CollectSurvey survey) {
        List queryTypes = PersistedSurveyObjects.toItems(survey, this.dataQueryTypes, DataQueryType.class);
        List queries = PersistedSurveyObjects.toItems(survey, this.dataQueries, DataQuery.class);
        List errorQueryGroups = PersistedSurveyObjects.toItems(survey, this.dataQueryGroups, DataQueryGroup.class);
        List cleansingSteps = PersistedSurveyObjects.toItems(survey, this.cleansingSteps, DataCleansingStep.class);
        List cleansingChains = PersistedSurveyObjects.toItems(survey, this.cleansingChains, DataCleansingChain.class);
        Map queryTypeByOriginalId = PersistedSurveyObjects.createObjectFromIdMap(queryTypes);
        Map queryByOriginalId = PersistedSurveyObjects.createObjectFromIdMap(queries);
        Map cleansingStepByOriginalId = PersistedSurveyObjects.createObjectFromIdMap(cleansingSteps);
        for (DataQuery query : queries) {
            query.setType((DataQueryType)((Object)queryTypeByOriginalId.get(query.getTypeId())));
        }
        for (DataQueryGroup queryGroup : errorQueryGroups) {
            List<Integer> originalQueryIds = queryGroup.getQueryIds();
            ArrayList<DataQuery> originalQueries = new ArrayList<DataQuery>(originalQueryIds.size());
            for (Integer originalQueryId : originalQueryIds) {
                originalQueries.add((DataQuery)((Object)queryByOriginalId.get(originalQueryId)));
            }
            queryGroup.removeAllQueries();
            queryGroup.setQueries(originalQueries);
        }
        for (DataCleansingStep step : cleansingSteps) {
            DataQuery query = (DataQuery)((Object)queryByOriginalId.get(step.getQueryId()));
            step.setQuery(query);
        }
        for (DataCleansingChain chain : cleansingChains) {
            DataCleansingChainForm viewItem = (DataCleansingChainForm)((Object)CollectionUtils.findItem(this.cleansingChains, (Object)chain.getId()));
            List<Integer> stepIds = viewItem.getStepIds();
            for (Integer stepId : stepIds) {
                DataCleansingStep step = (DataCleansingStep)((Object)cleansingStepByOriginalId.get(stepId));
                chain.addStep(step);
            }
        }
        PersistedSurveyObjects.resetIds(queryTypes);
        PersistedSurveyObjects.resetIds(queries);
        PersistedSurveyObjects.resetIds(errorQueryGroups);
        PersistedSurveyObjects.resetIds(cleansingSteps);
        PersistedSurveyObjects.resetIds(cleansingChains);
        DataCleansingMetadata metadata = new DataCleansingMetadata(survey, queryTypes, queries, errorQueryGroups, cleansingSteps, cleansingChains);
        return metadata;
    }

    public List<DataQueryTypeForm> getDataQueryTypes() {
        return this.dataQueryTypes;
    }

    public List<DataQueryForm> getDataQueries() {
        return this.dataQueries;
    }

    public List<DataQueryGroupForm> getDataQueryGroups() {
        return this.dataQueryGroups;
    }

    public List<DataCleansingStepForm> getCleansingSteps() {
        return this.cleansingSteps;
    }

    public List<DataCleansingChainForm> getCleansingChains() {
        return this.cleansingChains;
    }

    private static class PersistedSurveyObjects {
        private PersistedSurveyObjects() {
        }

        public static <F extends DataCleansingItemForm<T>, T extends DataCleansingItem> List<F> convert(List<T> items, Class<F> resultType) {
            ArrayList<DataCleansingItemForm> result = new ArrayList<DataCleansingItemForm>(items.size());
            for (DataCleansingItem i : items) {
                try {
                    DataCleansingItemForm o = (DataCleansingItemForm)((Object)resultType.getDeclaredConstructor(((Object)((Object)i)).getClass()).newInstance(new Object[]{i}));
                    result.add(o);
                }
                catch (Exception e) {
                    String message = String.format("Error creating objects of type %s from type %s", resultType.getName(), ((Object)((Object)i)).getClass().getName());
                    throw new RuntimeException(message, e);
                }
            }
            return result;
        }

        private static <T extends DataCleansingItem> Map<Integer, T> createObjectFromIdMap(Collection<T> items) {
            HashMap<Number, DataCleansingItem> result = new HashMap<Number, DataCleansingItem>(items.size());
            for (DataCleansingItem item : items) {
                result.put(item.getId(), item);
            }
            return result;
        }

        private static <T extends DataCleansingItem> void resetIds(Collection<T> items) {
            for (DataCleansingItem item : items) {
                item.setId(null);
            }
        }

        private static <I extends DataCleansingItem, F extends DataCleansingItemForm<I>> List<I> toItems(CollectSurvey survey, List<F> formItems, Class<I> itemType) {
            if (org.apache.commons.collections.CollectionUtils.isEmpty(formItems)) {
                return Collections.emptyList();
            }
            ArrayList<DataCleansingItem> items = new ArrayList<DataCleansingItem>(formItems.size());
            for (DataCleansingItemForm form : formItems) {
                try {
                    DataCleansingItem item = (DataCleansingItem)((Object)itemType.getDeclaredConstructor(CollectSurvey.class, UUID.class).newInstance(survey, form.getUuid()));
                    form.copyTo((Object)item, new String[]{"uuid"});
                    items.add(item);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating items from form items", e);
                }
            }
            return items;
        }
    }
}

