/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.util.UUID;
import org.openforis.collect.datacleansing.DataCleansingItem;
import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;

public class DataQuery
extends DataCleansingItem {
    private static final long serialVersionUID = 1L;
    private String title;
    private String description;
    private int entityDefinitionId;
    private int attributeDefinitionId;
    private String conditions;
    private ErrorSeverity errorSeverity;
    private Integer typeId;
    private transient DataQueryType type;

    public DataQuery(CollectSurvey survey) {
        super(survey);
    }

    public DataQuery(CollectSurvey survey, UUID uuid) {
        super(survey, uuid);
    }

    public EntityDefinition getEntityDefinition() {
        NodeDefinition def = this.getSurvey().getSchema().getDefinitionById(this.entityDefinitionId);
        return (EntityDefinition)def;
    }

    public AttributeDefinition getAttributeDefinition() {
        NodeDefinition def = this.getSurvey().getSchema().getDefinitionById(this.attributeDefinitionId);
        if (def == null) {
            throw new IllegalStateException(String.format("Definition with id %d not found in the schema", this.attributeDefinitionId));
        }
        return (AttributeDefinition)def;
    }

    public void setAttributeDefinition(AttributeDefinition def) {
        this.attributeDefinitionId = def.getId();
    }

    public void setEntityDefinition(EntityDefinition def) {
        this.entityDefinitionId = def.getId();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getEntityDefinitionId() {
        return this.entityDefinitionId;
    }

    public void setEntityDefinitionId(int entityDefinitionId) {
        this.entityDefinitionId = entityDefinitionId;
    }

    public int getAttributeDefinitionId() {
        return this.attributeDefinitionId;
    }

    public void setAttributeDefinitionId(int attributeDefinitionId) {
        this.attributeDefinitionId = attributeDefinitionId;
    }

    public String getConditions() {
        return this.conditions;
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public ErrorSeverity getErrorSeverity() {
        return this.errorSeverity;
    }

    public void setErrorSeverity(ErrorSeverity severity) {
        this.errorSeverity = severity;
    }

    public Integer getTypeId() {
        return this.type == null ? this.typeId : (Integer)this.type.getId();
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
        this.type = null;
    }

    public DataQueryType getType() {
        return this.type;
    }

    public void setType(DataQueryType type) {
        this.type = type;
        this.typeId = type == null ? null : (Integer)type.getId();
    }

    public boolean deepEquals(Object obj, boolean ignoreId) {
        if (this == obj) {
            return true;
        }
        if (!super.deepEquals(obj, ignoreId)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataQuery other = (DataQuery)((Object)obj);
        if (this.attributeDefinitionId != other.attributeDefinitionId) {
            return false;
        }
        if (this.conditions == null ? other.conditions != null : !this.conditions.equals(other.conditions)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.entityDefinitionId != other.entityDefinitionId) {
            return false;
        }
        if (this.errorSeverity != other.errorSeverity) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.deepEquals((Object)other.type, ignoreId)) {
            return false;
        }
        return ignoreId || !(this.typeId == null ? other.typeId != null : !this.typeId.equals(other.typeId));
    }

    public static enum ErrorSeverity {
        ERROR('e'),
        WARNING('w'),
        NO_ERROR('n');

        private char code;

        private ErrorSeverity(char code) {
            this.code = code;
        }

        public static ErrorSeverity fromCode(String code) {
            if (code == null || code.length() > 1) {
                throw new IllegalArgumentException("Invalid code for Severity: " + code);
            }
            return ErrorSeverity.fromCode(code.charAt(0));
        }

        public static ErrorSeverity fromCode(char code) {
            ErrorSeverity[] values;
            for (ErrorSeverity severity : values = ErrorSeverity.values()) {
                if (severity.code != code) continue;
                return severity;
            }
            throw new IllegalArgumentException("Invalid code for Severity: " + code);
        }

        public char getCode() {
            return this.code;
        }
    }
}

