/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.controller;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataReport;
import org.openforis.collect.datacleansing.DataReportGeneratorJob;
import org.openforis.collect.datacleansing.DataReportItem;
import org.openforis.collect.datacleansing.form.DataReportForm;
import org.openforis.collect.datacleansing.form.DataReportItemForm;
import org.openforis.collect.datacleansing.manager.DataQueryGroupManager;
import org.openforis.collect.datacleansing.manager.DataReportManager;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Dates;
import org.openforis.collect.web.controller.AbstractSurveyObjectEditFormController;
import org.openforis.collect.web.controller.CollectJobController;
import org.openforis.collect.web.controller.PaginatedResponse;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.commons.lang.Objects;
import org.openforis.commons.web.HttpResponses;
import org.openforis.commons.web.Response;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.model.AbstractValue;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.CoordinateAttribute;
import org.openforis.idm.model.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/datacleansing/datareports"})
public class DataReportController
extends AbstractSurveyObjectEditFormController<Integer, DataReport, DataReportForm, DataReportManager> {
    private static final String DATA_REPORT_CSV_FILE_NAME_FORMAT = "%s (data report - %s).csv";
    @Autowired
    private DataQueryGroupManager dataQueryGroupManager;
    @Autowired
    private CollectJobManager collectJobManager;
    private DataReportGeneratorJob generationJob;
    private ReportExportJob exportJob;

    @Override
    protected DataReportForm createFormInstance(DataReport item) {
        DataReportForm form = new DataReportForm(item);
        form.setItemCount(((DataReportManager)this.itemManager).countItems(item));
        form.setAffectedRecordsCount(((DataReportManager)this.itemManager).countAffectedRecords(item));
        return form;
    }

    @Override
    protected DataReport createItemInstance(CollectSurvey survey) {
        return new DataReport(survey);
    }

    @RequestMapping(value={"generate.json"}, method={RequestMethod.POST})
    @ResponseBody
    public Response generate(@RequestParam int queryGroupId, @RequestParam CollectRecord.Step recordStep) {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        DataQueryGroup queryGroup = (DataQueryGroup)this.dataQueryGroupManager.loadById(survey, queryGroupId);
        this.generationJob = (DataReportGeneratorJob)this.collectJobManager.createJob(DataReportGeneratorJob.class);
        this.generationJob.setQueryGroup(queryGroup);
        this.generationJob.setRecordStep(recordStep);
        this.generationJob.setActiveUser(this.getLoggedUser());
        this.collectJobManager.start((Job)this.generationJob);
        return new Response();
    }

    @RequestMapping(value={"{reportId}/start-export.json"}, method={RequestMethod.POST})
    @ResponseBody
    public CollectJobController.JobView startExport(@PathVariable int reportId) throws Exception {
        return this.startExport(reportId, GroupedByRecordCSVWriterDataReportItemProcessor.class);
    }

    @RequestMapping(value={"{reportId}/start-export-for-collect-earth.json"}, method={RequestMethod.POST})
    @ResponseBody
    public CollectJobController.JobView startExportForCollectEarth(@PathVariable int reportId) throws Exception {
        return this.startExport(reportId, CollectEarthCSVWriterDataReportItemProcessor.class);
    }

    private CollectJobController.JobView startExport(int reportId, Class<? extends CSVWriterDataReportItemProcessor> itemProcessorType) throws Exception {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        DataReport report = (DataReport)((DataReportManager)this.itemManager).loadById(survey, reportId);
        this.exportJob = new ReportExportJob();
        this.exportJob.setSurvey(survey);
        this.exportJob.setReport(report);
        this.exportJob.setItemProcessorType(itemProcessorType);
        this.exportJob.setReportManager((DataReportManager)this.itemManager);
        this.collectJobManager.start((Job)this.exportJob);
        return new CollectJobController.JobView(this.exportJob);
    }

    @RequestMapping(value={"{reportId}/report.csv"}, method={RequestMethod.GET})
    private void downloadExportedFile(HttpServletResponse response, @PathVariable int reportId) throws Exception {
        File file = this.exportJob.getOutputFile();
        DataReport report = this.exportJob.report;
        String outputFileName = String.format(DATA_REPORT_CSV_FILE_NAME_FORMAT, report.getQueryGroup().getTitle(), Dates.formatDate((Date)report.getCreationDate()));
        Controllers.writeFileToResponse(response, file, outputFileName, "text/csv");
    }

    @RequestMapping(value={"{reportId}/items.json"}, method={RequestMethod.GET})
    @ResponseBody
    public PaginatedResponse loadItems(@PathVariable int reportId, @RequestParam int offset, @RequestParam int limit) {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        DataReport report = (DataReport)((DataReportManager)this.itemManager).loadById(survey, reportId);
        int total = ((DataReportManager)this.itemManager).countItems(report);
        List<DataReportItem> items = ((DataReportManager)this.itemManager).loadItems(report, offset, limit);
        ArrayList<DataReportItemForm> rows = new ArrayList<DataReportItemForm>(items.size());
        for (DataReportItem item : items) {
            rows.add(new DataReportItemForm(item));
        }
        return new PaginatedResponse(total, rows);
    }

    @RequestMapping(value={"generate/job.json"}, method={RequestMethod.GET})
    @ResponseBody
    public CollectJobController.JobView getCurrentGenearationJob(HttpServletResponse response) {
        return this.getJobView(response, this.generationJob);
    }

    @RequestMapping(value={"export/job.json"}, method={RequestMethod.GET})
    @ResponseBody
    public CollectJobController.JobView getCurrentExportJob(HttpServletResponse response) {
        return this.getJobView(response, this.exportJob);
    }

    private CollectJobController.JobView getJobView(HttpServletResponse response, Job job) {
        if (job == null) {
            HttpResponses.setNoContentStatus((HttpServletResponse)response);
            return null;
        }
        return new CollectJobController.JobView(job);
    }

    @RequestMapping(value={"generate/job.json"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Response cancelGenerationJob() {
        if (this.generationJob != null) {
            this.generationJob.abort();
        }
        return new Response();
    }

    private static class ReportExportJob
    extends Job {
        private CollectSurvey survey;
        private DataReport report;
        private Class<? extends CSVWriterDataReportItemProcessor> itemProcessorType;
        private DataReportManager reportManager;
        private File outputFile;

        protected void buildTasks() throws Throwable {
            ReportExportTask task = new ReportExportTask();
            this.addTask((Worker)task);
        }

        public void setReportManager(DataReportManager reportManager) {
            this.reportManager = reportManager;
        }

        public void setSurvey(CollectSurvey survey) {
            this.survey = survey;
        }

        public void setReport(DataReport report) {
            this.report = report;
        }

        public void setItemProcessorType(Class<? extends CSVWriterDataReportItemProcessor> itemProcessorType) {
            this.itemProcessorType = itemProcessorType;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        private class ReportExportTask
        extends Task {
            protected long countTotalItems() {
                return ReportExportJob.this.reportManager.countItems(ReportExportJob.this.report);
            }

            protected void execute() throws Throwable {
                EntityDefinition rootEntityDefinition = ReportExportJob.this.survey.getSchema().getFirstRootEntityDefinition();
                CSVWriterDataReportItemProcessor itemProcessor = (CSVWriterDataReportItemProcessor)Objects.newInstance((Class)ReportExportJob.this.itemProcessorType, (Object[])new Object[]{rootEntityDefinition});
                itemProcessor.init();
                long total = this.getTotalItems();
                int itemsPerPage = 200;
                int pages = Double.valueOf(Math.ceil((double)total / (double)itemsPerPage)).intValue();
                block0: for (int page = 1; page <= pages && this.isRunning(); ++page) {
                    List<DataReportItem> items = ReportExportJob.this.reportManager.loadItems(ReportExportJob.this.report, (page - 1) * itemsPerPage, itemsPerPage);
                    for (DataReportItem item : items) {
                        if (!this.isRunning()) continue block0;
                        itemProcessor.process(item);
                        this.incrementProcessedItems();
                    }
                }
                itemProcessor.close();
                ReportExportJob.this.outputFile = itemProcessor.getOutputFile();
            }
        }
    }

    public static class CollectEarthCSVWriterDataReportItemProcessor
    extends GroupedByRecordCSVWriterDataReportItemProcessor {
        private static final String X_COORDINATE_HEADER = "XCOORD";
        private static final String Y_COORDINATE_HEADER = "YCOORD";
        private static final String LOCATION_ATTRIBUTE_NAME = "location";
        private List<AttributeDefinition> fromCSVAttributes;
        private String locationAttributePath;
        private List<String> fromCSVAttributePaths;

        public CollectEarthCSVWriterDataReportItemProcessor(EntityDefinition rootEntityDefinition) {
            super(rootEntityDefinition);
            this.locationAttributePath = rootEntityDefinition.getName() + '/' + LOCATION_ATTRIBUTE_NAME;
            this.fromCSVAttributes = this.determineFromCSVAttributes();
            this.fromCSVAttributePaths = new ArrayList<String>(this.fromCSVAttributes.size());
            for (AttributeDefinition def : this.fromCSVAttributes) {
                String attrPath = rootEntityDefinition.getName() + '/' + def.getName();
                this.fromCSVAttributePaths.add(attrPath);
            }
        }

        @Override
        protected List<String> determineExtraHeaders() {
            ArrayList<String> extraHeaders = new ArrayList<String>();
            extraHeaders.add(Y_COORDINATE_HEADER);
            extraHeaders.add(X_COORDINATE_HEADER);
            for (AttributeDefinition def : this.fromCSVAttributes) {
                extraHeaders.add(def.getName());
            }
            extraHeaders.addAll(super.determineExtraHeaders());
            return extraHeaders;
        }

        @Override
        protected List<String> determineExtraValues(DataReportItem item) {
            ArrayList<String> values = new ArrayList<String>();
            CollectRecord record = item.getRecord();
            CoordinateAttribute locationAttr = (CoordinateAttribute)record.findNodeByPath(this.locationAttributePath);
            Coordinate location = locationAttr.getValue();
            values.add(String.valueOf(location.getY()));
            values.add(String.valueOf(location.getX()));
            for (String attrPath : this.fromCSVAttributePaths) {
                Attribute attr = (Attribute)record.findNodeByPath(attrPath);
                values.add(this.extractCSVValue(attr));
            }
            values.addAll(super.determineExtraValues(item));
            return values;
        }

        private String extractCSVValue(Attribute<?, ?> attr) {
            if (attr == null || attr.isEmpty()) {
                return "";
            }
            Value value = attr.getValue();
            if (value instanceof AbstractValue) {
                return ((AbstractValue)value).toPrettyFormatString();
            }
            return value.toString();
        }

        private List<AttributeDefinition> determineFromCSVAttributes() {
            CollectSurvey survey = (CollectSurvey)this.rootEntityDefinition.getSurvey();
            final CollectAnnotations annotations = survey.getAnnotations();
            final ArrayList<AttributeDefinition> defs = new ArrayList<AttributeDefinition>();
            this.rootEntityDefinition.traverse(new NodeDefinitionVisitor(){

                public void visit(NodeDefinition def) {
                    if (def instanceof AttributeDefinition && annotations.isFromCollectEarthCSV((AttributeDefinition)def)) {
                        defs.add((AttributeDefinition)def);
                    }
                }
            });
            return defs;
        }
    }

    public static class GroupedByRecordCSVWriterDataReportItemProcessor
    extends CSVWriterDataReportItemProcessor {
        private static final String WARNINGS_HEADER = "warnings";
        private static final String ERRORS_HEADER = "errors";
        private static final String ERRORS_SEPARATOR = "; \r\n";
        private RecordReportInfo lastRecordReportInfo;

        public GroupedByRecordCSVWriterDataReportItemProcessor(EntityDefinition rootEntityDefinition) {
            super(rootEntityDefinition);
        }

        @Override
        public void process(DataReportItem item) {
            if (this.lastRecordReportInfo != null && this.lastRecordReportInfo.getRecordId() != item.getRecordId()) {
                this.writeLastRecordInfo();
                this.lastRecordReportInfo = null;
            }
            if (this.lastRecordReportInfo == null) {
                this.lastRecordReportInfo = new RecordReportInfo(item.getRecordId(), item.getRecordKeyValues());
                this.lastRecordReportInfo.setExtraValues(this.determineExtraValues(item));
            }
            String queryTitle = item.getQuery().getTitle();
            if (item.getQuery().getErrorSeverity() == DataQuery.ErrorSeverity.ERROR) {
                this.lastRecordReportInfo.addError(queryTitle);
            } else {
                this.lastRecordReportInfo.addWarning(queryTitle);
            }
        }

        protected List<String> determineExtraValues(DataReportItem item) {
            return Collections.emptyList();
        }

        private void writeLastRecordInfo() {
            ArrayList<String> lineValues = new ArrayList<String>();
            lineValues.addAll(this.lastRecordReportInfo.getKeyValues());
            lineValues.addAll(this.lastRecordReportInfo.getExtraValues());
            lineValues.add(StringUtils.join(this.lastRecordReportInfo.getErrors(), (String)ERRORS_SEPARATOR));
            lineValues.add(StringUtils.join(this.lastRecordReportInfo.getWarnings(), (String)ERRORS_SEPARATOR));
            this.csvWriter.writeNext(lineValues);
        }

        @Override
        public void close() throws IOException {
            if (this.lastRecordReportInfo != null) {
                this.writeLastRecordInfo();
            }
            super.close();
        }

        @Override
        protected List<String> determineExtraHeaders() {
            return Arrays.asList(ERRORS_HEADER, WARNINGS_HEADER);
        }

        protected class RecordReportInfo {
            private int recordId;
            private List<String> keyValues;
            private List<String> extraValues;
            private List<String> errors = new ArrayList<String>();
            private List<String> warnings = new ArrayList<String>();

            public RecordReportInfo(int recordId, List<String> keyValues) {
                this.recordId = recordId;
                this.keyValues = keyValues;
            }

            public List<String> getKeyValues() {
                return this.keyValues;
            }

            public void addError(String error) {
                this.errors.add(error);
            }

            public void addWarning(String warning) {
                this.warnings.add(warning);
            }

            public int getRecordId() {
                return this.recordId;
            }

            public List<String> getExtraValues() {
                return this.extraValues;
            }

            public void setExtraValues(List<String> extraValues) {
                this.extraValues = extraValues;
            }

            public List<String> getErrors() {
                return this.errors;
            }

            public List<String> getWarnings() {
                return this.warnings;
            }
        }
    }

    private static abstract class CSVWriterDataReportItemProcessor
    implements Closeable {
        protected CsvWriter csvWriter;
        private File tempFile;
        protected EntityDefinition rootEntityDefinition;

        public CSVWriterDataReportItemProcessor(EntityDefinition rootEntityDefinition) {
            this.rootEntityDefinition = rootEntityDefinition;
        }

        public void init() throws Exception {
            this.tempFile = File.createTempFile("collect-data-report", ".csv");
            this.csvWriter = new CsvWriter((OutputStream)new FileOutputStream(this.tempFile), "UTF-8", ',', '\"');
            this.writeCSVHeader();
        }

        private void writeCSVHeader() {
            List<String> headers = this.determineHeaders();
            this.csvWriter.writeHeaders(headers);
        }

        protected List<String> determineHeaders() {
            ArrayList<String> headers = new ArrayList<String>();
            List keyAttributeDefinitions = this.rootEntityDefinition.getKeyAttributeDefinitions();
            for (AttributeDefinition def : keyAttributeDefinitions) {
                String keyLabel = def.getLabel(NodeLabel.Type.INSTANCE);
                if (StringUtils.isBlank((CharSequence)keyLabel)) {
                    keyLabel = def.getName();
                }
                headers.add(keyLabel);
            }
            headers.addAll(this.determineExtraHeaders());
            return headers;
        }

        protected List<String> determineExtraHeaders() {
            return Collections.emptyList();
        }

        public abstract void process(DataReportItem var1);

        @Override
        public void close() throws IOException {
            this.csvWriter.close();
        }

        public File getOutputFile() {
            return this.tempFile;
        }
    }
}

