/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.manager;

import java.util.HashMap;
import java.util.List;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataReport;
import org.openforis.collect.datacleansing.DataReportItem;
import org.openforis.collect.datacleansing.manager.DataQueryGroupManager;
import org.openforis.collect.datacleansing.persistence.DataReportDao;
import org.openforis.collect.datacleansing.persistence.DataReportItemDao;
import org.openforis.collect.manager.AbstractSurveyObjectManager;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataReportManager")
public class DataReportManager
extends AbstractSurveyObjectManager<Integer, DataReport, DataReportDao> {
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private DataQueryGroupManager queryGroupManager;
    @Autowired
    private DataReportItemDao dataReportItemDao;

    public void delete(DataReport obj) {
        this.dataReportItemDao.deleteByReport(obj);
        super.delete((PersistedSurveyObject)obj);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        this.dataReportItemDao.deleteBySurvey(survey);
        super.deleteBySurvey(survey);
    }

    public void saveItems(DataReport report, List<DataReportItem> items) {
        this.dataReportItemDao.insert(report, items);
    }

    public int countItems(DataReport report) {
        return this.dataReportItemDao.countItems(report);
    }

    public int countAffectedRecords(DataReport report) {
        return this.dataReportItemDao.countAffectedRecords(report);
    }

    public List<DataReportItem> loadItems(DataReport report) {
        return this.loadItems(report, null, null);
    }

    public List<DataReport> loadByQueryGroup(DataQueryGroup queryGroup) {
        List<DataReport> reports = ((DataReportDao)this.dao).loadByQueryGroup(queryGroup);
        this.initializeItems(reports);
        return reports;
    }

    public List<DataReportItem> loadItems(DataReport report, Integer offset, Integer limit) {
        CollectSurvey survey = (CollectSurvey)report.getSurvey();
        HashMap<Integer, CollectRecord> recordCache = new HashMap<Integer, CollectRecord>();
        List<DataReportItem> items = this.dataReportItemDao.loadByReport(report, offset, limit);
        for (DataReportItem item : items) {
            int recordId = item.getRecordId();
            CollectRecord record = (CollectRecord)recordCache.get(recordId);
            if (record == null) {
                record = this.recordManager.load(survey, recordId, report.getRecordStep(), false);
                recordCache.put(recordId, record);
            }
            item.setRecord(record);
        }
        return items;
    }

    protected void initializeItem(DataReport i) {
        super.initializeItem((PersistedSurveyObject)i);
        this.initQueryGroup(i);
    }

    private void initQueryGroup(DataReport report) {
        DataQueryGroup queryGroup = (DataQueryGroup)this.queryGroupManager.loadById((CollectSurvey)report.getSurvey(), report.getQueryGroupId());
        report.setQueryGroup(queryGroup);
    }
}

