/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.component.SchemaTreeModel;
import org.openforis.collect.designer.component.SchemaTreeModelCreator;
import org.openforis.collect.designer.component.SurveyObjectTreeModelCreator;
import org.openforis.collect.designer.component.UITreeModelCreator;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.designer.util.ComponentUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.AttributeConversionVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.CodeListsVM;
import org.openforis.collect.designer.viewmodel.NodeDefinitionVM;
import org.openforis.collect.designer.viewmodel.SchemaObjectSelectorPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.validation.CollectEarthSurveyValidator;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.KeyAttributeDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.SurveyObject;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Include;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Window;

public class SchemaVM
extends SurveyBaseVM {
    public static final String EDITED_NODE_TYPE_CHANGED = "editedNodeTypeChanged";
    private static final String PATH_NULL_VALUES_REPLACE = "...";
    private static final String TAB_NAME_LABEL_PATH = "labelTextbox";
    private static final String ENTITY_NAME_TEXTBOX_PATH = "nodeCommonInclude/nodeNameTextbox";
    private static final String ATTRIBUTE_NAME_TEXTBOX_PATH = "attributeCommonInclude/nodeCommonInclude/nodeNameTextbox";
    private static final String NODE_TYPES_IMAGES_PATH = "/assets/images/node_types/";
    private static final String VALIDATE_COMMAND = "validate";
    private static final String APPLY_CHANGES_COMMAND = "applyChanges";
    private static final String CONFIRM_REMOVE_NODE_MESSAGE_KEY = "survey.schema.confirm_remove_node";
    private static final String CONFIRM_REMOVE_NON_EMPTY_ENTITY_MESSAGE_KEY = "survey.schema.confirm_remove_non_empty_entity";
    private static final String CONFIRM_REMOVE_NODE_WITH_DEPENDENCIES_MESSAGE_KEY = "survey.schema.confirm_remove_node_with_dependencies";
    private static final String CONFIRM_REMOVE_REFERENCED_ATTRIBUTE_MESSAGE_KEY = "survey.schema.attribute.confirm_remove_referenced_attribute";
    private static final String CONFIRM_REMOVE_NODE_TITLE_KEY = "survey.schema.confirm_remove_node_title";
    private static final Set<AttributeType> SUPPORTED_COLLECT_EARTH_ATTRIBUTE_TYPES = Collections.unmodifiableSet(new HashSet<AttributeType>(Arrays.asList(AttributeType.BOOLEAN, AttributeType.CODE, AttributeType.DATE, AttributeType.NUMBER, AttributeType.TEXT, AttributeType.TIME)));
    private static final Pattern CLONED_NAME_PATTERN = Pattern.compile("(.*)(\\d+)");
    private SchemaTreeModel.SchemaNodeData selectedTreeNode;
    private SurveyObject editedNode;
    private boolean newNode;
    private EntityDefinition selectedRootEntity;
    private UITabSet rootTabSet;
    private ModelVersion selectedVersion;
    private String selectedTreeViewType;
    private EntityDefinition editedNodeParentEntity;
    @Wire
    private Include nodeFormInclude;
    @Wire
    private Tree nodesTree;
    @Wire
    private Menupopup mainTabPopup;
    @Wire
    private Menupopup tabPopup;
    @Wire
    private Menupopup singleEntityPopup;
    @Wire
    private Menupopup tableEntityPopup;
    @Wire
    private Menupopup formEntityPopup;
    @Wire
    private Menupopup attributePopup;
    @Wire
    private Menupopup detachedNodePopup;
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private CodeListManager codeListManager;
    private Window rootEntityEditPopUp;
    private SchemaTreeModel treeModel;

    public SchemaVM() {
        this.fieldLabelKeyPrefixes.addAll(0, Arrays.asList("survey.schema.attribute", "survey.schema.node", "global.item"));
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @AfterCompose
    public void doAfterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        Selectors.wireComponents((Component)view, (Object)this, (boolean)false);
        Selectors.wireEventListeners((Component)view, (Object)this);
        this.selectedTreeViewType = TreeViewType.ENTRY.name().toLowerCase(Locale.ENGLISH);
        List<EntityDefinition> rootEntities = this.getRootEntities();
        if (rootEntities.size() > 0) {
            EntityDefinition mainRootEntity = rootEntities.get(0);
            this.performNodeTreeFilterChange(mainRootEntity, null);
        }
    }

    @Command
    public void nodeSelected(final @ContextParam(value=ContextType.BINDER) Binder binder, final @ContextParam(value=ContextType.VIEW) Component view, final @BindingParam(value="data") SchemaTreeModel.SchemaNodeData data) {
        if (data != null) {
            this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormCompleteConfirmHandler(){

                @Override
                public void onOk(boolean confirmed) {
                    if (confirmed) {
                        SchemaVM.this.undoLastChanges(view);
                    }
                    SchemaVM.this.performSelectNode(binder, data);
                }

                @Override
                public void onCancel() {
                    SchemaVM.this.treeModel.select(SchemaVM.this.selectedTreeNode);
                }
            });
        } else {
            this.resetEditingStatus();
        }
    }

    @Command
    public void rootEntitySelected(@BindingParam(value="rootEntity") EntityDefinition rootEntity) {
        this.nodesTreeFilterChanged(rootEntity, this.selectedVersion);
    }

    @Command
    public void versionSelected(@BindingParam(value="version") Object version) {
        ModelVersion modelVersion = version == FormObject.VERSION_EMPTY_SELECTION ? null : (ModelVersion)version;
        this.nodesTreeFilterChanged(this.selectedRootEntity, modelVersion);
    }

    protected void nodesTreeFilterChanged(final EntityDefinition rootEntity, final ModelVersion version) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormCompleteConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                SchemaVM.this.performNodeTreeFilterChange(rootEntity, version);
            }

            @Override
            public void onCancel() {
                SchemaVM.this.notifyChange("selectedRootEntity", "selectedVersion");
            }
        });
    }

    private void performNodeTreeFilterChange(EntityDefinition rootEntity, ModelVersion version) {
        this.selectedRootEntity = rootEntity;
        this.rootTabSet = this.survey.getUIOptions().getAssignedRootTabSet(rootEntity);
        this.selectedVersion = version;
        this.resetEditingStatus();
        this.refreshTreeModel();
        this.dispatchCurrentFormValidatedCommand(true, this.isCurrentFormBlocking());
        this.notifyChange("selectedTreeNode", "selectedRootEntity", "selectedVersion", "treeModel");
    }

    protected void performSelectNode(Binder binder, SchemaTreeModel.SchemaNodeData data) {
        this.selectedTreeNode = data;
        this.treeModel.select(data);
        SurveyObject surveyObject = data.getSurveyObject();
        EntityDefinition parentDefn = this.treeModel.getNearestParentEntityDefinition(surveyObject);
        this.editNode(binder, false, parentDefn, surveyObject);
    }

    @Command
    public void addRootEntity() {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                SchemaVM.this.resetNodeSelection();
                SchemaVM.this.resetEditingStatus();
                EntityDefinition rootEntity = SchemaVM.this.createRootEntityDefinition();
                SchemaVM.this.selectedRootEntity = rootEntity;
                SchemaVM.this.selectedVersion = null;
                SchemaVM.this.refreshTreeModel();
                SchemaVM.this.selectTreeNode(null);
                SchemaVM.this.notifyChange("selectedRootEntity", "selectedVersion");
                SchemaVM.this.editRootEntity();
            }
        });
    }

    @Command
    public void addEntity(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="multiple") boolean multiple, @BindingParam(value="layout") String layout) {
        this.resetNodeSelection();
        this.addChildEntity(binder, multiple, layout, false);
    }

    @Command
    public void addChildEntity(final @ContextParam(value=ContextType.BINDER) Binder binder, final @BindingParam(value="multiple") boolean multiple, final @BindingParam(value="layout") String layout, final @BindingParam(value="virtual") boolean virtual) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                EntityDefinition parentEntity = SchemaVM.this.getSelectedNodeParentEntity();
                EntityDefinition newNode = SchemaVM.this.createEntityDefinition();
                newNode.setMultiple(multiple);
                newNode.setVirtual(virtual);
                UIOptions uiOptions = SchemaVM.this.survey.getUIOptions();
                UIOptions.Layout layoutEnum = UIOptions.Layout.valueOf((String)layout);
                SurveyObject selectedSurveyObject = SchemaVM.this.selectedTreeNode.getSurveyObject();
                UITab parentTab = null;
                if (selectedSurveyObject instanceof UITab) {
                    parentTab = (UITab)selectedSurveyObject;
                }
                if (uiOptions.isLayoutSupported(parentEntity, newNode.getId(), parentTab, multiple, layoutEnum)) {
                    uiOptions.setLayout(newNode, layoutEnum);
                    if (parentTab != null) {
                        uiOptions.assignToTab((NodeDefinition)newNode, parentTab);
                    }
                    SchemaVM.this.editNode(binder, true, parentEntity, (SurveyObject)newNode);
                    SchemaVM.this.afterNewNodeCreated((SurveyObject)newNode, true);
                } else {
                    MessageUtil.showWarning("survey.schema.entity.layout.not_supported_error", new Object[0]);
                }
            }
        });
    }

    private EntityDefinition getSelectedNodeParentEntity() {
        if (this.selectedTreeNode == null) {
            return this.selectedRootEntity;
        }
        SurveyObject surveyObject = this.selectedTreeNode.getSurveyObject();
        return this.getNearestEntity(surveyObject);
    }

    @Command
    public void addAttribute(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="attributeType") String attributeType) throws Exception {
        this.resetNodeSelection();
        this.addChildAttribute(binder, attributeType);
    }

    @Command
    public void addChildAttribute(final @ContextParam(value=ContextType.BINDER) Binder binder, final @BindingParam(value="attributeType") String attributeType) throws Exception {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                AttributeType attributeTypeEnum = AttributeType.valueOf(attributeType);
                AttributeDefinition newNode = (AttributeDefinition)NodeType.createNodeDefinition((Survey)SchemaVM.this.survey, NodeType.ATTRIBUTE, attributeTypeEnum);
                SurveyObject selectedSurveyObject = SchemaVM.this.selectedTreeNode.getSurveyObject();
                if (selectedSurveyObject instanceof UITab) {
                    UIOptions uiOptions = SchemaVM.this.survey.getUIOptions();
                    uiOptions.assignToTab((NodeDefinition)newNode, (UITab)selectedSurveyObject);
                }
                EntityDefinition parentEntity = SchemaVM.this.getSelectedNodeParentEntity();
                SchemaVM.this.editNode(binder, true, parentEntity, (SurveyObject)newNode);
                SchemaVM.this.afterNewNodeCreated((SurveyObject)newNode, true);
            }
        });
    }

    private void afterNewNodeCreated(SurveyObject surveyObject, boolean detached) {
        this.treeModel.appendNodeToSelected(surveyObject, detached);
        this.selectTreeNode(surveyObject);
        this.notifyChange("treeModel");
    }

    @Command
    public void expandTree() {
        this.treeModel.openAllItems();
        this.notifyChange("treeModel");
    }

    @Command
    public void collapseTree() {
        this.treeModel.clearOpen();
        this.notifyChange("treeModel");
    }

    @Override
    public void undoLastChanges() {
        super.undoLastChanges();
        if (this.editedNode != null) {
            if (this.newNode) {
                this.treeModel.select(this.editedNode);
                this.treeModel.removeSelectedNode();
            } else {
                String committedLabel = this.editedNode instanceof NodeDefinition ? ((NodeDefinition)this.editedNode).getName() : ((UITab)this.editedNode).getLabel(this.currentLanguageCode);
                this.updateTreeNodeLabel(this.editedNode, committedLabel);
                this.updateTreeNodeIcon();
            }
            this.resetEditingStatus(false);
        }
    }

    @GlobalCommand
    public void editedNodeNameChanging(@BindingParam(value="item") SurveyObject item, @BindingParam(value="name") String name) {
        if (this.editedNode != null && this.editedNode == item) {
            this.updateTreeNodeLabel(this.editedNode, name);
        }
    }

    @GlobalCommand
    public void editedNodeKeyChanging(@BindingParam(value="item") SurveyObject item, @BindingParam(value="key") boolean key) {
        if (this.editedNode != null && this.editedNode == item) {
            this.updateTreeNodeIcon(this.editedNode, key, false);
        }
    }

    @GlobalCommand
    public void editedNodeCalculatedPropertyChanging(@BindingParam(value="item") SurveyObject item, @BindingParam(value="calculated") boolean calculated) {
        if (this.editedNode != null && this.editedNode == item) {
            this.updateTreeNodeIcon(this.editedNode, false, calculated);
        }
    }

    public static void dispatchEditedNodeTypeChangedGlobalCommand() {
        BindUtils.postGlobalCommand(null, null, (String)EDITED_NODE_TYPE_CHANGED, null);
    }

    @GlobalCommand
    public void editedNodeTypeChanged() {
        this.updateTreeNodeIcon();
    }

    private Treeitem getTreeItem(SurveyObject item) {
        for (Treeitem treeItem : this.nodesTree.getItems()) {
            SchemaTreeModel.SchemaTreeNode node = (SchemaTreeModel.SchemaTreeNode)((Object)treeItem.getValue());
            SchemaTreeModel.SchemaNodeData data = (SchemaTreeModel.SchemaNodeData)node.getData();
            SurveyObject itemSO = data.getSurveyObject();
            if (itemSO != item) continue;
            return treeItem;
        }
        return null;
    }

    private void updateTreeNodeLabel(SurveyObject item, String label) {
        this.treeModel.updateNodeLabel(item, label);
        Treeitem treeItem = this.getTreeItem(item);
        if (treeItem != null) {
            treeItem.setLabel(label);
        }
    }

    private void updateTreeNodeIcon() {
        boolean key = this.editedNode instanceof AttributeDefinition ? ((AttributeDefinition)this.editedNode).isKey() : false;
        boolean calculated = this.editedNode instanceof AttributeDefinition ? ((AttributeDefinition)this.editedNode).isCalculated() : false;
        this.updateTreeNodeIcon(this.editedNode, key, calculated);
    }

    private void updateTreeNodeIcon(SurveyObject item, boolean key, boolean calculated) {
        Treeitem treeItem = this.getTreeItem(item);
        if (treeItem != null) {
            SchemaTreeModel.SchemaNodeData data = this.treeModel.getNodeData(item);
            String icon = SchemaVM.getIcon(data.getSurveyObject(), key, calculated);
            treeItem.setImage(icon);
        }
    }

    @Override
    @GlobalCommand
    public void currentLanguageChanged() {
        super.currentLanguageChanged();
        this.refreshTreeModel();
    }

    @GlobalCommand
    public void schemaChanged() {
        this.refreshTreeModel();
    }

    @GlobalCommand
    public void nodeConverted(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="node") NodeDefinition nodeDef) {
        this.resetEditingStatus();
        this.refreshTreeModel();
        this.editNode(binder, false, nodeDef.getParentEntityDefinition(), (SurveyObject)nodeDef);
        this.selectTreeNode((SurveyObject)nodeDef);
    }

    protected void resetEditingStatus() {
        this.resetEditingStatus(true);
    }

    protected void resetEditingStatus(boolean notifyChange) {
        this.resetNodeSelection();
        this.editedNode = null;
        this.editedNodeParentEntity = null;
        this.refreshNodeForm();
        if (notifyChange) {
            this.notifyChange("editedNodeParentEntity", "editedNode");
        }
    }

    protected void resetNodeSelection() {
        this.selectedTreeNode = null;
        this.notifyChange("selectedTreeNode");
        this.resetTreeSelection();
    }

    protected void resetTreeSelection() {
        if (this.treeModel != null) {
            this.treeModel.deselect();
        }
    }

    protected void selectTreeNode(SurveyObject surveyObject) {
        this.treeModel.select(surveyObject);
        this.selectedTreeNode = this.treeModel.getNodeData(surveyObject);
        this.notifyChange("selectedTreeNode");
    }

    @Override
    @GlobalCommand
    public void versionsUpdated() {
        super.versionsUpdated();
        if (this.selectedVersion != null && !this.survey.getVersions().contains(this.selectedVersion)) {
            this.resetEditingStatus();
            this.selectedVersion = null;
            this.refreshTreeModel();
            this.notifyChange("selectedVersion");
        }
    }

    private void editNode(boolean newNode, EntityDefinition parentEntity, SurveyObject node) {
        this.editNode(null, newNode, parentEntity, node);
    }

    protected void editNode(Binder binder, boolean newNode, EntityDefinition parentEntity, SurveyObject node) {
        this.newNode = newNode;
        this.editedNodeParentEntity = parentEntity;
        this.editedNode = node;
        if (!newNode) {
            this.selectedTreeNode = this.treeModel.getNodeData(node);
        }
        this.refreshNodeForm();
        if (binder == null) {
            this.validateForm();
        } else {
            this.validateForm(binder);
        }
        this.notifyChange("selectedTreeNode", "editedNode");
    }

    protected void refreshNodeForm() {
        this.nodeFormInclude.setSrc(null);
        if (this.editedNode != null) {
            String nodeNameTextboxPath;
            String location;
            this.nodeFormInclude.setDynamicProperty("parentEntity", (Object)this.editedNodeParentEntity);
            this.nodeFormInclude.setDynamicProperty("item", (Object)this.editedNode);
            this.nodeFormInclude.setDynamicProperty("newItem", (Object)this.newNode);
            if (this.editedNode instanceof UITab) {
                location = Resources.Component.TAB.getLocation();
                nodeNameTextboxPath = TAB_NAME_LABEL_PATH;
            } else if (this.editedNode instanceof EntityDefinition) {
                location = Resources.Component.ENTITY.getLocation();
                nodeNameTextboxPath = ENTITY_NAME_TEXTBOX_PATH;
            } else {
                AttributeType attributeType = AttributeType.valueOf((AttributeDefinition)this.editedNode);
                String locationFormat = Resources.Component.ATTRIBUTE.getLocation();
                String attributeTypeShort = attributeType.name().toLowerCase(Locale.ENGLISH);
                location = MessageFormat.format(locationFormat, attributeTypeShort);
                nodeNameTextboxPath = ATTRIBUTE_NAME_TEXTBOX_PATH;
            }
            this.nodeFormInclude.setSrc(location);
            Textbox nodeNameTextbox = (Textbox)Path.getComponent((IdSpace)this.nodeFormInclude.getSpaceOwner(), (String)nodeNameTextboxPath);
            if (nodeNameTextbox != null) {
                nodeNameTextbox.setFocus(true);
            }
        }
    }

    protected void validateForm() {
        if (this.editedNode != null) {
            Binder binder = (Binder)this.nodeFormInclude.getAttribute("$BINDER$");
            if (binder != null) {
                this.validateForm(binder);
            }
        } else {
            this.dispatchCurrentFormValidatedCommand(true);
        }
    }

    protected void validateForm(@ContextParam(value=ContextType.BINDER) Binder binder) {
        Component view = binder.getView();
        IdSpace idSpace = view.getSpaceOwner();
        Binder formComponentBinder = this.getNodeFormBinder(idSpace);
        formComponentBinder.postCommand(VALIDATE_COMMAND, null);
    }

    protected Binder getNodeFormBinder(IdSpace idSpace) {
        Component formComponent = this.getNodeFormComponent(idSpace);
        Binder formComponentBinder = (Binder)formComponent.getAttribute("binder");
        return formComponentBinder;
    }

    protected Component getNodeFormComponent(IdSpace idSpace) {
        Component component = Path.getComponent((IdSpace)idSpace, (String)"nodeFormInclude/nodeFormContainer");
        return component;
    }

    protected void applyChangesToForm(IdSpace idSpace) {
        Binder binder = this.getNodeFormBinder(idSpace);
        binder.postCommand(APPLY_CHANGES_COMMAND, null);
    }

    @Command
    public void removeNode() {
        if (this.checkCanDeleteSelectedNode()) {
            this.removeTreeNode(this.selectedTreeNode);
        }
    }

    private boolean checkCanDeleteSelectedNode() {
        NodeDefinition nodeDef;
        SurveyObject surveyObject;
        if (this.isCollectEarthSurvey() && !this.selectedTreeNode.isDetached() && (surveyObject = this.selectedTreeNode.getSurveyObject()) instanceof NodeDefinition && this.isCollectEarthRequiredField(nodeDef = (NodeDefinition)surveyObject)) {
            MessageUtil.showWarning("survey.schema.cannot_remove_ce_required_field", nodeDef.getName());
            return false;
        }
        return true;
    }

    private boolean isCollectEarthRequiredField(NodeDefinition nodeDef) {
        return nodeDef.getParentEntityDefinition().isRoot() && CollectEarthSurveyValidator.REQUIRED_FIELD_NAMES.contains(nodeDef.getName());
    }

    private void removeTreeNode(SchemaTreeModel.SchemaNodeData data) {
        if (data.isDetached()) {
            this.performRemoveSelectedTreeNode();
        } else {
            SurveyObject surveyObject = data.getSurveyObject();
            if (surveyObject instanceof NodeDefinition) {
                this.removeNodeDefinition((NodeDefinition)surveyObject);
            } else {
                this.removeTab((UITab)surveyObject);
            }
        }
    }

    protected void removeNodeDefinition(final NodeDefinition nodeDefn) {
        boolean isRootEntity;
        String confirmMessageKey;
        Object[] extraMessageArgs = null;
        if (nodeDefn instanceof EntityDefinition && !((EntityDefinition)nodeDefn).getChildDefinitions().isEmpty()) {
            confirmMessageKey = CONFIRM_REMOVE_NON_EMPTY_ENTITY_MESSAGE_KEY;
        } else if (nodeDefn.hasDependencies()) {
            confirmMessageKey = CONFIRM_REMOVE_NODE_WITH_DEPENDENCIES_MESSAGE_KEY;
        } else if (nodeDefn instanceof AttributeDefinition && !((AttributeDefinition)nodeDefn).getReferencingAttributes().isEmpty()) {
            confirmMessageKey = CONFIRM_REMOVE_REFERENCED_ATTRIBUTE_MESSAGE_KEY;
            List referencedAttrNames = CollectionUtils.project((Collection)((AttributeDefinition)nodeDefn).getReferencingAttributes(), (String)"name");
            extraMessageArgs = new String[]{StringUtils.join((Iterable)referencedAttrNames, (String)", ")};
        } else {
            confirmMessageKey = CONFIRM_REMOVE_NODE_MESSAGE_KEY;
        }
        NodeType type = NodeType.valueOf(nodeDefn);
        String typeLabel = type.getLabel().toLowerCase(Locale.ENGLISH);
        boolean bl = isRootEntity = nodeDefn.getParentDefinition() == null;
        if (isRootEntity) {
            typeLabel = Labels.getLabel((String)"survey.schema.root_entity");
        }
        Object[] messageArgs = new String[]{typeLabel, nodeDefn.getName()};
        if (extraMessageArgs != null) {
            messageArgs = ArrayUtils.addAll((Object[])messageArgs, (Object[])extraMessageArgs);
        }
        Object[] titleArgs = new String[]{typeLabel};
        MessageUtil.showConfirm(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                SchemaVM.this.performRemoveNode(nodeDefn);
            }
        }, confirmMessageKey, messageArgs, CONFIRM_REMOVE_NODE_TITLE_KEY, titleArgs, "global.remove_item", "global.cancel");
    }

    @Command
    public void removeRootEntity() {
        this.removeNodeDefinition((NodeDefinition)this.selectedRootEntity);
    }

    @Command
    public void editRootEntity() {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                if (confirmed) {
                    SchemaVM.this.undoLastChanges();
                }
                SchemaVM.this.openRootEntityEditPopUp();
            }
        });
    }

    private void openRootEntityEditPopUp() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("formLocation", Resources.Component.ENTITY.getLocation());
        args.put("title", Labels.getLabel((String)"survey.layout.root_entity"));
        args.put("parentEntity", null);
        args.put("item", this.selectedRootEntity);
        args.put("newItem", false);
        args.put("doNotCommitChangesImmediately", true);
        this.rootEntityEditPopUp = SchemaVM.openPopUp(Resources.Component.NODE_EDIT_POPUP.getLocation(), true, args);
    }

    @GlobalCommand
    public void applyChangesToEditedNodeInPopUp(@ContextParam(value=ContextType.BINDER) Binder binder) {
        Component nodeFormContainer = this.getNodeEditorForm();
        NodeDefinitionVM vm = (NodeDefinitionVM)ComponentUtil.getViewModel(nodeFormContainer);
        vm.dispatchValidateCommand(ComponentUtil.getBinder(nodeFormContainer));
        if (vm.isCurrentFormValid()) {
            vm.commitChanges(binder);
            this.closeNodeEditPopUp();
        } else {
            this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

                @Override
                public void onOk(boolean confirmed) {
                    SchemaVM.this.closeNodeEditPopUp();
                }
            });
        }
    }

    private Component getNodeEditorForm() {
        Component nodeFormContainer = this.rootEntityEditPopUp.getFellow("nodeFormInclude").getFellow("nodeFormContainer");
        return nodeFormContainer;
    }

    @GlobalCommand
    public void cancelChangesToEditedNodeInPopUp(@ContextParam(value=ContextType.BINDER) Binder binder) {
        Component nodeFormContainer = this.getNodeEditorForm();
        NodeDefinitionVM vm = (NodeDefinitionVM)ComponentUtil.getViewModel(nodeFormContainer);
        vm.undoLastChanges();
        this.closeNodeEditPopUp();
    }

    private void closeNodeEditPopUp() {
        SchemaVM.closePopUp(this.rootEntityEditPopUp);
        this.rootEntityEditPopUp = null;
        this.notifyChange("selectedRootEntity");
    }

    @Command
    public void moveNodeUp() {
        this.moveNode(true);
    }

    @Command
    public void moveNodeDown() {
        this.moveNode(false);
    }

    protected void moveNode(boolean up) {
        SurveyObject surveyObject = this.selectedTreeNode.getSurveyObject();
        List<SurveyObject> siblings = this.getSiblingsInTree(surveyObject);
        int oldIndex = siblings.indexOf(surveyObject);
        int newIndexInTree = up ? oldIndex - 1 : oldIndex + 1;
        this.moveNode(newIndexInTree);
    }

    protected void moveNode(int newIndexInTree) {
        SurveyObject surveyObject = this.selectedTreeNode.getSurveyObject();
        List<SurveyObject> siblings = this.getSiblingsInTree(surveyObject);
        SurveyObject newIndexItem = siblings.get(newIndexInTree);
        SchemaTreeModel.SchemaTreeNode newIndexNode = this.treeModel.getTreeNode(newIndexItem);
        int newIndexInModel = newIndexNode.getIndexInModel();
        if (surveyObject instanceof NodeDefinition) {
            NodeDefinition nodeDefn = (NodeDefinition)surveyObject;
            EntityDefinition parentEntity = nodeDefn.getParentEntityDefinition();
            if (parentEntity != null) {
                parentEntity.moveChildDefinition(nodeDefn, newIndexInModel);
            } else {
                EntityDefinition rootEntity = nodeDefn.getRootEntity();
                Schema schema = rootEntity.getSchema();
                schema.moveRootEntityDefinition(rootEntity, newIndexInModel);
            }
        } else {
            UITab tab = (UITab)surveyObject;
            UITabSet parent = tab.getParent();
            parent.moveTab(tab, newIndexInModel);
        }
        this.treeModel.moveSelectedNode(newIndexInTree);
        this.notifyChange("treeModel", "moveNodeUpDisabled", "moveNodeDownDisabled");
        this.dispatchSurveyChangedCommand();
    }

    protected void performRemoveSelectedTreeNode() {
        this.treeModel.removeSelectedNode();
        this.notifyChange("treeModel");
        this.resetEditingStatus();
        this.dispatchCurrentFormValidatedCommand(true);
    }

    protected void performRemoveNode(NodeDefinition nodeDefn) {
        EntityDefinition parentDefn = (EntityDefinition)nodeDefn.getParentDefinition();
        if (parentDefn == null) {
            UIOptions uiOpts = this.survey.getUIOptions();
            UITabSet tabSet = uiOpts.getAssignedRootTabSet((EntityDefinition)nodeDefn);
            uiOpts.removeTabSet(tabSet);
            Schema schema = nodeDefn.getSchema();
            String nodeName = nodeDefn.getName();
            schema.removeRootEntityDefinition(nodeName);
            this.selectedRootEntity = null;
            this.rootTabSet = null;
            this.notifyChange("selectedRootEntity", "rootEntities");
            this.refreshTreeModel();
        } else {
            if (this.treeModel != null) {
                this.treeModel.removeSelectedNode();
                this.notifyChange("treeModel");
            }
            parentDefn.removeChildDefinition(nodeDefn);
        }
        this.survey.refreshSurveyDependencies();
        this.resetEditingStatus();
        this.dispatchCurrentFormValidatedCommand(true);
        this.dispatchSurveyChangedCommand();
    }

    @GlobalCommand
    public void editedNodeChanged(@ContextParam(value=ContextType.VIEW) Component view, @BindingParam(value="parentEntity") EntityDefinition parentEntity, @BindingParam(value="node") SurveyObject editedNode, @BindingParam(value="newItem") Boolean newNode) {
        if (parentEntity == null && editedNode instanceof EntityDefinition) {
            EntityDefinition rootEntity = (EntityDefinition)editedNode;
            this.updateRootTabLabel(view, rootEntity);
        } else {
            if (newNode.booleanValue()) {
                this.selectedTreeNode.setDetached(false);
                BindUtils.postNotifyChange(null, null, (Object)this.selectedTreeNode, (String)"detached");
                this.newNode = false;
                this.notifyChange("newNode");
                this.selectTreeNode(editedNode);
            }
            this.notifyChange("editedNodePath");
            this.refreshSelectedTreeNode(view);
        }
    }

    private void updateRootTabLabel(Component view, EntityDefinition rootEntity) {
        String label;
        UITab mainTab = this.survey.getUIOptions().getMainTab(this.rootTabSet);
        if ("Change it to your main tab label".equals(mainTab.getLabel(this.currentLanguageCode)) && StringUtils.isNotBlank((CharSequence)(label = rootEntity.getLabel(NodeLabel.Type.INSTANCE, this.currentLanguageCode)))) {
            mainTab.setLabel(this.currentLanguageCode, label);
            this.updateTreeNodeLabel((SurveyObject)mainTab, label);
        }
    }

    protected void refreshSelectedTreeNode(Component view) {
        Treeitem selectedItem = this.nodesTree.getSelectedItem();
        SchemaTreeModel.SchemaTreeNode treeNode = (SchemaTreeModel.SchemaTreeNode)((Object)selectedItem.getValue());
        SchemaTreeModel.SchemaNodeData data = (SchemaTreeModel.SchemaNodeData)treeNode.getData();
        Menupopup popupMenu = this.getPopupMenu(data);
        selectedItem.setContext((Popup)popupMenu);
    }

    protected EntityDefinition createRootEntityDefinition() {
        EntityDefinition rootEntity = this.createEntityDefinition();
        rootEntity.setName("change_it_to_your_sampling_unit");
        this.survey.getSchema().addRootEntityDefinition(rootEntity);
        UIOptions uiOptions = this.survey.getUIOptions();
        this.rootTabSet = uiOptions.createRootTabSet(rootEntity);
        UITab mainTab = uiOptions.getMainTab(this.rootTabSet);
        mainTab.setLabel(this.currentLanguageCode, "Change it to your main tab label");
        this.notifyChange("rootEntities");
        return rootEntity;
    }

    protected EntityDefinition createEntityDefinition() {
        Schema schema = this.survey.getSchema();
        EntityDefinition newNode = schema.createEntityDefinition();
        return newNode;
    }

    public SchemaTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.buildTreeModel();
        }
        return this.treeModel;
    }

    protected void buildTreeModel() {
        CollectSurvey survey = this.getSurvey();
        if (survey != null) {
            SurveyObjectTreeModelCreator modelCreator;
            TreeViewType viewType = TreeViewType.valueOf(this.selectedTreeViewType.toUpperCase(Locale.ENGLISH));
            switch (viewType) {
                case ENTRY: {
                    modelCreator = new UITreeModelCreator(this.surveyManager, this.getLoggedUser(), this.selectedVersion, null, false, true, this.currentLanguageCode);
                    break;
                }
                default: {
                    modelCreator = new SchemaTreeModelCreator(this.surveyManager, this.getLoggedUser(), this.selectedVersion, null, false, true, this.currentLanguageCode);
                }
            }
            this.treeModel = modelCreator.createModel(this.selectedRootEntity);
        }
    }

    protected boolean isVersionSelected() {
        return this.survey.getVersions().isEmpty() || this.selectedVersion != null;
    }

    protected void refreshTreeModel() {
        Set<Object> openNodes = this.treeModel == null ? Collections.emptySet() : this.treeModel.getOpenSchemaNodes();
        this.buildTreeModel();
        if (this.treeModel != null) {
            this.treeModel.setOpenSchemaNodes(openNodes);
            this.treeModel.select(this.editedNode);
            this.treeModel.showSelectedNode();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)this.treeModel.getSelection())) {
                this.resetEditingStatus();
            }
        }
        this.notifyChange("treeModel");
    }

    public boolean isTab(SchemaTreeModel.SchemaNodeData data) {
        return data != null && data.getSurveyObject() instanceof UITab;
    }

    public boolean isMainTab(SchemaTreeModel.SchemaNodeData data) {
        if (this.isTab(data)) {
            UIOptions uiOptions = this.survey.getUIOptions();
            return uiOptions.isMainTab((UITab)data.getSurveyObject());
        }
        return false;
    }

    public boolean isEntity(SchemaTreeModel.SchemaNodeData data) {
        return data != null && data.getSurveyObject() instanceof EntityDefinition;
    }

    public boolean isSingleEntity(SchemaTreeModel.SchemaNodeData data) {
        return this.isEntity(data) && !((NodeDefinition)data.getSurveyObject()).isMultiple();
    }

    public boolean isTableEntity(SchemaTreeModel.SchemaNodeData data) {
        if (this.isEntity(data)) {
            EntityDefinition entityDefn;
            UIOptions uiOptions = this.survey.getUIOptions();
            UIOptions.Layout layout = uiOptions.getLayout(entityDefn = (EntityDefinition)data.getSurveyObject());
            return layout == UIOptions.Layout.TABLE;
        }
        return false;
    }

    protected List<SurveyObject> getSiblingsInTree(SurveyObject surveyObject) {
        List<SurveyObject> result = this.treeModel.getSiblingsAndSelf(surveyObject, true);
        return result;
    }

    @DependsOn(value={"selectedTreeNode"})
    public boolean isMoveNodeUpDisabled() {
        return this.isMoveNodeDisabled(true);
    }

    @DependsOn(value={"selectedTreeNode"})
    public boolean isMoveNodeDownDisabled() {
        return this.isMoveNodeDisabled(false);
    }

    protected boolean isMoveNodeDisabled(boolean up) {
        if (this.newNode || this.selectedTreeNode == null || this.isMainTab(this.selectedTreeNode)) {
            return true;
        }
        SurveyObject surveyObject = this.selectedTreeNode.getSurveyObject();
        List<SurveyObject> siblings = this.getSiblingsInTree(surveyObject);
        int index = siblings.indexOf(surveyObject);
        return this.isMoveItemDisabled(siblings, index, up);
    }

    protected boolean isMoveItemDisabled(List<?> siblings, int index, boolean up) {
        return up ? index <= 0 : index < 0 || index >= siblings.size() - 1;
    }

    @DependsOn(value={"newNode", "editedNode"})
    public String getNodeTypeHeaderLabel() {
        if (this.editedNode != null) {
            if (this.editedNode instanceof NodeDefinition) {
                return NodeType.getHeaderLabel((NodeDefinition)this.editedNode, this.editedNodeParentEntity == null, this.newNode);
            }
            return Labels.getLabel((String)"survey.schema.node.layout.tab");
        }
        return null;
    }

    @DependsOn(value={"editedNode"})
    public String getNodeType() {
        if (this.editedNode != null && this.editedNode instanceof NodeDefinition) {
            NodeType type = NodeType.valueOf((NodeDefinition)this.editedNode);
            return type.name();
        }
        return null;
    }

    @DependsOn(value={"editedNode"})
    public String getAttributeType() {
        if (this.editedNode != null && this.editedNode instanceof AttributeDefinition) {
            AttributeType type = AttributeType.valueOf((AttributeDefinition)this.editedNode);
            return type.name();
        }
        return null;
    }

    @DependsOn(value={"editedNode"})
    public String getAttributeTypeLabel() {
        String type = this.getAttributeType();
        return this.getAttributeTypeLabel(type);
    }

    public String getAttributeTypeLabel(String typeValue) {
        if (StringUtils.isNotBlank((CharSequence)typeValue)) {
            AttributeType type = AttributeType.valueOf(typeValue);
            return type.getLabel();
        }
        return null;
    }

    public List<String> getAttributeTypeValues() {
        AttributeType[] values;
        if (this.survey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeType type : values = AttributeType.values()) {
            if (!this.isSupported(type)) continue;
            result.add(type.name());
        }
        return result;
    }

    private boolean isSupported(AttributeType type) {
        switch (this.survey.getTarget()) {
            case COLLECT_EARTH: {
                return SUPPORTED_COLLECT_EARTH_ATTRIBUTE_TYPES.contains((Object)type);
            }
        }
        return true;
    }

    public String getAttributeTypeLabelFromDefinition(AttributeDefinition attrDefn) {
        if (attrDefn != null) {
            AttributeType type = AttributeType.valueOf(attrDefn);
            return type.getLabel();
        }
        return null;
    }

    public String getAttributeInstanceLabel(AttributeDefinition attrDefn) {
        return attrDefn.getLabel(NodeLabel.Type.INSTANCE, this.currentLanguageCode);
    }

    public static String getIcon(SurveyObject surveyObject) {
        boolean key = surveyObject instanceof KeyAttributeDefinition && ((KeyAttributeDefinition)surveyObject).isKey();
        boolean calculated = surveyObject instanceof AttributeDefinition && ((AttributeDefinition)surveyObject).isCalculated();
        return SchemaVM.getIcon(surveyObject, key, calculated);
    }

    public static String getIcon(SurveyObject surveyObject, boolean key, boolean calculated) {
        String imagesRootPath = NODE_TYPES_IMAGES_PATH;
        if (surveyObject instanceof UITab) {
            return imagesRootPath + "tab-small.png";
        }
        if (surveyObject instanceof EntityDefinition) {
            return SchemaVM.getEntityIcon((EntityDefinition)surveyObject);
        }
        if (key) {
            return imagesRootPath + "key-small.png";
        }
        if (calculated) {
            return imagesRootPath + "calculated-small.png";
        }
        return SchemaVM.getAttributeIcon((AttributeDefinition)surveyObject);
    }

    protected static String getEntityIcon(EntityDefinition entityDefn) {
        String icon;
        CollectSurvey survey = (CollectSurvey)entityDefn.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        UIOptions.Layout layout = uiOptions.getLayout(entityDefn);
        if (entityDefn.isMultiple()) {
            switch (layout) {
                case TABLE: {
                    icon = "table-small.png";
                    break;
                }
                default: {
                    icon = "form-small.png";
                    break;
                }
            }
        } else {
            icon = "grouping-small.png";
        }
        return NODE_TYPES_IMAGES_PATH + icon;
    }

    public String getAttributeIcon(String attributeTypeStr) {
        return SchemaVM.getAttributeIcon(attributeTypeStr, null);
    }

    public static String getNodeTooltiptext(SurveyObject surveyObject) {
        if (surveyObject instanceof AttributeDefinition) {
            AttributeDefinition attrDef = (AttributeDefinition)surveyObject;
            AttributeType attributeType = AttributeType.valueOf(attrDef);
            String attrTypeLabel = StringUtils.capitalize((String)StringUtils.lowerCase((String)attributeType.name()));
            if (attributeType == AttributeType.FILE) {
                CollectAnnotations.FileType fileType = ((CollectSurvey)attrDef.getSurvey()).getAnnotations().getFileType((FileAttributeDefinition)attrDef);
                return attrTypeLabel + " (" + StringUtils.lowerCase((String)fileType.name()) + ")";
            }
            return attrTypeLabel;
        }
        return null;
    }

    private static String getAttributeIcon(AttributeDefinition attrDef) {
        return SchemaVM.getAttributeIcon(AttributeType.valueOf(attrDef).name(), attrDef);
    }

    private static String getAttributeIcon(String attributeTypeStr, AttributeDefinition attrDef) {
        AttributeType attributeType = AttributeType.valueOf(attributeTypeStr);
        String filePrefix = NODE_TYPES_IMAGES_PATH + attributeType.name().toLowerCase(Locale.ENGLISH);
        String fileSuffix = "-small.png";
        if (attributeType == AttributeType.FILE && attrDef != null) {
            CollectAnnotations.FileType fileType = ((CollectSurvey)attrDef.getSurvey()).getAnnotations().getFileType((FileAttributeDefinition)attrDef);
            return filePrefix + "-" + fileType.name().toLowerCase(Locale.ENGLISH) + fileSuffix;
        }
        return filePrefix + fileSuffix;
    }

    @DependsOn(value={"editedNode"})
    public String getEditedNodePath() {
        if (this.editedNode == null) {
            return null;
        }
        if (this.editedNode instanceof NodeDefinition) {
            if (this.newNode) {
                return this.editedNodeParentEntity.getPath() + "/" + PATH_NULL_VALUES_REPLACE;
            }
            return ((NodeDefinition)this.editedNode).getPath();
        }
        UITab tab = (UITab)this.editedNode;
        return tab.getPath(this.currentLanguageCode, PATH_NULL_VALUES_REPLACE);
    }

    @Command
    @NotifyChange(value={"treeModel", "selectedTab"})
    public void addTab(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (TreeViewType.DATA.name().equalsIgnoreCase(this.selectedTreeViewType)) {
            MessageUtil.showWarning("survey.schema.unsupported_operation_in_data_view", new Object[0]);
        } else {
            this.treeModel.deselect();
            this.addTabInternal(binder, this.rootTabSet);
        }
    }

    @Command
    @NotifyChange(value={"treeModel", "selectedTab"})
    public void addChildTab(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.checkCanAddChildTab()) {
            UITab parentTab = this.getSelectedNodeParentTab();
            this.addTabInternal(binder, (UITabSet)parentTab);
        }
    }

    private boolean checkCanAddChildTab() {
        if (TreeViewType.DATA.name().equalsIgnoreCase(this.selectedTreeViewType)) {
            MessageUtil.showWarning("survey.schema.unsupported_operation_in_data_view", new Object[0]);
            return false;
        }
        SurveyObject selectedSurveyObject = this.selectedTreeNode.getSurveyObject();
        if (selectedSurveyObject instanceof UITab) {
            UITab parentTab = this.getSelectedNodeParentTab();
            UIOptions uiOptions = this.survey.getUIOptions();
            if (parentTab != null && uiOptions.isAssociatedWithMultipleEntityForm(parentTab)) {
                MessageUtil.showWarning("survey.schema.cannot_add_nested_tab.form_entity_assosicated", new Object[0]);
                return false;
            }
        }
        return true;
    }

    protected void addTabInternal(final Binder binder, final UITabSet parentTabSet) {
        if (this.rootTabSet != null) {
            this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

                @Override
                public void onOk(boolean confirmed) {
                    CollectSurvey survey = SchemaVM.this.getSurvey();
                    UIOptions uiOptions = survey.getUIOptions();
                    UITab tab = uiOptions.createTab();
                    String label = Labels.getLabel((String)"survey.schema.node.layout.default_tab_label");
                    tab.setLabel(SchemaVM.this.currentLanguageCode, label);
                    parentTabSet.addTab(tab);
                    SchemaVM.this.editNode(binder, false, null, (SurveyObject)tab);
                    SchemaVM.this.afterNewNodeCreated((SurveyObject)tab, false);
                }
            });
        }
    }

    @Command
    public void removeTab() {
        UITab tab = (UITab)this.selectedTreeNode.getSurveyObject();
        if (this.checkCanRemoveTab(tab)) {
            this.removeTab(tab);
        }
    }

    private boolean checkCanRemoveTab(UITab tab) {
        if (this.isCollectEarthSurvey()) {
            List nodes = this.survey.getUIOptions().getNodesPerTab(tab, true);
            for (NodeDefinition nodeDef : nodes) {
                if (!this.isCollectEarthRequiredField(nodeDef)) continue;
                MessageUtil.showWarning("survey.schema.cannot_remove_tab_containing_ce_required_field", tab.getLabel(this.currentLanguageCode), nodeDef.getName());
                return false;
            }
        }
        return true;
    }

    private UITab getSelectedNodeParentTab() {
        UITab parentTab;
        SurveyObject selectedSurveyObject = this.selectedTreeNode.getSurveyObject();
        if (selectedSurveyObject instanceof UITab) {
            parentTab = (UITab)selectedSurveyObject;
        } else {
            UIOptions uiOptions = this.survey.getUIOptions();
            parentTab = uiOptions.getAssignedTab((NodeDefinition)selectedSurveyObject);
        }
        return parentTab;
    }

    private void removeTab(final UITab tab) {
        String confirmMessageKey = null;
        if (tab.getTabs().isEmpty()) {
            CollectSurvey survey = this.getSurvey();
            UIOptions uiOpts = survey.getUIOptions();
            List nodesPerTab = uiOpts.getNodesPerTab(tab, false);
            if (!nodesPerTab.isEmpty()) {
                confirmMessageKey = "survey.layout.tab.remove.confirm.associated_nodes_present";
            }
        } else {
            confirmMessageKey = "survey.layout.tab.remove.confirm.nested_tabs_present";
        }
        if (confirmMessageKey != null) {
            MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    SchemaVM.this.performRemoveTab(tab);
                }
            }, confirmMessageKey);
            params.setOkLabelKey("global.delete_item");
            MessageUtil.showConfirm(params);
        } else {
            this.performRemoveTab(tab);
        }
    }

    protected void performRemoveTab(UITab tab) {
        UIOptions uiOptions = tab.getUIOptions();
        List nodesPerTab = uiOptions.getNodesPerTab(tab, false);
        for (NodeDefinition nodeDefn : nodesPerTab) {
            EntityDefinition parentDefn = nodeDefn.getParentEntityDefinition();
            parentDefn.removeChildDefinition(nodeDefn);
        }
        this.performRemoveSelectedTreeNode();
        UITabSet parent = tab.getParent();
        parent.removeTab(tab);
        this.refreshTreeModel();
        this.dispatchSurveyChangedCommand();
    }

    @Command
    public void updateTabLabel(@BindingParam(value="tab") UITab tab, @BindingParam(value="label") String label) {
        if (this.validateTabLabel(label)) {
            tab.setLabel(this.currentLanguageCode, label.trim());
        }
    }

    protected boolean validateTabLabel(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            MessageUtil.showWarning("survey.layout.tab.label.error.required", new Object[0]);
            return false;
        }
        return true;
    }

    @Command
    public void treeViewTypeSelected(@BindingParam(value="type") String type) {
        this.selectedTreeViewType = type;
        this.resetEditingStatus();
        this.refreshTreeModel();
    }

    public Menupopup getPopupMenu(SchemaTreeModel.SchemaNodeData data) {
        if (data == null) {
            return null;
        }
        Menupopup popupMenu = data.isDetached() ? this.detachedNodePopup : (this.isTab(data) ? (this.isMainTab(data) ? this.mainTabPopup : this.tabPopup) : (this.isEntity(data) ? (this.isSingleEntity(data) ? this.singleEntityPopup : (this.isTableEntity(data) ? this.tableEntityPopup : this.formEntityPopup)) : this.attributePopup));
        return popupMenu;
    }

    @Command
    public void openMoveNodePopup() {
        SchemaTreeModel.SchemaNodeData selectedTreeNode = this.getSelectedTreeNode();
        if (selectedTreeNode == null) {
            return;
        }
        SurveyObject selectedItem = selectedTreeNode.getSurveyObject();
        if (selectedItem instanceof NodeDefinition) {
            NodeDefinition selectedNode = (NodeDefinition)selectedItem;
            boolean changeParentNodeAllowed = this.checkChangeParentNodeAllowed(selectedNode);
            if (changeParentNodeAllowed) {
                this.openSelectParentNodePopupForReparent(selectedNode);
            }
        } else {
            return;
        }
    }

    @Command
    public void openDuplicateNodePopup() {
        if (!this.checkCanLeaveForm()) {
            return;
        }
        SchemaTreeModel.SchemaNodeData selectedTreeNode = this.getSelectedTreeNode();
        if (selectedTreeNode == null) {
            return;
        }
        SurveyObject selectedItem = selectedTreeNode.getSurveyObject();
        if (selectedItem instanceof NodeDefinition) {
            this.openSelectParentNodePopupForDuplicate((NodeDefinition)selectedItem);
        }
    }

    @Command
    public void openNodeConversionPopup() {
        if (!this.checkCanLeaveForm()) {
            return;
        }
        SurveyObject selectedItem = this.selectedTreeNode.getSurveyObject();
        if (selectedItem instanceof AttributeDefinition) {
            AttributeDefinition selectedNode = (AttributeDefinition)selectedItem;
            if (this.isDefinitionInPublishedSurvey((NodeDefinition)selectedNode) && !selectedNode.isCalculated()) {
                MessageUtil.showWarning("survey.schema.cannot_convert_published_survey_node", new Object[0]);
                return;
            }
            AttributeConversionVM.openPopup(selectedNode);
        }
    }

    private boolean isDefinitionInPublishedSurvey(NodeDefinition nodeDef) {
        CollectSurvey publishedSurvey;
        return this.isSurveyRelatedToPublishedSurvey() && (publishedSurvey = this.surveyManager.getById(this.survey.getPublishedId().intValue())).getSchema().containsDefinitionWithId(nodeDef.getId());
    }

    private boolean checkChangeParentNodeAllowed(NodeDefinition selectedNode) {
        UIOptions uiOptions = this.survey.getUIOptions();
        if (this.survey.isPublished()) {
            List assignableTabs = uiOptions.getAssignableTabs(this.editedNodeParentEntity, selectedNode);
            if (assignableTabs.size() > 0) {
                return true;
            }
            MessageUtil.showWarning("survey.schema.move_node.published_survey.no_other_tabs_allowed", new Object[0]);
            return false;
        }
        return true;
    }

    private void openSelectParentNodePopupForReparent(final NodeDefinition selectedItem) {
        UIOptions uiOptions = this.survey.getUIOptions();
        final HashSet<UITab> assignableTabs = new HashSet<UITab>(uiOptions.getAssignableTabs(this.editedNodeParentEntity, selectedItem));
        final EntityDefinition selectedItemParentDefn = selectedItem.getParentEntityDefinition();
        UITab inheritedTab = uiOptions.getAssignedTab((NodeDefinition)selectedItemParentDefn);
        assignableTabs.add(inheritedTab);
        Predicate<SurveyObject> includedNodePredicate = new Predicate<SurveyObject>(){

            @Override
            public boolean evaluate(SurveyObject item) {
                if (item instanceof UITab) {
                    return true;
                }
                if (item instanceof NodeDefinition) {
                    if (item instanceof EntityDefinition) {
                        EntityDefinition entityItemDef = (EntityDefinition)item;
                        if (entityItemDef.isVirtual()) {
                            return false;
                        }
                        return !(selectedItem instanceof EntityDefinition) || !entityItemDef.isDescendantOf((EntityDefinition)selectedItem);
                    }
                    return false;
                }
                return false;
            }
        };
        Predicate<SurveyObject> disabledPredicate = new Predicate<SurveyObject>(){

            @Override
            public boolean evaluate(SurveyObject item) {
                if (item instanceof UITab) {
                    return SchemaVM.this.survey.isPublished() && !assignableTabs.contains(item);
                }
                if (item instanceof NodeDefinition) {
                    NodeDefinition itemNodeDef = (NodeDefinition)item;
                    if (itemNodeDef.equals((Object)selectedItemParentDefn)) {
                        return false;
                    }
                    if (selectedItem instanceof EntityDefinition && itemNodeDef.isDescendantOf((EntityDefinition)selectedItem)) {
                        return true;
                    }
                    return SchemaVM.this.survey.isPublished() || !(itemNodeDef instanceof EntityDefinition) || itemNodeDef.equals((Object)selectedItem);
                }
                return true;
            }
        };
        String nodeName = this.editedNode instanceof NodeDefinition ? ((NodeDefinition)this.editedNode).getName() : "";
        UITab assignedTab = this.survey.getUIOptions().getAssignedTab((NodeDefinition)this.editedNode);
        String assignedTabLabel = assignedTab.getLabel(this.currentLanguageCode);
        String title = Labels.getLabel((String)"survey.schema.move_node_popup_title", (Object[])new String[]{this.getNodeTypeHeaderLabel(), nodeName, assignedTabLabel});
        SchemaTreeModel.SchemaTreeNode treeNode = this.treeModel.getTreeNode((SurveyObject)selectedItem);
        TreeNode parentTreeNode = treeNode.getParent();
        SurveyObject parentItem = ((SchemaTreeModel.SchemaNodeData)parentTreeNode.getData()).getSurveyObject();
        final Window popup = SchemaObjectSelectorPopUpVM.openPopup(title, false, this.selectedRootEntity, null, includedNodePredicate, false, true, disabledPredicate, null, parentItem, false);
        popup.addEventListener("onNodeSelected", (EventListener)new EventListener<SchemaObjectSelectorPopUpVM.NodeSelectedEvent>(){

            public void onEvent(SchemaObjectSelectorPopUpVM.NodeSelectedEvent event) throws Exception {
                SurveyObject selectedParent = event.getSelectedItem();
                SchemaVM.this.changeEditedNodeParent(selectedParent, false);
                SchemaVM.this.refreshNodeForm();
                BaseVM.closePopUp(popup);
            }
        });
    }

    @Command
    public void openSelectNodeFromAnotherSurveyPopUp() {
        SchemaTreeModel.SchemaNodeData selectedTreeNode = this.getSelectedTreeNode();
        if (selectedTreeNode == null) {
            return;
        }
        final SurveyObject clonedItemParent = selectedTreeNode.getSurveyObject();
        String clonedItemParentLabel = clonedItemParent instanceof NodeDefinition ? ((NodeDefinition)clonedItemParent).getName() : (clonedItemParent instanceof UITab ? ((UITab)clonedItemParent).getLabel(this.currentLanguageCode) : "");
        String title = Labels.getLabel((String)"survey.schema.add_node_from_another_survey.popup_title", (String)clonedItemParentLabel);
        Predicate<SurveyObject> includedNodePredicate = null;
        Predicate<SurveyObject> disabledPredicate = null;
        final Window popup = SchemaObjectSelectorPopUpVM.openPopup(title, true, null, null, includedNodePredicate, false, true, disabledPredicate, null, null, false);
        popup.addEventListener("onNodeSelected", (EventListener)new EventListener<SchemaObjectSelectorPopUpVM.NodeSelectedEvent>(){

            public void onEvent(SchemaObjectSelectorPopUpVM.NodeSelectedEvent event) throws Exception {
                NodeDefinition selectedNode = (NodeDefinition)event.getSelectedItem();
                SchemaVM.this.duplicateNodeAndSelectIt(selectedNode, clonedItemParent);
                BaseVM.closePopUp(popup);
            }
        });
    }

    private void openSelectParentNodePopupForDuplicate(final NodeDefinition node) {
        Predicate<SurveyObject> includedNodePredicate = new Predicate<SurveyObject>(){

            @Override
            public boolean evaluate(SurveyObject item) {
                return item instanceof UITab || item instanceof EntityDefinition;
            }
        };
        Predicate<SurveyObject> disabledPredicate = new Predicate<SurveyObject>(){

            @Override
            public boolean evaluate(SurveyObject item) {
                return !(item instanceof UITab) && !(item instanceof EntityDefinition);
            }
        };
        String nodeName = node.getName();
        UITab assignedTab = this.survey.getUIOptions().getAssignedTab(node);
        String assignedTabLabel = assignedTab.getLabel(this.currentLanguageCode);
        String title = Labels.getLabel((String)"survey.schema.duplicate_node_popup_title", (Object[])new String[]{this.getNodeTypeHeaderLabel(), nodeName, assignedTabLabel});
        SchemaTreeModel.SchemaTreeNode treeNode = this.treeModel.getTreeNode((SurveyObject)node);
        TreeNode parentTreeNode = treeNode.getParent();
        SurveyObject parentItem = ((SchemaTreeModel.SchemaNodeData)parentTreeNode.getData()).getSurveyObject();
        final Window popup = SchemaObjectSelectorPopUpVM.openPopup(title, false, this.selectedRootEntity, null, includedNodePredicate, false, true, disabledPredicate, null, parentItem, false);
        popup.addEventListener("onNodeSelected", (EventListener)new EventListener<SchemaObjectSelectorPopUpVM.NodeSelectedEvent>(){

            public void onEvent(SchemaObjectSelectorPopUpVM.NodeSelectedEvent event) throws Exception {
                SurveyObject selectedParent = event.getSelectedItem();
                SchemaVM.this.duplicateNodeAndSelectIt(node, selectedParent);
                BaseVM.closePopUp(popup);
            }
        });
    }

    private void duplicateNodeAndSelectIt(NodeDefinition node, SurveyObject parent) {
        if (node instanceof EntityDefinition) {
            final AtomicBoolean codeListsUpdated = new AtomicBoolean(false);
            ((EntityDefinition)node).traverse(new NodeDefinitionVisitor(){

                public void visit(NodeDefinition descendant) {
                    if (descendant instanceof CodeAttributeDefinition && SchemaVM.this.addMissingCodeList((CodeAttributeDefinition)descendant)) {
                        codeListsUpdated.set(true);
                    }
                }
            });
            if (codeListsUpdated.get()) {
                CodeListsVM.dispatchCodeListsUpdatedCommand();
            }
        } else if (node instanceof CodeAttributeDefinition) {
            this.addMissingCodeList((CodeAttributeDefinition)node);
        }
        NodeDefinition clone = this.survey.getSchema().cloneDefinition(node, new String[0]);
        EntityDefinition parentEntity = this.determineRelatedEntity(parent);
        clone.setName(this.generateDuplicateNodeName(clone, parentEntity));
        this.editedNode = clone;
        this.changeEditedNodeParent(parent, true);
        this.editNode(false, parentEntity, this.editedNode);
        SurveyEditVM.dispatchSurveySaveCommand();
    }

    private boolean addMissingCodeList(CodeAttributeDefinition node) {
        CodeList sourceList = node.getList();
        if (this.survey.hasCodeList(sourceList.getName())) {
            return false;
        }
        this.codeListManager.copyCodeList(sourceList, this.survey);
        return true;
    }

    private String generateDuplicateNodeName(NodeDefinition nodeToBeDuplicate, EntityDefinition parent) {
        int currentProgressiveNum;
        String prefix;
        String name = nodeToBeDuplicate.getName();
        Matcher matcher = CLONED_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            prefix = matcher.group(1);
            currentProgressiveNum = Integer.parseInt(matcher.group(2));
        } else {
            prefix = name;
            currentProgressiveNum = 0;
        }
        String newName = prefix + (currentProgressiveNum == 0 ? "" : Integer.valueOf(currentProgressiveNum));
        while (parent.containsChildDefinition(newName)) {
            newName = prefix + ++currentProgressiveNum;
        }
        return newName;
    }

    private void changeEditedNodeParent(SurveyObject newParent, boolean forceReassignment) {
        EntityDefinition newParentEntityDef = this.determineRelatedEntity(newParent);
        NodeDefinition editedNodeDef = (NodeDefinition)this.editedNode;
        if (forceReassignment || editedNodeDef.getParentDefinition() != newParentEntityDef) {
            this.changeEditedNodeParentEntity(newParentEntityDef);
        }
        if (newParent instanceof UITab) {
            this.associateNodeToTab(editedNodeDef, (UITab)newParent);
        }
        this.dispatchSurveyChangedCommand();
    }

    private EntityDefinition determineRelatedEntity(SurveyObject obj) {
        if (obj instanceof UITab) {
            UITab tab = (UITab)obj;
            EntityDefinition newParentEntityDef = tab.getUIOptions().getParentEntityForAssignedNodes(tab);
            return newParentEntityDef;
        }
        return (EntityDefinition)obj;
    }

    private EntityDefinition getNearestEntity(SurveyObject surveyObject) {
        if (surveyObject instanceof EntityDefinition) {
            return (EntityDefinition)surveyObject;
        }
        EntityDefinition parentEntity = this.treeModel.getNearestParentEntityDefinition(surveyObject);
        return parentEntity;
    }

    private void changeEditedNodeParentEntity(EntityDefinition newParentEntity) {
        NodeDefinition node = (NodeDefinition)this.editedNode;
        Schema schema = this.survey.getSchema();
        schema.changeParentEntity(node, newParentEntity);
        UIOptions uiOptions = this.survey.getUIOptions();
        uiOptions.removeTabAssociation(node);
        if (node instanceof AttributeDefinition) {
            this.survey.getAnnotations().setMeasurementAttribute((AttributeDefinition)node, false);
        }
        this.refreshTreeModel();
        this.editedNodeParentEntity = newParentEntity;
        this.selectTreeNode(this.editedNode);
        this.treeModel.showSelectedNode();
        this.notifyChange("selectedTreeNode", "editedNode");
    }

    private void associateNodeToTab(NodeDefinition node, UITab tab) {
        UIOptions uiOptions = this.survey.getUIOptions();
        uiOptions.assignToTab(node, tab);
        this.refreshTreeModel();
        this.selectTreeNode((SurveyObject)node);
        this.treeModel.showSelectedNode();
        this.notifyChange("selectedTreeNode", "editedNode");
    }

    public SchemaTreeModel.SchemaNodeData getSelectedTreeNode() {
        return this.selectedTreeNode;
    }

    public SurveyObject getEditedNode() {
        return this.editedNode;
    }

    @DependsOn(value={"editedNode"})
    public boolean isEditingNode() {
        return this.editedNode != null;
    }

    public boolean isNewNode() {
        return this.newNode;
    }

    public EntityDefinition getSelectedRootEntity() {
        return this.selectedRootEntity;
    }

    public ModelVersion getSelectedVersion() {
        return this.selectedVersion;
    }

    @DependsOn(value={"selectedRootEntity"})
    public boolean isRootEntitySelected() {
        return this.selectedRootEntity != null;
    }

    public String getSelectedTreeViewType() {
        return this.selectedTreeViewType;
    }

    public String[] getTreeViewTypes() {
        TreeViewType[] values = TreeViewType.values();
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            TreeViewType type = values[i];
            result[i] = type.name().toLowerCase(Locale.ENGLISH);
        }
        return result;
    }

    public String getTreeViewTypeLabel(String type) {
        return Labels.getLabel((String)("survey.schema.tree.view_type." + type));
    }

    public static enum TreeViewType {
        ENTRY,
        DATA;

    }
}

