/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel.referencedata;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.openforis.collect.designer.util.PopUpUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Window;

public class ReferenceDataImportErrorsPopUpVM
extends BaseVM {
    private static final String ERRORS_PARAM = "errors";
    private static final String TITLE_PARAM = "title";
    private static final String MESSAGE_KEY_DUPLICATE_VALUE = "survey.reference_data.import_error.type.duplicate_value.message";
    private List<ParsingError> errors;
    private String title;

    public static Window showPopUp(List<ParsingError> errors, String title) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ERRORS_PARAM, errors);
        args.put(TITLE_PARAM, title);
        return PopUpUtil.openPopUp(Resources.Component.REFERENCE_DATA_IMPORT_ERRORS_POPUP.getLocation(), true, args);
    }

    @Init
    public void init(@ExecutionArgParam(value="errors") List<ParsingError> errors, @ExecutionArgParam(value="title") String title) {
        this.errors = errors;
        this.title = title;
    }

    public List<ParsingError> getErrors() {
        return new ListModelList(this.errors);
    }

    public String getTitle() {
        return this.title;
    }

    public String getErrorTypeLabel(ParsingError error) {
        return Labels.getLabel((String)String.format("survey.reference_data.import_error.type.%s", error.getErrorType().name().toLowerCase(Locale.ENGLISH)));
    }

    public String getErrorMessageLabel(ParsingError error) {
        String label = Labels.getLabel((String)error.getMessage(), (Object[])error.getMessageArgs());
        if (label == null && error.getErrorType() == ParsingError.ErrorType.DUPLICATE_VALUE) {
            label = Labels.getLabel((String)MESSAGE_KEY_DUPLICATE_VALUE, (Object[])error.getMessageArgs());
        }
        return label == null ? error.getMessage() : label;
    }
}

