/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.concurrency.Task;

public abstract class ReferenceDataImportTask<E extends ParsingError>
extends Task {
    private Map<Long, List<E>> rowToErrors;
    private List<Long> processedRows = new ArrayList<Long>();

    public ReferenceDataImportTask() {
        this.rowToErrors = new LinkedHashMap<Long, List<E>>();
    }

    public void addParsingError(long row, E error) {
        List<E> list = this.rowToErrors.get(row);
        if (list == null) {
            list = new ArrayList();
            this.rowToErrors.put(row, list);
        }
        if (!list.contains(error)) {
            list.add(error);
        }
    }

    public void addParsingError(E error) {
        long row = error.getRow();
        if (row <= 0L) {
            throw new IllegalArgumentException("Error row must be greater than zero");
        }
        this.addParsingError(row, error);
    }

    public void addProcessedRow(long rowNumber) {
        if (!this.processedRows.contains(rowNumber)) {
            this.incrementProcessedItems();
            this.processedRows.add(rowNumber);
        }
    }

    public List<E> getErrors() {
        Collection<List<E>> errorsPerRows = this.rowToErrors.values();
        ArrayList<E> result = new ArrayList<E>();
        for (List<E> errros : errorsPerRows) {
            result.addAll(errros);
        }
        return result;
    }

    public boolean hasErrors() {
        return this.rowToErrors != null && !this.rowToErrors.isEmpty();
    }

    public List<Long> getProcessedRows() {
        return this.processedRows;
    }

    public boolean isRowProcessed(long rowNumber) {
        return this.processedRows.contains(rowNumber);
    }

    public boolean isRowInError(long rowNumber) {
        return this.rowToErrors.containsKey(rowNumber);
    }

    public Collection<Long> getRowsInError() {
        return this.rowToErrors.keySet();
    }

    public List<Long> getSkippedRows() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long i = 1L; i <= this.getTotalItems(); ++i) {
            if (this.processedRows.contains(i)) continue;
            result.add(i);
        }
        return CollectionUtils.unmodifiableList(result);
    }
}

