/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.io.File;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreator;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreatorImpl;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CollectEarthSurveyExportJob
extends Job {
    protected static final ServiceLoader<CollectEarthProjectFileCreator> COLLECT_EARTH_PROJECT_FILE_CREATOR_LOADER = ServiceLoader.load(CollectEarthProjectFileCreator.class);
    private static final CollectEarthProjectFileCreator COLLECT_EARTH_PROJECT_FILE_CREATOR;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CodeListManager codeListManager;
    private CollectSurvey survey;
    private String languageCode;
    private File outputFile;

    protected void buildTasks() throws Throwable {
        this.addTask((Worker)new ExportTask());
    }

    public CollectSurvey getSurvey() {
        return this.survey;
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    static {
        Iterator<CollectEarthProjectFileCreator> it = COLLECT_EARTH_PROJECT_FILE_CREATOR_LOADER.iterator();
        COLLECT_EARTH_PROJECT_FILE_CREATOR = it.hasNext() ? it.next() : null;
    }

    private class ExportTask
    extends Task {
        private ExportTask() {
        }

        protected void execute() throws Throwable {
            CollectEarthProjectFileCreatorImpl creatorImpl = (CollectEarthProjectFileCreatorImpl)COLLECT_EARTH_PROJECT_FILE_CREATOR;
            creatorImpl.setCodeListManager(CollectEarthSurveyExportJob.this.codeListManager);
            creatorImpl.setSurveyManager(CollectEarthSurveyExportJob.this.surveyManager);
            CollectEarthSurveyExportJob.this.outputFile = COLLECT_EARTH_PROJECT_FILE_CREATOR.create(CollectEarthSurveyExportJob.this.survey, CollectEarthSurveyExportJob.this.languageCode);
        }
    }
}

