/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.io.data.DataImportSummary;
import org.openforis.collect.io.data.DataRestoreBaseJob;
import org.openforis.collect.io.data.DataRestoreJob;
import org.openforis.collect.io.data.DataRestoreSummaryJob;
import org.openforis.collect.io.data.TransactionalDataRestoreJob;
import org.openforis.collect.io.data.proxy.DataRestoreJobProxy;
import org.openforis.collect.io.data.proxy.DataRestoreSummaryJobProxy;
import org.openforis.collect.io.exception.DataImportExeption;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.remoting.service.dataimport.DataImportSummaryProxy;
import org.openforis.collect.web.session.SessionState;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.proxy.JobProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;

public class DataImportService {
    private static final Logger LOG = LogManager.getLogger(DataImportService.class);
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private CollectJobManager jobManager;
    @Autowired
    private SurveyManager surveyManager;
    private File packagedFile;
    private DataRestoreSummaryJob summaryJob;
    private DataRestoreJob dataRestoreJob;

    @Secured(value={"ROLE_CLEANSING"})
    public JobProxy startSummaryCreation(String filePath, String selectedSurveyUri, boolean overwriteAll, boolean fullSummary) throws DataImportExeption {
        if (this.summaryJob == null || !this.summaryJob.isRunning()) {
            LOG.info("Starting data import summary creation");
            this.packagedFile = new File(filePath);
            LOG.info("Using file: " + this.packagedFile.getAbsolutePath());
            CollectSurvey survey = this.surveyManager.getByUri(selectedSurveyUri);
            DataRestoreSummaryJob job = (DataRestoreSummaryJob)this.jobManager.createJob(DataRestoreSummaryJob.class);
            job.setFullSummary(fullSummary);
            job.setFile(this.packagedFile);
            job.setPublishedSurvey(survey);
            job.setCloseRecordProviderOnComplete(false);
            this.resetJobs();
            this.summaryJob = job;
            this.jobManager.start((Job)job);
        } else {
            LOG.warn("Summary creation job already running");
        }
        return this.getCurrentJob();
    }

    @Secured(value={"ROLE_CLEANSING"})
    public JobProxy startImport(List<Integer> entryIdsToImport, boolean validateRecords, boolean processInTransaction) throws Exception {
        if (this.dataRestoreJob == null || !this.dataRestoreJob.isRunning()) {
            LOG.info("Starting data restore");
            DataRestoreJob job = processInTransaction ? (DataRestoreJob)this.jobManager.createJob("transactionalDataRestoreJob", TransactionalDataRestoreJob.class) : (DataRestoreJob)this.jobManager.createJob("dataRestoreJob", DataRestoreJob.class);
            job.setFile(this.packagedFile);
            job.setValidateRecords(validateRecords);
            job.setRecordProvider(this.summaryJob.getRecordProvider());
            job.setPackagedSurvey(this.summaryJob.getPackagedSurvey());
            job.setPublishedSurvey(this.summaryJob.getPublishedSurvey());
            job.setEntryIdsToImport(entryIdsToImport);
            job.setRecordFilesToBeDeleted(this.summaryJob.getSummary().getConflictingRecordFiles(entryIdsToImport));
            job.setRestoreUploadedFiles(true);
            job.setValidateRecords(validateRecords);
            this.resetJobs();
            this.dataRestoreJob = job;
            this.jobManager.start((Job)job);
        } else {
            LOG.warn("Data restore job already running");
        }
        return this.getCurrentJob();
    }

    @Secured(value={"ROLE_CLEANSING"})
    public JobProxy getCurrentJob() {
        JobProxy proxy = null;
        if (this.summaryJob != null) {
            proxy = new DataRestoreSummaryJobProxy((DataRestoreBaseJob)this.summaryJob);
        } else if (this.dataRestoreJob != null) {
            proxy = new DataRestoreJobProxy(this.dataRestoreJob);
        }
        return proxy;
    }

    @Secured(value={"ROLE_CLEANSING"})
    public DataImportSummaryProxy getSummary() {
        if (this.summaryJob != null) {
            DataImportSummary summary = this.summaryJob.getSummary();
            SessionState sessionState = this.sessionManager.getSessionState();
            Locale locale = sessionState.getLocale();
            DataImportSummaryProxy proxy = new DataImportSummaryProxy(summary, locale);
            return proxy;
        }
        return null;
    }

    @Secured(value={"ROLE_CLEANSING"})
    public void cancel() {
        if (this.summaryJob != null) {
            this.summaryJob.abort();
        } else if (this.dataRestoreJob != null) {
            this.dataRestoreJob.abort();
        }
    }

    private void resetJobs() {
        this.summaryJob = null;
        this.dataRestoreJob = null;
    }
}

