/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.NodeDefinitionSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.model.User;
import org.openforis.collect.web.session.SessionState;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Schema;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelService {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private RecordSessionManager sessionManager;

    public List<SurveySummary> getSurveySummaries() {
        String lang = this.getActiveLanguageCode();
        User loggedUser = this.sessionManager.getLoggedUser();
        List summaries = this.surveyManager.getSurveySummaries(lang, loggedUser);
        return summaries;
    }

    public List<NodeDefinitionSummary> getRootEntitiesSummaries(String surveyName) {
        String lang = this.getActiveLanguageCode();
        ArrayList<NodeDefinitionSummary> result = new ArrayList<NodeDefinitionSummary>();
        CollectSurvey survey = this.surveyManager.get(surveyName);
        Schema schema = survey.getSchema();
        List rootEntityDefinitions = schema.getRootEntityDefinitions();
        for (EntityDefinition entityDefinition : rootEntityDefinitions) {
            Integer id = entityDefinition.getId();
            String name = entityDefinition.getName();
            String label = entityDefinition.getLabel(NodeLabel.Type.HEADING, lang);
            NodeDefinitionSummary summary = new NodeDefinitionSummary(id, name, label);
            result.add(summary);
        }
        return result;
    }

    public boolean isActiveSurveyRecordsLocked() {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        boolean result = survey != null && survey.isPublished() && this.surveyManager.isRecordValidationInProgress(survey.getId().intValue());
        return result;
    }

    protected String getActiveLanguageCode() {
        SessionState sessionState = this.sessionManager.getSessionState();
        Locale locale = sessionState.getLocale();
        String lang = locale != null ? locale.getLanguage() : "en";
        return lang;
    }

    protected RecordSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected SurveyManager getSurveyManager() {
        return this.surveyManager;
    }
}

