/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.dataexport.codelist.CodeListExportProcess;
import org.openforis.collect.metamodel.view.CodeListItemView;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Controllers;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.ModelVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api"})
@Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
public class CodeListController {
    private static final String CSV_EXTENSION = ".csv";
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CodeListManager codeListManager;

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}.csv"}, method={RequestMethod.GET})
    @ResponseBody
    public String exportCodeListWork(HttpServletResponse response, @PathVariable(value="surveyId") Integer surveyId, @PathVariable(value="codeListId") Integer codeListId) throws IOException {
        return this.exportCodeList(response, surveyId, codeListId);
    }

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}/validitems/count"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer countAvailableItems(@PathVariable int surveyId, @PathVariable int codeListId, @RequestBody SearchParameters params) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CodeList list = survey.getCodeListById(codeListId);
        ModelVersion version = params.versionId == null ? null : survey.getVersionById(params.versionId.intValue());
        List items = this.codeListManager.loadValidItems(list, version, params.ancestorCodes);
        return items.size();
    }

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}/validitems"}, method={RequestMethod.POST})
    @ResponseBody
    public List<CodeListItemView> loadAvailableItems(@PathVariable int surveyId, @PathVariable int codeListId, @RequestBody SearchParameters params) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CodeList list = survey.getCodeListById(codeListId);
        ModelVersion version = params.versionId == null ? null : survey.getVersionById(params.versionId.intValue());
        List items = this.codeListManager.loadValidItems(list, version, params.ancestorCodes);
        return this.toViews(items, params.language);
    }

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}/finditems"}, method={RequestMethod.POST})
    @ResponseBody
    public List<CodeListItemView> findAvailableItems(@PathVariable int surveyId, @PathVariable int codeListId, @RequestBody SearchParameters params) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CodeList list = survey.getCodeListById(codeListId);
        ModelVersion version = params.versionId == null ? null : survey.getVersionById(params.versionId.intValue());
        List items = this.codeListManager.findValidItems(list, version, params.language, params.ancestorCodes, params.searchString);
        return this.toViews(items, params.language);
    }

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}/item"}, method={RequestMethod.POST})
    @ResponseBody
    public CodeListItemView loadItem(@PathVariable int surveyId, @PathVariable int codeListId, @RequestBody SearchParameters params) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CodeList list = survey.getCodeListById(codeListId);
        ModelVersion version = params.versionId == null ? null : survey.getVersionById(params.versionId.intValue());
        CodeListItem item = this.codeListManager.loadItem(list, version, params.ancestorCodes, params.searchString);
        return item == null ? null : this.toView(item, params.language);
    }

    protected String exportCodeList(HttpServletResponse response, int surveyId, int codeListId) throws IOException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CodeList list = survey.getCodeListById(codeListId);
        String fileName = list.getName() + CSV_EXTENSION;
        Controllers.setOutputContent(response, fileName, "text/csv");
        ServletOutputStream out = response.getOutputStream();
        CodeListExportProcess process = new CodeListExportProcess(this.codeListManager);
        process.exportToCSV((OutputStream)out, survey, codeListId);
        return "ok";
    }

    private List<CodeListItemView> toViews(List<CodeListItem> items, String langCode) {
        ArrayList<CodeListItemView> views = new ArrayList<CodeListItemView>(items.size());
        for (CodeListItem item : items) {
            views.add(this.toView(item, langCode));
        }
        return views;
    }

    private CodeListItemView toView(CodeListItem item, String langCode) {
        CodeListItemView view = new CodeListItemView();
        view.setCode(item.getCode());
        view.setLabel(item.getLabel(langCode));
        view.setDescription(item.getDescription(langCode));
        view.setQualifiable(item.isQualifiable());
        return view;
    }

    public static class SearchParameters {
        private Integer versionId;
        private List<String> ancestorCodes;
        private String searchString;
        private String language;

        public Integer getVersionId() {
            return this.versionId;
        }

        public void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        public List<String> getAncestorCodes() {
            return this.ancestorCodes;
        }

        public void setAncestorCodes(List<String> ancestorCodes) {
            this.ancestorCodes = ancestorCodes;
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }
    }
}

