/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.Proxy;
import org.openforis.collect.concurrency.ApplicationLockingJob;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.datacleansing.DataQueryExectutorTask;
import org.openforis.collect.utils.Proxies;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.commons.web.HttpResponses;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/job"})
public class CollectJobController
extends BasicController {
    @Autowired
    private CollectJobManager jobManager;

    @RequestMapping(value={"application-job.json"}, method={RequestMethod.GET})
    @ResponseBody
    public JobView getApplicationJob(HttpServletResponse response) {
        ApplicationLockingJob job = this.jobManager.getApplicationJob();
        return this.createJobView(response, (Job)job);
    }

    @RequestMapping(value={"application-job.json"}, method={RequestMethod.DELETE})
    @ResponseBody
    public JobView abortApplicationJob(HttpServletResponse response) {
        ApplicationLockingJob job = this.jobManager.getApplicationJob();
        return this.abortJob(response, (Job)job);
    }

    @RequestMapping(value={"survey-job.json"}, method={RequestMethod.GET})
    @ResponseBody
    public JobView getSurveyJob(HttpServletResponse response, @RequestParam(value="surveyId") int surveyId) {
        SurveyLockingJob job = this.jobManager.getSurveyJob(surveyId);
        return this.createJobView(response, (Job)job);
    }

    @RequestMapping(value={"survey-job.json"}, method={RequestMethod.DELETE})
    @ResponseBody
    public JobView abortSurveyJob(HttpServletResponse response, @RequestParam(value="surveyId") int surveyId) {
        SurveyLockingJob job = this.jobManager.getSurveyJob(surveyId);
        return this.abortJob(response, (Job)job);
    }

    @RequestMapping(value={"{jobId}"}, method={RequestMethod.GET})
    @ResponseBody
    public JobView getJob(HttpServletResponse response, @PathVariable(value="jobId") String jobId) {
        Job job = this.jobManager.getJob(jobId);
        return this.createJobView(response, job);
    }

    @RequestMapping(value={"{jobId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public JobView abortJob(HttpServletResponse response, @PathVariable(value="jobId") String jobId) {
        Job job = this.jobManager.getJob(jobId);
        return this.abortJob(response, job);
    }

    private JobView abortJob(HttpServletResponse response, Job job) {
        if (job != null) {
            job.abort();
        }
        return this.createJobView(response, job);
    }

    private JobView createJobView(HttpServletResponse response, Job job) {
        if (job == null) {
            HttpResponses.setNoContentStatus((HttpServletResponse)response);
            return null;
        }
        return new JobView(job);
    }

    public static class WorkerView
    implements Proxy {
        private String id;
        private String name;
        private int progressPercent;
        private Worker.Status status;
        private String errorMessage;
        private List<DataQueryExectutorTask.DataQueryExecutorError> errors;
        private long elapsedTime;
        private Long remainingTime;
        private Integer remainingMinutes;
        private boolean ended;

        public WorkerView(Worker worker) {
            this.id = worker.getId().toString();
            this.name = worker.getName();
            this.progressPercent = worker.getProgressPercent();
            this.status = worker.getStatus();
            this.ended = worker.isEnded();
            this.errorMessage = worker.getErrorMessage();
            this.elapsedTime = this.calculateElapsedTime(worker);
            this.remainingTime = this.calculateRemainingTime();
            this.remainingMinutes = this.calculateRemainingMinutes();
        }

        private long calculateElapsedTime(Worker worker) {
            if (worker.isEnded()) {
                return worker.getEndTime() - worker.getStartTime();
            }
            return new Date().getTime() - worker.getStartTime();
        }

        public Long calculateRemainingTime() {
            if (this.progressPercent <= 0) {
                return null;
            }
            long estimatedTotalTime = 100L * this.elapsedTime / (long)this.progressPercent;
            return estimatedTotalTime - this.elapsedTime;
        }

        public Integer calculateRemainingMinutes() {
            if (this.remainingTime == null) {
                return null;
            }
            return Double.valueOf(Math.ceil((double)this.remainingTime.longValue() / 60000.0)).intValue();
        }

        public boolean isEnded() {
            return this.ended;
        }

        public boolean isCompleted() {
            return this.status == Worker.Status.COMPLETED;
        }

        public boolean isRunning() {
            return this.status == Worker.Status.RUNNING;
        }

        public boolean isFailed() {
            return this.status == Worker.Status.FAILED;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getProgressPercent() {
            return this.progressPercent;
        }

        public Worker.Status getStatus() {
            return this.status;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public List<DataQueryExectutorTask.DataQueryExecutorError> getErrors() {
            return this.errors;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public Long getRemainingTime() {
            return this.remainingTime;
        }

        public Integer getRemainingMinutes() {
            return this.remainingMinutes;
        }
    }

    public static class JobView
    extends WorkerView {
        private List<WorkerView> tasks;
        private Map<String, Object> extras = new HashMap<String, Object>();

        public JobView(Job job) {
            super((Worker)job);
            this.tasks = Proxies.fromList(job.getTasks(), WorkerView.class);
        }

        public void putExtra(String key, Object value) {
            this.extras.put(key, value);
        }

        public Map<String, Object> getExtras() {
            return this.extras;
        }

        public List<WorkerView> getTasks() {
            return this.tasks;
        }
    }
}

