/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.metamodel.proxy.IdentifiableSurveyObjectProxy;
import org.openforis.collect.metamodel.proxy.LanguageSpecificTextProxy;
import org.openforis.collect.utils.Dates;
import org.openforis.idm.metamodel.IdentifiableSurveyObject;
import org.openforis.idm.metamodel.ModelVersion;

public class ModelVersionProxy
extends IdentifiableSurveyObjectProxy {
    private transient ModelVersion version;

    public ModelVersionProxy(ModelVersion version) {
        super((IdentifiableSurveyObject)version);
        this.version = version;
    }

    static List<ModelVersionProxy> fromList(List<ModelVersion> list) {
        ArrayList<ModelVersionProxy> proxies = new ArrayList<ModelVersionProxy>();
        if (list != null) {
            for (ModelVersion v : list) {
                proxies.add(new ModelVersionProxy(v));
            }
        }
        return proxies;
    }

    @ExternalizedProperty
    public String getName() {
        return this.version.getName();
    }

    @ExternalizedProperty
    public List<LanguageSpecificTextProxy> getLabels() {
        return LanguageSpecificTextProxy.fromList(this.version.getLabels());
    }

    @ExternalizedProperty
    public List<LanguageSpecificTextProxy> getDescriptions() {
        return LanguageSpecificTextProxy.fromList(this.version.getDescriptions());
    }

    @ExternalizedProperty
    public String getDate() {
        return Dates.formatDate((Date)this.version.getDate());
    }
}

