/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational;

import java.util.List;
import org.openforis.collect.event.EventQueue;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.event.SurveyEvent;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.relational.CollectLocalRDBStorageManager;
import org.openforis.collect.relational.event.InitializeRDBEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CollectRDBMonitor {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private EventQueue eventQueue;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CollectLocalRDBStorageManager localRDBStorageManager;

    public void init() {
        if (this.eventQueue.isEnabled()) {
            this.runInTransaction(new Runnable(){

                @Override
                public void run() {
                    List surveys = CollectRDBMonitor.this.surveyManager.getAll();
                    for (CollectSurvey survey : surveys) {
                        for (RecordStep step : RecordStep.values()) {
                            if (!CollectRDBMonitor.this.rdbMissing(survey, step)) continue;
                            CollectRDBMonitor.this.eventQueue.publish((SurveyEvent)new InitializeRDBEvent(survey.getName(), step));
                        }
                    }
                }
            });
        }
    }

    private void runInTransaction(final Runnable task) {
        TransactionTemplate tmpl = new TransactionTemplate(this.transactionManager);
        tmpl.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                task.run();
            }
        });
    }

    private boolean rdbMissing(CollectSurvey survey, RecordStep step) {
        return !this.localRDBStorageManager.existsRDBFile(survey.getName(), step);
    }
}

