/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public abstract class SurveyObjectPopUpVM<T>
extends SurveyObjectBaseVM<T> {
    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        event.stopPropagation();
        if (!this.isCurrentFormValid()) {
            MessageUtil.showConfirm(new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    SurveyObjectPopUpVM.this.cancel();
                }
            }, "global.unapplied_changes_made", null, "global.unsaved_changes", null, "global.continue_and_loose_changes", "global.stay_on_this_page");
        } else {
            this.cancel();
        }
    }

    @Command
    public void apply(final @ContextParam(value=ContextType.VIEW) Component view, final @ContextParam(value=ContextType.BINDER) Binder binder) {
        this.dispatchApplyChangesCommand(binder);
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean ignoreUnsavedChanges) {
                if (ignoreUnsavedChanges) {
                    SurveyObjectPopUpVM.this.undoLastChanges(view);
                } else {
                    SurveyObjectPopUpVM.this.commitChanges(binder);
                }
                SurveyObjectPopUpVM.this.dispatchChangesAppliedCommand(ignoreUnsavedChanges);
            }
        });
    }

    @Command
    public void cancel() {
        this.undoLastChanges();
        this.dispatchChangesCancelledCommand();
    }

    protected abstract void dispatchChangesCancelledCommand();

    protected abstract void dispatchChangesAppliedCommand(boolean var1);
}

