/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.event;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Configuration;
import org.openforis.collect.utils.Files;
import org.openforis.rmb.MessageBroker;
import org.openforis.rmb.MessageQueue;
import org.openforis.rmb.metrics.MetricsMonitor;
import org.openforis.rmb.slf4j.Slf4jLoggingMonitor;
import org.openforis.rmb.spi.MessageSerializer;
import org.openforis.rmb.spring.SpringJdbcMessageBroker;
import org.openforis.rmb.xstream.XStreamMessageSerializer;

public class ConfiguredMessageBroker
implements MessageBroker {
    private static final Logger LOG = LogManager.getLogger(ConfiguredMessageBroker.class);
    private static final String TABLE_PREFIX = "ofc_";
    private final SpringJdbcMessageBroker messageBroker;
    private FileReporter fileReporter;

    public ConfiguredMessageBroker(DataSource dataSource, Configuration jooqConf) throws Exception {
        this.messageBroker = new SpringJdbcMessageBroker(dataSource);
        this.messageBroker.setMessageSerializer((MessageSerializer)new XStreamMessageSerializer());
        this.messageBroker.setTablePrefix(this.determineFullTablePrefix(jooqConf));
        this.initMonitors();
        this.messageBroker.afterPropertiesSet();
    }

    private String determineFullTablePrefix(Configuration jooqConf) {
        String fullPrefix = (jooqConf.settings().isRenderSchema() != false ? "collect." : "") + TABLE_PREFIX;
        return fullPrefix;
    }

    private void initMonitors() {
        ArrayList<Object> monitors = new ArrayList<Object>();
        monitors.add(new Slf4jLoggingMonitor());
        MetricsMonitor metricsMonitor = this.createMetricsMonitor();
        if (metricsMonitor != null) {
            monitors.add(metricsMonitor);
        }
        this.messageBroker.setMonitors(monitors);
    }

    private MetricsMonitor createMetricsMonitor() {
        MetricRegistry metrics = new MetricRegistry();
        try {
            this.fileReporter = new FileReporter(metrics);
            this.fileReporter.start(1L, TimeUnit.MINUTES);
            MetricsMonitor metricsMonitor = new MetricsMonitor(metrics);
            return metricsMonitor;
        }
        catch (IOException e) {
            LOG.warn("Metrics output file not found");
            return null;
        }
    }

    public <M> MessageQueue.Builder<M> queueBuilder(String queueId) {
        return this.messageBroker.queueBuilder(queueId);
    }

    public <M> MessageQueue.Builder<M> queueBuilder(String queueId, Class<M> messageType) {
        return this.messageBroker.queueBuilder(queueId, messageType);
    }

    public void start() {
        this.messageBroker.start();
    }

    public void stop() {
        this.messageBroker.stop();
        this.fileReporter.stop();
    }

    private static class FileReporter
    extends ScheduledReporter {
        private static final String METRICS_LOG_FILE_NAME = "metrics.log";
        private File outputFile;
        private MetricRegistry registry;

        protected FileReporter(MetricRegistry registry) throws IOException {
            super(registry, "file-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
            this.registry = registry;
            this.outputFile = this.getMetricsOutputFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            ScheduledReporter reporter = null;
            try {
                reporter = this.createInternalReporter();
                reporter.report(gauges, counters, histograms, meters, timers);
            }
            catch (IOException e) {
                LOG.warn("Failed to write to metrics log file: " + this.outputFile.getAbsolutePath(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)reporter);
            }
        }

        private File getMetricsOutputFile() throws IOException {
            File logsDir = this.determineLogsFolder();
            if (logsDir.exists()) {
                File file = new File(logsDir, METRICS_LOG_FILE_NAME);
                if (file.exists()) {
                    Files.eraseFileContent((File)file);
                } else {
                    file.createNewFile();
                }
                return file;
            }
            throw new IllegalStateException("Error generating metrics log file: missing logs folder");
        }

        private File determineLogsFolder() {
            String baseFolder = System.getProperty("catalina.base");
            if (baseFolder == null) {
                baseFolder = new File(".").getAbsoluteFile().getParentFile().getAbsolutePath();
            }
            return new File(baseFolder, "logs");
        }

        private ScheduledReporter createInternalReporter() throws FileNotFoundException {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
            ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(new PrintStream(fileOutputStream)).build();
            return reporter;
        }
    }
}

