/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.earth.app.server.AbstractPlacemarkDataController;
import org.openforis.collect.earth.app.server.PlacemarkUpdateRequest;
import org.openforis.collect.earth.app.service.EarthSurveyService;
import org.openforis.collect.io.metadata.collectearth.balloon.CollectEarthBalloonGenerator;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CollectEarthBalloonPreviewController
extends AbstractPlacemarkDataController {
    @Autowired
    private EarthSurveyService earthSurveyService;
    @Autowired
    @Qualifier(value="sessionManager")
    private SessionManager sessionManager;
    @Autowired
    private SurveyManager surveyManager;

    @RequestMapping(value={"/preview_placemark-info-expanded"}, method={RequestMethod.GET})
    protected void placemarkInfoExpanded(@RequestParam(value="id") String placemarkId, HttpServletResponse response) throws IOException {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        this.earthSurveyService.setCollectSurvey(survey);
        super.placemarkInfoExpanded(placemarkId, response);
    }

    @RequestMapping(value={"/preview_save-data-expanded"}, method={RequestMethod.POST})
    public void saveDataExpanded(PlacemarkUpdateRequest updateRequest, HttpServletResponse response) throws IOException {
        super.saveDataExpanded(updateRequest, response);
    }

    @RequestMapping(value={"/collectearthpreview.html"}, method={RequestMethod.GET})
    public void showCollectEarthBalloonPreview(HttpServletResponse response, @RequestParam(value="surveyId") Integer surveyId, @RequestParam(value="lang") String languageCode) throws IOException {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId.intValue());
        CollectEarthBalloonGenerator generator = new CollectEarthBalloonGenerator(survey, languageCode, true);
        String html = generator.generateHTML();
        html = html.replace("earth.js", "earth_new.js");
        this.writeHtmlToResponse(response, html);
    }

    private void writeHtmlToResponse(HttpServletResponse response, String html) throws IOException {
        PrintWriter writer = null;
        try {
            response.setContentType("text/html");
            writer = new PrintWriter((OutputStream)response.getOutputStream());
            writer.print(html);
            writer.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

