/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.io.File;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.FieldSymbol;
import org.openforis.collect.model.proxy.NodeUpdateRequestProxy;
import org.openforis.collect.remoting.service.FileWrapper;
import org.openforis.collect.remoting.service.NodeUpdateRequest;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.RangeAttributeDefinition;
import org.openforis.idm.metamodel.Unit;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.IntegerRange;
import org.openforis.idm.model.RealRange;
import org.openforis.idm.model.Value;

public abstract class BaseAttributeUpdateRequestProxy<T extends NodeUpdateRequest.BaseAttributeUpdateRequest<?>>
extends NodeUpdateRequestProxy<T> {
    private static final String QUALIFIER_SEPARATOR = ":";
    protected Object value;
    protected String remarks;
    protected FieldSymbol symbol;

    @Override
    public T toNodeUpdateRequest(CollectRecord record) {
        throw new UnsupportedOperationException();
    }

    public abstract T toAttributeUpdateRequest(CodeListManager var1, RecordSessionManager var2, CollectRecord var3);

    protected org.openforis.idm.model.File parseFileAttributeValue(RecordSessionManager sessionManager, CollectRecord record, Integer nodeId, Object value) {
        if (value == null) {
            sessionManager.prepareDeleteTempRecordFile(record, nodeId);
            return null;
        }
        if (value instanceof FileWrapper) {
            File tempFile = new File(((FileWrapper)value).getFilePath());
            sessionManager.prepareDeleteTempRecordFile(record, nodeId);
            sessionManager.indexTempRecordFile(tempFile, nodeId);
            return new org.openforis.idm.model.File(tempFile.getAbsolutePath(), Long.valueOf(tempFile.length()));
        }
        throw new IllegalArgumentException("Invalid value type: expected byte[]");
    }

    protected Value parseCompositeAttributeValue(CodeListManager codeListManager, Entity parentEntity, String attributeName, Object value) {
        EntityDefinition parentEntityDefn = (EntityDefinition)parentEntity.getDefinition();
        AttributeDefinition defn = (AttributeDefinition)parentEntityDefn.getChildDefinition(attributeName);
        if (defn instanceof CodeAttributeDefinition) {
            if (value instanceof String) {
                String stringVal = (String)value;
                Code result = this.parseCode(codeListManager, parentEntity, (CodeAttributeDefinition)defn, stringVal);
                return result;
            }
            throw new IllegalArgumentException("Invalid value type: expected String");
        }
        if (defn instanceof RangeAttributeDefinition) {
            if (value instanceof String) {
                String stringVal = (String)value;
                RangeAttributeDefinition rangeDef = (RangeAttributeDefinition)defn;
                NumericAttributeDefinition.Type type = rangeDef.getType();
                IntegerRange range = null;
                Unit unit = null;
                switch (type) {
                    case INTEGER: {
                        range = IntegerRange.parseIntegerRange((String)stringVal, unit);
                        break;
                    }
                    case REAL: {
                        range = RealRange.parseRealRange((String)stringVal, unit);
                    }
                }
                return range;
            }
            throw new IllegalArgumentException("Invalid value type: expected String");
        }
        throw new IllegalArgumentException("Invalid AttributeDefinition: expected CodeAttributeDefinition or RangeAttributeDefinition");
    }

    protected Code parseCode(CodeListManager codeListManager, Entity parent, CodeAttributeDefinition defn, String value) {
        Code code = this.parseCode(value);
        if (code == null) {
            return null;
        }
        String normalizedCode = this.findNormalizedCode(codeListManager, parent, defn, code.getCode());
        return new Code(normalizedCode, code.getQualifier());
    }

    protected String findNormalizedCode(CodeListManager codeListManager, Entity parent, CodeAttributeDefinition defn, String code) {
        CodeListItem codeListItem = codeListManager.findValidItem(parent, defn, code);
        if (codeListItem == null) {
            return code;
        }
        return codeListItem.getCode();
    }

    protected Code parseCode(String value) {
        Code code = null;
        String[] strings = value.split(QUALIFIER_SEPARATOR);
        String codeStr = null;
        String qualifier = null;
        switch (strings.length) {
            case 2: {
                qualifier = strings[1].trim();
            }
            case 1: {
                codeStr = strings[0].trim();
                break;
            }
        }
        if (codeStr != null) {
            code = new Code(codeStr, qualifier);
        }
        return code;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public FieldSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(FieldSymbol symbol) {
        this.symbol = symbol;
    }
}

