/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.Collect;
import org.openforis.collect.CollectInfo;
import org.openforis.collect.io.data.backup.BackupStorageManager;
import org.openforis.collect.manager.ConfigurationManager;
import org.openforis.collect.manager.RecordFileManager;
import org.openforis.collect.manager.RecordIndexException;
import org.openforis.collect.manager.RecordIndexManager;
import org.openforis.collect.model.Configuration;
import org.openforis.collect.model.proxy.ConfigurationProxy;
import org.openforis.commons.versioning.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ConfigurationService {
    protected static final Logger LOG = LogManager.getLogger(ConfigurationService.class);
    @Autowired
    private ConfigurationManager configurationManager;
    @Autowired
    private RecordFileManager recordFileManager;
    @Autowired
    private BackupStorageManager backupStorageManager;
    @Autowired
    @Qualifier(value="persistedRecordIndexManager")
    private RecordIndexManager recordIndexManager;
    private transient String defaultRecordFileUploadPath;
    private transient String defaultRecordIndexPath;
    private transient String defaultBackupStoragePath;

    public void init() {
        this.defaultRecordFileUploadPath = this.recordFileManager.getDefaultStorageDirectory().getAbsolutePath();
        this.defaultRecordIndexPath = this.recordIndexManager.getDefaultStorageDirectory().getAbsolutePath();
        this.defaultBackupStoragePath = this.backupStorageManager.getDefaultStorageDirectory().getAbsolutePath();
    }

    public ConfigurationProxy loadConfiguration() {
        return new ConfigurationProxy(this.configurationManager.getConfiguration(), this.defaultRecordFileUploadPath, this.defaultRecordIndexPath, this.defaultBackupStoragePath);
    }

    public void updateUploadPath(String uploadPath) {
        this.configurationManager.updateUploadPath(uploadPath);
        this.recordFileManager.init();
    }

    public void updateIndexPath(String indexPath) throws RecordIndexException {
        this.configurationManager.updateIndexPath(indexPath);
        boolean initialized = this.recordIndexManager.init();
        if (!initialized) {
            throw new RuntimeException("Error initializing index path");
        }
    }

    public void updateConfigurationItem(String configurationItemName, String value) {
        Configuration.ConfigurationItem item = Configuration.ConfigurationItem.valueOf((String)configurationItemName);
        this.configurationManager.updateConfigurationItem(item, value);
    }

    public CollectInfo loadRemoteCloneInfo() {
        String remoteCloneUrl = this.configurationManager.getConfiguration().get(Configuration.ConfigurationItem.REMOTE_CLONE_URL);
        String remoteInfoUrl = remoteCloneUrl + "/info.json";
        try {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            CloseableHttpClient httpClient = clientBuilder.build();
            HttpGet request = new HttpGet(remoteInfoUrl);
            request.setConfig(RequestConfig.custom().setConnectTimeout(20000).build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream is = entity.getContent();
                CollectInfo info = this.extractCollectInfo(is);
                return info;
            }
            LOG.error("Error getting remote Collect version information: Invalid response");
        }
        catch (Exception e) {
            LOG.error("Error getting remote Collect version information: " + e.getMessage());
        }
        return null;
    }

    public boolean isRemoteCloneValid() {
        CollectInfo remoteCloneInfo = this.loadRemoteCloneInfo();
        return remoteCloneInfo != null && Collect.VERSION.compareTo(new Version(remoteCloneInfo.getVersion())) >= 0;
    }

    private CollectInfo extractCollectInfo(InputStream is) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CollectInfo info = (CollectInfo)mapper.readValue(is, CollectInfo.class);
        return info;
    }
}

