/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.EventListenerToList;
import org.openforis.collect.event.EventProducer;
import org.openforis.collect.event.EventQueue;
import org.openforis.collect.event.RecordDeletedEvent;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.event.RecordTransaction;
import org.openforis.collect.io.data.BulkRecordMoveJob;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.manager.RecordFileManager;
import org.openforis.collect.manager.RecordIndexException;
import org.openforis.collect.manager.RecordIndexManager;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.RecordPromoteException;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SessionEventDispatcher;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.metamodel.proxy.CodeListItemProxy;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.FieldSymbol;
import org.openforis.collect.model.NodeChangeMap;
import org.openforis.collect.model.NodeChangeSet;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.RecordSummarySortField;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.model.proxy.NodeChangeSetProxy;
import org.openforis.collect.model.proxy.NodeUpdateRequestSetProxy;
import org.openforis.collect.model.proxy.RecordFilterProxy;
import org.openforis.collect.model.proxy.RecordProxy;
import org.openforis.collect.model.proxy.RecordSummaryProxy;
import org.openforis.collect.persistence.MultipleEditException;
import org.openforis.collect.persistence.RecordLockedException;
import org.openforis.collect.persistence.RecordPersistenceException;
import org.openforis.collect.persistence.RecordUnlockedException;
import org.openforis.collect.remoting.service.NodeUpdateRequest;
import org.openforis.collect.remoting.service.NodeUpdateRequestSet;
import org.openforis.collect.remoting.service.concurrency.proxy.SurveyLockingJobProxy;
import org.openforis.collect.remoting.service.recordindex.RecordIndexService;
import org.openforis.collect.web.session.SessionState;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.commons.collection.Predicate;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.SurveyContext;
import org.openforis.idm.model.Entity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.annotation.Transactional;

public class DataService {
    @Autowired
    private SurveyContext<?> surveyContext;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private transient RecordManager recordManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private transient CodeListManager codeListManager;
    @Autowired
    private transient RecordFileManager fileManager;
    @Autowired
    private transient UserGroupManager userGroupManager;
    @Autowired
    private transient RecordIndexService recordIndexService;
    @Autowired
    private transient CollectJobManager collectJobManager;
    @Autowired
    private transient SessionEventDispatcher sessionEventDispatcher;
    @Autowired
    private transient EventQueue eventQueue;
    @Autowired
    private AppWS appWS;
    private boolean hasActiveSurveyIndexedNodes;
    private ProxyContext proxyContext;

    @Secured(value={"ROLE_USER"})
    public RecordProxy loadRecord(int id, Integer stepNumber) {
        SessionState sessionState = this.getSessionState();
        CollectSurvey survey = sessionState.getActiveSurvey();
        CollectRecord.Step step = stepNumber == null ? null : CollectRecord.Step.valueOf((int)stepNumber);
        CollectRecord record = step == null ? this.recordManager.load(survey, id) : this.recordManager.load(survey, id, step);
        this.sessionManager.setActiveRecord(record);
        return this.toProxy(record);
    }

    @Secured(value={"ROLE_ENTRY_LIMITED"})
    public RecordProxy checkoutRecord(int id, Integer stepNumber, boolean forceUnlock) throws RecordPersistenceException, RecordIndexException {
        SessionState sessionState = this.sessionManager.getSessionState();
        if (sessionState.isActiveRecordBeingEdited()) {
            throw new MultipleEditException();
        }
        CollectSurvey survey = sessionState.getActiveSurvey();
        User user = sessionState.getUser();
        CollectRecord.Step step = stepNumber == null ? null : CollectRecord.Step.valueOf((int)stepNumber);
        CollectRecord record = step == null ? this.recordManager.checkout(survey, user, id, sessionState.getSessionId(), forceUnlock) : this.recordManager.checkout(survey, user, id, step, sessionState.getSessionId(), forceUnlock);
        this.sessionManager.setActiveRecord(record);
        this.prepareRecordIndexing();
        this.appWS.sendMessage(new AppWS.RecordLockedMessage(id, user.getUsername()));
        return this.toProxy(record);
    }

    protected void prepareRecordIndexing() throws RecordIndexException {
        CollectRecord record = this.getActiveRecord();
        Entity rootEntity = record.getRootEntity();
        EntityDefinition rootEntityDefn = (EntityDefinition)rootEntity.getDefinition();
        this.hasActiveSurveyIndexedNodes = this.recordIndexService.hasIndexableNodes(rootEntityDefn);
        this.recordIndexService.cleanTemporaryIndex();
    }

    @Secured(value={"ROLE_USER"})
    public Map<String, Object> loadRecordSummaries(RecordFilterProxy filterProxy, List<RecordSummarySortField> sortFields, String localeStr) {
        CollectSurvey survey;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (filterProxy.getSurveyId() > 0) {
            survey = this.surveyManager.getById(filterProxy.getSurveyId());
        } else {
            SessionState sessionState = this.sessionManager.getSessionState();
            survey = sessionState.getActiveSurvey();
        }
        RecordFilter filter = filterProxy.toFilter(survey);
        List summaries = this.recordManager.loadSummaries(filter, sortFields);
        Locale locale = LocaleUtils.toLocale((String)localeStr);
        ProxyContext proxyContext = new ProxyContext(locale, this.messageSource, this.surveyContext);
        List<RecordSummaryProxy> proxies = RecordSummaryProxy.fromList(summaries, proxyContext);
        result.put("records", proxies);
        int count = this.recordManager.countRecords(filter);
        result.put("count", count);
        return result;
    }

    @Secured(value={"ROLE_USER"})
    public Map<String, Object> loadRecordSummaries(String rootEntityName, int offset, int maxNumberOfRows, List<RecordSummarySortField> sortFields, String[] keyValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectSurvey activeSurvey = sessionState.getActiveSurvey();
        Schema schema = activeSurvey.getSchema();
        EntityDefinition rootEntityDefinition = schema.getRootEntityDefinition(rootEntityName);
        RecordFilter filter = new RecordFilter(activeSurvey, Integer.valueOf(rootEntityDefinition.getId()));
        filter.setKeyValues(keyValues);
        filter.setOffset(Integer.valueOf(offset));
        filter.setMaxNumberOfRecords(Integer.valueOf(maxNumberOfRows));
        List summaries = this.recordManager.loadSummaries(filter, sortFields);
        List<RecordSummaryProxy> proxies = RecordSummaryProxy.fromList(summaries, this.getProxyContext());
        result.put("records", proxies);
        int count = this.recordManager.countRecords(filter);
        result.put("count", count);
        return result;
    }

    @Secured(value={"ROLE_ENTRY"})
    public RecordProxy createRecord(String rootEntityName, String versionName, CollectRecord.Step recordStep) throws RecordPersistenceException, RecordIndexException {
        SessionState sessionState = this.sessionManager.getSessionState();
        if (sessionState.isActiveRecordBeingEdited()) {
            throw new MultipleEditException();
        }
        CollectSurvey activeSurvey = sessionState.getActiveSurvey();
        User user = sessionState.getUser();
        CollectRecord record = this.recordManager.instantiateRecord(activeSurvey, rootEntityName, user, versionName, recordStep);
        NodeChangeSet changeSet = this.recordManager.initializeRecord(record);
        EventProducer.EventProducerContext context = this.createEventProducerContext();
        new EventProducer(context, (EventListener)this.sessionManager).produceFor(changeSet);
        this.sessionManager.setActiveRecord(record);
        this.prepareRecordIndexing();
        RecordProxy recordProxy = new RecordProxy(record, this.getProxyContext(), true);
        return recordProxy;
    }

    @Transactional
    @Secured(value={"ROLE_ENTRY"})
    public void deleteRecord(int id) throws RecordPersistenceException {
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectSurvey survey = sessionState.getActiveSurvey();
        String userName = sessionState.getUser().getUsername();
        CollectRecord record = this.recordManager.load(survey, id);
        if (record.getStep() != CollectRecord.Step.ENTRY) {
            throw new IllegalStateException("Cannot delete a record not in ENTRY phase");
        }
        this.fileManager.deleteAllFiles(record);
        this.recordManager.delete(id);
        this.publishRecordDeletedEvent(record, record.getStep().toRecordStep(), userName);
    }

    @Transactional
    @Secured(value={"ROLE_ENTRY_LIMITED"})
    public void saveActiveRecord() throws RecordPersistenceException, RecordIndexException {
        this.sessionManager.checkIsActiveRecordLocked();
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectRecord record = sessionState.getActiveRecord();
        User user = sessionState.getUser();
        record.setModifiedDate(new Date());
        record.setModifiedBy(user);
        record.setOwner(user);
        String sessionId = sessionState.getSessionId();
        this.recordManager.save(record, sessionId);
        if (this.sessionManager.commitRecordFileChanges(record)) {
            this.recordManager.save(record, sessionId);
        }
        if (this.isCurrentRecordIndexable()) {
            this.recordIndexService.permanentlyIndex(record);
        }
        this.sessionEventDispatcher.recordSaved(record);
    }

    @Transactional
    @Secured(value={"ROLE_ENTRY_LIMITED"})
    public NodeChangeSetProxy updateActiveRecord(NodeUpdateRequestSetProxy requestSet) throws RecordPersistenceException, RecordIndexException {
        this.sessionManager.checkIsActiveRecordLocked();
        CollectRecord activeRecord = this.getActiveRecord();
        NodeUpdateRequestSet reqSet = requestSet.toNodeUpdateRequestSet(this.codeListManager, this.sessionManager, activeRecord);
        NodeChangeSet changeSet = this.updateRecord(activeRecord, reqSet);
        if (!changeSet.isEmpty() && this.isCurrentRecordIndexable()) {
            this.recordIndexService.temporaryIndex(activeRecord);
        }
        EventProducer.EventProducerContext context = this.createEventProducerContext();
        new EventProducer(context, (EventListener)this.sessionManager).produceFor(changeSet);
        NodeChangeSetProxy result = new NodeChangeSetProxy(activeRecord, changeSet, this.getProxyContext());
        if (requestSet.isAutoSave()) {
            try {
                this.saveActiveRecord();
                result.setRecordSaved(true);
            }
            catch (Exception e) {
                result.setRecordSaved(false);
            }
        }
        return result;
    }

    private NodeChangeSet updateRecord(CollectRecord record, NodeUpdateRequestSet nodeUpdateRequestSet) throws RecordPersistenceException, RecordIndexException {
        List<NodeUpdateRequest> opts = nodeUpdateRequestSet.getRequests();
        NodeChangeMap result = new NodeChangeMap();
        for (NodeUpdateRequest req : opts) {
            NodeChangeSet partialChangeSet = this.updateRecord(record, req);
            result.addMergeChanges(partialChangeSet);
        }
        return result;
    }

    protected NodeChangeSet updateRecord(CollectRecord record, NodeUpdateRequest req) throws RecordPersistenceException {
        if (req instanceof NodeUpdateRequest.ErrorConfirmRequest) {
            return this.recordManager.confirmError(((NodeUpdateRequest.ErrorConfirmRequest)req).getAttribute());
        }
        if (req instanceof NodeUpdateRequest.MissingValueApproveRequest) {
            NodeUpdateRequest.MissingValueApproveRequest r = (NodeUpdateRequest.MissingValueApproveRequest)req;
            return this.recordManager.approveMissingValue(r.getParentEntity(), r.getNodeName());
        }
        if (req instanceof NodeUpdateRequest.RemarksUpdateRequest) {
            NodeUpdateRequest.RemarksUpdateRequest r = (NodeUpdateRequest.RemarksUpdateRequest)req;
            return this.recordManager.updateRemarks(r.getField(), r.getRemarks());
        }
        if (req instanceof NodeUpdateRequest.AttributeAddRequest) {
            NodeUpdateRequest.AttributeAddRequest r = (NodeUpdateRequest.AttributeAddRequest)req;
            return this.recordManager.addAttribute(r.getParentEntity(), r.getNodeName(), r.getValue(), r.getSymbol(), r.getRemarks());
        }
        if (req instanceof NodeUpdateRequest.EntityAddRequest) {
            NodeUpdateRequest.EntityAddRequest r = (NodeUpdateRequest.EntityAddRequest)req;
            return this.recordManager.addEntity(r.getParentEntity(), r.getNodeName());
        }
        if (req instanceof NodeUpdateRequest.AttributeUpdateRequest) {
            NodeUpdateRequest.AttributeUpdateRequest r = (NodeUpdateRequest.AttributeUpdateRequest)req;
            Object value = r.getValue();
            FieldSymbol symbol = r.getSymbol();
            if (value == null && symbol == null || value != null) {
                return this.recordManager.updateAttribute(r.getAttribute(), value);
            }
            if (symbol != null) {
                return this.recordManager.updateAttribute(r.getAttribute(), symbol);
            }
            throw new IllegalArgumentException("Cannot specify both value and symbol");
        }
        if (req instanceof NodeUpdateRequest.FieldUpdateRequest) {
            return this.processUpdateFieldRequest((NodeUpdateRequest.FieldUpdateRequest)req);
        }
        if (req instanceof NodeUpdateRequest.DefaultValueApplyRequest) {
            return this.recordManager.applyDefaultValue(((NodeUpdateRequest.DefaultValueApplyRequest)req).getAttribute());
        }
        if (req instanceof NodeUpdateRequest.NodeDeleteRequest) {
            return this.recordManager.deleteNode(((NodeUpdateRequest.NodeDeleteRequest)req).getNode());
        }
        throw new IllegalArgumentException("NodeChange not supported: " + req.getClass().getSimpleName());
    }

    protected <T> NodeChangeSet processUpdateFieldRequest(NodeUpdateRequest.FieldUpdateRequest<T> r) {
        if (StringUtils.equals((CharSequence)r.getField().getRemarks(), (CharSequence)r.getRemarks())) {
            if (r.getValue() == null && r.getSymbol() == null) {
                return this.recordManager.updateField(r.getField(), null);
            }
            if (r.getValue() != null) {
                return this.recordManager.updateField(r.getField(), r.getValue());
            }
            return this.recordManager.updateField(r.getField(), r.getSymbol());
        }
        return this.recordManager.updateRemarks(r.getField(), r.getRemarks());
    }

    @Transactional
    @Secured(value={"ROLE_ENTRY_LIMITED"})
    public void promoteToCleansing() throws RecordPersistenceException, RecordPromoteException {
        this.promote(CollectRecord.Step.CLEANSING);
    }

    @Transactional
    @Secured(value={"ROLE_CLEANSING"})
    public void promoteToAnalysis() throws RecordPersistenceException, RecordPromoteException {
        this.promote(CollectRecord.Step.ANALYSIS);
    }

    protected void promote(CollectRecord.Step to) throws RecordPersistenceException, RecordPromoteException {
        this.sessionManager.checkIsActiveRecordLocked();
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectRecord record = sessionState.getActiveRecord();
        String userName = sessionState.getUser().getUsername();
        CollectRecord.Step currentStep = record.getStep();
        CollectRecord.Step exptectedStep = to.getPrevious();
        if (exptectedStep == currentStep) {
            User user = sessionState.getUser();
            this.sessionEventDispatcher.recordSaved(record);
            this.recordManager.promote(record, user);
            this.publishRecordPromotedEvents(record, userName);
            this.recordManager.releaseLock(record.getId());
            this.sessionManager.clearActiveRecord();
            if (this.isCurrentRecordIndexable()) {
                this.recordIndexService.permanentlyIndex(record);
            }
        } else {
            throw new IllegalStateException("The active record cannot be submitted: it is not in the exptected phase: " + exptectedStep);
        }
    }

    protected boolean isRecordIndexEnabled() {
        return this.recordIndexService.isInited();
    }

    protected boolean isCurrentRecordIndexable() {
        return this.isRecordIndexEnabled() && this.hasActiveSurveyIndexedNodes;
    }

    @Transactional
    @Secured(value={"ROLE_ANALYSIS"})
    public void demoteToCleansing() throws RecordPersistenceException {
        this.demote(CollectRecord.Step.CLEANSING);
    }

    @Transactional
    @Secured(value={"ROLE_CLEANSING"})
    public void demoteToEntry() throws RecordPersistenceException {
        this.demote(CollectRecord.Step.ENTRY);
    }

    protected void demote(CollectRecord.Step toStep) throws RecordPersistenceException {
        this.sessionManager.checkIsActiveRecordLocked();
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectRecord record = sessionState.getActiveRecord();
        CollectRecord.Step fromStep = record.getStep();
        CollectRecord.Step exptectedFromStep = toStep.getNext();
        if (exptectedFromStep != fromStep) {
            throw new IllegalStateException("The active record cannot be demoted: it is not in the exptected phase: " + exptectedFromStep);
        }
        CollectSurvey survey = sessionState.getActiveSurvey();
        String userName = sessionState.getUser().getUsername();
        User user = sessionState.getUser();
        Integer recordId = record.getId();
        this.publishRecordDeletedEvent(record, fromStep.toRecordStep(), userName);
        this.recordManager.demote(survey, recordId.intValue(), record.getStep(), user);
        this.recordManager.releaseLock(recordId);
        this.sessionManager.clearActiveRecord();
    }

    @Secured(value={"ROLE_ENTRY_LIMITED"})
    public void clearActiveRecord() {
        try {
            this.sessionManager.releaseRecord();
        }
        catch (RecordUnlockedException recordUnlockedException) {
            // empty catch block
        }
        if (this.isCurrentRecordIndexable()) {
            try {
                this.recordIndexService.cleanTemporaryIndex();
            }
            catch (RecordIndexException recordIndexException) {
                // empty catch block
            }
        }
    }

    @Secured(value={"ROLE_ENTRY_LIMITED"})
    public void moveNode(int nodeId, int index) {
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectRecord record = sessionState.getActiveRecord();
        this.recordManager.moveNode(record, nodeId, index);
    }

    @Secured(value={"ROLE_USER"})
    public List<CodeListItemProxy> getCodeListItems(int parentEntityId, String attrName, String[] codes) {
        CollectRecord record = this.getActiveRecord();
        Entity parent = (Entity)record.getNodeByInternalId(parentEntityId);
        CodeAttributeDefinition def = (CodeAttributeDefinition)((EntityDefinition)parent.getDefinition()).getChildDefinition(attrName);
        List items = this.codeListManager.loadValidItems(parent, def);
        ArrayList<CodeListItem> filteredItems = new ArrayList<CodeListItem>();
        if (codes != null && codes.length > 0) {
            for (CodeListItem item : items) {
                for (String code : codes) {
                    if (!item.getCode().equals(code)) continue;
                    filteredItems.add(item);
                }
            }
        }
        List<CodeListItemProxy> result = CodeListItemProxy.fromList(filteredItems);
        return result;
    }

    @Secured(value={"ROLE_USER"})
    public List<CodeListItemProxy> findAssignableCodeListItems(int parentEntityId, String attrName) {
        String listHierarchicalLevelName;
        CollectRecord record = this.getActiveRecord();
        CollectSurvey survey = (CollectSurvey)record.getSurvey();
        User user = this.sessionManager.getLoggedUser();
        UserInGroup userInGroup = this.userGroupManager.findUserInGroupOrDescendants(survey.getUserGroupId().intValue(), user.getId().intValue());
        if (userInGroup == null) {
            throw new IllegalStateException(String.format("User %s not allowed to access survey %s", user.getUsername(), survey.getName()));
        }
        Entity parent = (Entity)record.getNodeByInternalId(parentEntityId);
        CodeAttributeDefinition def = (CodeAttributeDefinition)((EntityDefinition)parent.getDefinition()).getChildDefinition(attrName);
        List items = this.codeListManager.loadValidItems(parent, def);
        ArrayList<CodeListItem> filteredItems = new ArrayList<CodeListItem>(items);
        final UserGroup group = (UserGroup)this.userGroupManager.loadById((Object)userInGroup.getGroupId());
        String qualifierName = group.getQualifier1Name();
        String string = listHierarchicalLevelName = def.getList().isHierarchical() ? def.getHierarchicalLevel() : def.getListName();
        if (qualifierName != null && qualifierName.equals(listHierarchicalLevelName)) {
            CollectionUtils.filter(filteredItems, (Predicate)new Predicate<CodeListItem>(){

                public boolean evaluate(CodeListItem item) {
                    return item.getCode().equals(group.getQualifier1Value());
                }
            });
        }
        List<CodeListItemProxy> result = CodeListItemProxy.fromList(filteredItems);
        List selectedCodes = parent.getChildren(attrName);
        CodeListItemProxy.setSelectedItems(result, selectedCodes);
        return result;
    }

    @Secured(value={"ROLE_USER"})
    public List<CodeListItemProxy> findAssignableCodeListItems(int parentEntityId, String attributeName, String[] codes) {
        CollectRecord record = this.getActiveRecord();
        Entity parent = (Entity)record.getNodeByInternalId(parentEntityId);
        CodeAttributeDefinition def = (CodeAttributeDefinition)((EntityDefinition)parent.getDefinition()).getChildDefinition(attributeName);
        List items = this.codeListManager.findValidItems(parent, def, codes);
        ArrayList<CodeListItemProxy> result = new ArrayList<CodeListItemProxy>();
        for (CodeListItem item : items) {
            result.add(new CodeListItemProxy(item));
        }
        return result;
    }

    @Secured(value={"ROLE_USER"})
    public List<String> searchAutoCompleteValues(int attributeDefnId, int fieldIndex, String searchText) throws Exception {
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectSurvey survey = sessionState.getActiveSurvey();
        int maxResults = 10;
        List<String> result = this.recordIndexService.search(RecordIndexManager.SearchType.STARTS_WITH, (Survey)survey, attributeDefnId, fieldIndex, searchText, maxResults);
        return result;
    }

    @Secured(value={"ROLE_CLEANSING"})
    public void assignOwner(int recordId, Integer ownerId) throws RecordLockedException, MultipleEditException {
        SessionState sessionState = this.sessionManager.getSessionState();
        this.recordManager.assignOwner(sessionState.getActiveSurvey(), recordId, ownerId, sessionState.getUser(), sessionState.getSessionId());
    }

    @Secured(value={"ROLE_CLEANSING"})
    public SurveyLockingJobProxy moveRecords(String rootEntity, int fromStepNumber, final boolean promote) {
        BulkRecordMoveJob job = (BulkRecordMoveJob)this.collectJobManager.createJob(BulkRecordMoveJob.class);
        SessionState sessionState = this.getSessionState();
        final String userName = sessionState.getUser().getUsername();
        job.setSurvey(sessionState.getActiveSurvey());
        job.setRootEntity(rootEntity);
        job.setPromote(promote);
        final CollectRecord.Step fromStep = CollectRecord.Step.valueOf((int)fromStepNumber);
        job.setFromStep(fromStep);
        job.setUser(sessionState.getUser());
        job.setRecordMovedCallback(new BulkRecordMoveJob.Callback(){

            public void recordMoved(CollectRecord record) {
                if (promote) {
                    DataService.this.publishRecordPromotedEvents(record, userName);
                } else {
                    DataService.this.publishRecordDeletedEvent(record, fromStep.toRecordStep(), userName);
                }
            }
        });
        this.collectJobManager.startSurveyJob((SurveyLockingJob)job);
        return new SurveyLockingJobProxy((SurveyLockingJob)job);
    }

    private void publishRecordPromotedEvents(CollectRecord record, String userName) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        EventProducer.EventProducerContext context = this.createEventProducerContext(userName);
        ArrayList events = new ArrayList();
        new EventProducer(context, (EventListener)new EventListenerToList(events)).produceFor(record);
        this.eventQueue.publish(new RecordTransaction(record.getSurvey().getName(), record.getId().intValue(), record.getStep().toRecordStep(), events));
    }

    private void publishRecordDeletedEvent(CollectRecord record, RecordStep recordStep, String userName) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        List<RecordDeletedEvent> events = Arrays.asList(new RecordDeletedEvent(record.getSurvey().getName(), record.getId().intValue(), new Date(), userName));
        String surveyName = record.getSurvey().getName();
        this.eventQueue.publish(new RecordTransaction(surveyName, record.getId().intValue(), recordStep, events));
    }

    protected CollectRecord getActiveRecord() {
        SessionState sessionState = this.getSessionState();
        CollectRecord activeRecord = sessionState.getActiveRecord();
        return activeRecord;
    }

    protected Locale getCurrentLocale() {
        SessionState sessionState = this.getSessionState();
        return sessionState.getLocale();
    }

    private EventProducer.EventProducerContext createEventProducerContext() {
        return this.createEventProducerContext(this.getSessionState().getUser().getUsername());
    }

    private EventProducer.EventProducerContext createEventProducerContext(String userName) {
        return new EventProducer.EventProducerContext(this.messageSource, this.getCurrentLocale(), userName);
    }

    private RecordProxy toProxy(CollectRecord record) {
        return new RecordProxy(record, this.getProxyContext());
    }

    private ProxyContext getProxyContext() {
        if (this.proxyContext == null || !this.proxyContext.getLocale().equals(this.getCurrentLocale())) {
            this.proxyContext = new ProxyContext(this.getCurrentLocale(), this.messageSource, this.surveyContext);
        }
        return this.proxyContext;
    }

    protected SessionState getSessionState() {
        return this.getSessionManager().getSessionState();
    }

    protected RecordSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected RecordManager getRecordManager() {
        return this.recordManager;
    }
}

