/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.openforis.collect.command.AddAttributeCommand;
import org.openforis.collect.command.AddEntityCommand;
import org.openforis.collect.command.Command;
import org.openforis.collect.command.CommandDispatcher;
import org.openforis.collect.command.CreateRecordCommand;
import org.openforis.collect.command.CreateRecordPreviewCommand;
import org.openforis.collect.command.DeleteAttributeCommand;
import org.openforis.collect.command.DeleteEntityCommand;
import org.openforis.collect.command.DeleteRecordCommand;
import org.openforis.collect.command.RecordCommand;
import org.openforis.collect.command.UpdateAttributeCommand;
import org.openforis.collect.command.UpdateBooleanAttributeCommand;
import org.openforis.collect.command.UpdateCodeAttributeCommand;
import org.openforis.collect.command.UpdateCoordinateAttributeCommand;
import org.openforis.collect.command.UpdateDateAttributeCommand;
import org.openforis.collect.command.UpdateFileAttributeCommand;
import org.openforis.collect.command.UpdateIntegerAttributeCommand;
import org.openforis.collect.command.UpdateIntegerRangeAttributeCommand;
import org.openforis.collect.command.UpdateMultipleAttributeCommand;
import org.openforis.collect.command.UpdateRealAttributeCommand;
import org.openforis.collect.command.UpdateRealRangeAttributeCommand;
import org.openforis.collect.command.UpdateTaxonAttributeCommand;
import org.openforis.collect.command.UpdateTextAttributeCommand;
import org.openforis.collect.command.UpdateTimeAttributeCommand;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.manager.RecordFileManager;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SessionRecordFileManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Files;
import org.openforis.collect.web.manager.SessionRecordProvider;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.web.Response;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.model.BooleanValue;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.Date;
import org.openforis.idm.model.FileAttribute;
import org.openforis.idm.model.IntegerRange;
import org.openforis.idm.model.IntegerValue;
import org.openforis.idm.model.RealRange;
import org.openforis.idm.model.RealValue;
import org.openforis.idm.model.TaxonOccurrence;
import org.openforis.idm.model.TextValue;
import org.openforis.idm.model.Time;
import org.openforis.idm.model.Value;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/command"})
@Transactional
public class CommandController {
    @Autowired
    private transient SurveyManager surveyManager;
    @Autowired
    private transient RecordFileManager recordFileManager;
    @Autowired
    private SessionRecordProvider sessionRecordProvider;
    @Autowired
    private SessionRecordFileManager sessionRecordFileManager;
    @Autowired
    private transient CommandDispatcher commandDispatcher;
    @Autowired
    private transient SessionManager sessionManager;
    @Autowired
    private transient AppWS appWS;

    @RequestMapping(value={"record"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Response createRecord(@RequestBody CreateRecordCommand command) {
        return this.submitCommand((RecordCommand)command);
    }

    @RequestMapping(value={"record_preview"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public List<RecordEventView> createRecordPreview(@RequestBody CreateRecordPreviewCommand command) {
        return this.submitCommandSync((RecordCommand)command);
    }

    @RequestMapping(value={"record"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    @ResponseBody
    public Response deleteRecord(@RequestBody DeleteRecordCommand command) {
        return this.submitCommand((RecordCommand)command);
    }

    @RequestMapping(value={"record/attribute/new"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Response addAttribute(@RequestBody AddAttributeCommand command) {
        return this.submitCommand((RecordCommand)command);
    }

    @RequestMapping(value={"record/attributes"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Response addOrUpdateAttributes(@RequestBody UpdateAttributesCommandWrapper commandsWrapper) {
        List<UpdateAttributeCommandWrapper> commands = commandsWrapper.getCommands();
        if (!commands.isEmpty()) {
            CollectSurvey survey = this.getSurvey((RecordCommand)commands.get(0));
            commands.forEach(c -> {
                UpdateAttributeCommand command = c.toCommand(survey);
                this.submitCommand((RecordCommand)command);
            });
        }
        return new Response();
    }

    @RequestMapping(value={"record/attribute"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object updateAttribute(@RequestBody UpdateAttributeCommandWrapper commandWrapper) {
        CollectSurvey survey = this.getSurvey((RecordCommand)commandWrapper);
        UpdateAttributeCommand command = commandWrapper.toCommand(survey);
        return this.submitCommand((RecordCommand)command);
    }

    @RequestMapping(value={"record/attribute/file"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public Response updateAttributeFile(@RequestParam(value="command") String commandWrapperJsonString, @RequestParam(value="file") MultipartFile multipartFile) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        UpdateAttributeCommandWrapper commandWrapper = (UpdateAttributeCommandWrapper)((Object)objectMapper.readValue(commandWrapperJsonString, UpdateAttributeCommandWrapper.class));
        CollectSurvey survey = this.getSurvey((RecordCommand)commandWrapper);
        UpdateAttributeCommand command = commandWrapper.toCommand(survey);
        FileAttributeDefinition attrDef = (FileAttributeDefinition)survey.getSchema().getDefinitionById(command.getNodeDefId());
        if (multipartFile.getSize() <= (long)attrDef.getMaxSize().intValue()) {
            org.openforis.idm.model.File value;
            CollectRecord record = this.provideRecord((RecordCommand)command);
            FileAttribute fileAttr = (FileAttribute)record.findNodeByPath(command.getNodePath());
            if (record.isPreview()) {
                File tempFile = this.sessionRecordFileManager.saveToTempFile(multipartFile.getInputStream(), multipartFile.getOriginalFilename(), record, fileAttr.getInternalId().intValue());
                value = new org.openforis.idm.model.File(tempFile.getName(), Long.valueOf(multipartFile.getSize()));
            } else {
                File tempFile = Files.writeToTempFile((InputStream)multipartFile.getInputStream(), (String)multipartFile.getOriginalFilename(), (String)"ofc_data_entry_file");
                value = this.recordFileManager.moveFileIntoRepository(fileAttr, tempFile, multipartFile.getOriginalFilename(), false);
            }
            command.setValue((Value)value);
            return this.submitCommand((RecordCommand)command);
        }
        throw new IllegalArgumentException(String.format("File size (%d) exceeds expected maximum size: %d", multipartFile.getSize(), attrDef.getMaxSize()));
    }

    @RequestMapping(value={"record/attribute/file/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object deleteAttributeFile(@RequestBody DeleteAttributeCommand command) throws Exception {
        CollectRecord record = this.provideRecord((RecordCommand)command);
        FileAttribute fileAttr = (FileAttribute)record.findNodeByPath(command.getNodePath());
        if (record.isPreview()) {
            this.sessionRecordFileManager.deleteTempFile(record, fileAttr.getInternalId().intValue());
        } else {
            this.recordFileManager.deleteRepositoryFile(fileAttr);
        }
        UpdateFileAttributeCommand updateAttributeCommand = new UpdateFileAttributeCommand();
        PropertyUtils.copyProperties((Object)updateAttributeCommand, (Object)command);
        updateAttributeCommand.setValue(null);
        return this.submitCommand((RecordCommand)updateAttributeCommand);
    }

    @RequestMapping(value={"record/attribute/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object deleteAttribute(@RequestBody DeleteAttributeCommand command) {
        return this.submitCommand((RecordCommand)command);
    }

    @RequestMapping(value={"record/entity"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object addEntity(@RequestBody AddEntityCommand command) {
        return this.submitCommand((RecordCommand)command);
    }

    @RequestMapping(value={"record/entity/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public Object deleteEntity(@RequestBody DeleteEntityCommand command) {
        return this.submitCommand((RecordCommand)command);
    }

    private Response submitCommand(RecordCommand command) {
        command.setUsername(this.sessionManager.getLoggedUsername());
        final CollectRecord record = this.provideRecord(command);
        this.commandDispatcher.submit((Command)command, new EventListener(){

            public void onEvent(RecordEvent event) {
                CommandController.this.appWS.sendMessage(new AppWS.RecordEventMessage(new RecordEventView(event, record)));
            }
        });
        return new Response();
    }

    private List<RecordEventView> submitCommandSync(RecordCommand command) {
        command.setUsername(this.sessionManager.getLoggedUsername());
        List events = this.commandDispatcher.submitSync((Command)command);
        CollectRecord record = this.provideRecord(command);
        ArrayList<RecordEventView> result = new ArrayList<RecordEventView>(events.size());
        for (RecordEvent event : events) {
            result.add(new RecordEventView(event, record));
        }
        return result;
    }

    private CollectSurvey getSurvey(RecordCommand command) {
        return this.surveyManager.getOrLoadSurveyById(command.getSurveyId());
    }

    private CollectRecord provideRecord(RecordCommand command) {
        CollectSurvey survey = this.getSurvey(command);
        return this.sessionRecordProvider.provide(survey, command.getRecordId(), CollectRecord.Step.fromRecordStep((RecordStep)command.getRecordStep()));
    }

    static class UpdateAttributeCommandWrapper
    extends UpdateAttributeCommand<Value> {
        private static final long serialVersionUID = 1L;
        AttributeType attributeType;
        NumericAttributeDefinition.Type numericType;
        Map<String, Object> valueByField;
        List<Map<String, Object>> valuesByField;

        UpdateAttributeCommandWrapper() {
        }

        <V extends Value> V extractValue(CollectSurvey survey) {
            return ValueExtractor.extractValue(this.attributeType, this.numericType, this.valueByField);
        }

        private <V extends Value> List<V> extractValues(CollectSurvey survey) {
            if (this.valuesByField == null) {
                return Collections.emptyList();
            }
            ArrayList values = new ArrayList(this.valuesByField.size());
            for (Map<String, Object> valueByField : this.valuesByField) {
                values.add(ValueExtractor.extractValue(this.attributeType, this.numericType, valueByField));
            }
            return values;
        }

        public <V extends Value> UpdateAttributeCommand<V> toCommand(CollectSurvey survey) {
            Class<UpdateAttributeCommand<?>> commandType = this.toCommandType();
            try {
                UpdateAttributeCommand<?> c = commandType.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties((Object)((Object)this), c, (String[])new String[]{"attributeType", "value", "values"});
                c.setValue(this.extractValue(survey));
                if (c instanceof UpdateMultipleAttributeCommand) {
                    ((UpdateMultipleAttributeCommand)c).setValues(this.extractValues(survey));
                }
                return c;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class<? extends UpdateAttributeCommand<?>> toCommandType() {
            switch (this.attributeType) {
                case BOOLEAN: {
                    return UpdateBooleanAttributeCommand.class;
                }
                case CODE: {
                    return UpdateCodeAttributeCommand.class;
                }
                case COORDINATE: {
                    return UpdateCoordinateAttributeCommand.class;
                }
                case DATE: {
                    return UpdateDateAttributeCommand.class;
                }
                case FILE: {
                    return UpdateFileAttributeCommand.class;
                }
                case NUMBER: {
                    return this.numericType == NumericAttributeDefinition.Type.INTEGER ? UpdateIntegerAttributeCommand.class : UpdateRealAttributeCommand.class;
                }
                case RANGE: {
                    return this.numericType == NumericAttributeDefinition.Type.INTEGER ? UpdateIntegerRangeAttributeCommand.class : UpdateRealRangeAttributeCommand.class;
                }
                case TAXON: {
                    return UpdateTaxonAttributeCommand.class;
                }
                case TEXT: {
                    return UpdateTextAttributeCommand.class;
                }
                case TIME: {
                    return UpdateTimeAttributeCommand.class;
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public void setAttributeType(AttributeType attributeType) {
            this.attributeType = attributeType;
        }

        public NumericAttributeDefinition.Type getNumericType() {
            return this.numericType;
        }

        public void setNumericType(NumericAttributeDefinition.Type numericType) {
            this.numericType = numericType;
        }

        public Map<String, Object> getValueByField() {
            return this.valueByField;
        }

        public void setValueByField(Map<String, Object> valueByField) {
            this.valueByField = valueByField;
        }

        public List<Map<String, Object>> getValuesByField() {
            return this.valuesByField;
        }

        public void setValuesByField(List<Map<String, Object>> valuesByField) {
            this.valuesByField = valuesByField;
        }
    }

    static class ValueExtractor {
        ValueExtractor() {
        }

        static <V extends Value> V extractValue(AttributeType attributeType, NumericAttributeDefinition.Type numericType, Map<String, Object> valueByField) {
            if (valueByField == null) {
                return null;
            }
            switch (attributeType) {
                case BOOLEAN: {
                    return (V)new BooleanValue((Boolean)valueByField.get("value"));
                }
                case CODE: {
                    return (V)new Code((String)valueByField.get("code"), (String)valueByField.get("qualifier"));
                }
                case COORDINATE: {
                    Number xValue = (Number)valueByField.get("x");
                    Number yValue = (Number)valueByField.get("y");
                    Number altitudeValue = (Number)valueByField.get("altitude");
                    Number accuracyValue = (Number)valueByField.get("accuracy");
                    String srsId = (String)valueByField.get("srs");
                    Double x = xValue == null ? null : Double.valueOf(xValue.doubleValue());
                    Double y = yValue == null ? null : Double.valueOf(yValue.doubleValue());
                    Double altitude = altitudeValue == null ? null : Double.valueOf(altitudeValue.doubleValue());
                    Double accuracy = accuracyValue == null ? null : Double.valueOf(accuracyValue.doubleValue());
                    return (V)new Coordinate(x, y, srsId, altitude, accuracy);
                }
                case DATE: {
                    return (V)new Date((Integer)valueByField.get("year"), (Integer)valueByField.get("month"), (Integer)valueByField.get("day"));
                }
                case FILE: {
                    return (V)new org.openforis.idm.model.File((String)valueByField.get("file_name"), (Long)valueByField.get("file_size"));
                }
                case NUMBER: {
                    Integer unitId = (Integer)valueByField.get("unit");
                    Number number = (Number)valueByField.get("value");
                    return (V)(numericType == NumericAttributeDefinition.Type.INTEGER ? new IntegerValue(number == null ? null : Integer.valueOf(number.intValue()), unitId) : new RealValue(number == null ? null : Double.valueOf(number.doubleValue()), unitId));
                }
                case RANGE: {
                    Integer unitId = (Integer)valueByField.get("unit");
                    Number from = (Number)valueByField.get("from");
                    Number to = (Number)valueByField.get("to");
                    return (V)(numericType == NumericAttributeDefinition.Type.INTEGER ? new IntegerRange(from == null ? null : Integer.valueOf(from.intValue()), to == null ? null : Integer.valueOf(to.intValue()), unitId) : new RealRange(from == null ? null : Double.valueOf(from.doubleValue()), to == null ? null : Double.valueOf(to.doubleValue()), unitId));
                }
                case TAXON: {
                    String code = (String)valueByField.get("code");
                    String scientificName = (String)valueByField.get("scientific_name");
                    String vernacularName = (String)valueByField.get("vernacular_name");
                    String languageCode = (String)valueByField.get("language_code");
                    String languageVariety = (String)valueByField.get("language_variety");
                    String familyCode = (String)valueByField.get("family_code");
                    String familyScientificName = (String)valueByField.get("family_scientific_name");
                    TaxonOccurrence taxonOccurrence = new TaxonOccurrence(code, scientificName, vernacularName, languageCode, languageVariety);
                    taxonOccurrence.setFamilyCode(familyCode);
                    taxonOccurrence.setFamilyScientificName(familyScientificName);
                    return (V)taxonOccurrence;
                }
                case TEXT: {
                    return (V)new TextValue((String)valueByField.get("value"));
                }
                case TIME: {
                    Integer hour = (Integer)valueByField.get("hour");
                    Integer minute = (Integer)valueByField.get("minute");
                    return (V)new Time(hour, minute);
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)attributeType));
        }
    }

    static class UpdateAttributesCommandWrapper {
        List<UpdateAttributeCommandWrapper> commands = new ArrayList<UpdateAttributeCommandWrapper>();

        UpdateAttributesCommandWrapper() {
        }

        public List<UpdateAttributeCommandWrapper> getCommands() {
            return this.commands;
        }

        public void setCommands(List<UpdateAttributeCommandWrapper> commands) {
            this.commands = commands;
        }
    }

    static class RecordEventView {
        private RecordEvent event;
        private int recordErrorsInvalidValues;
        private int recordErrorsMissingValues;
        private int recordWarnings;
        private int recordWarningsMissingValues;

        public RecordEventView(RecordEvent event, CollectRecord record) {
            this.event = event;
            this.recordErrorsInvalidValues = record.getErrors();
            this.recordErrorsMissingValues = record.getMissingErrors();
            this.recordWarnings = record.getWarnings();
            this.recordWarningsMissingValues = record.getMissingWarnings();
        }

        public String getEventType() {
            return this.event.getClass().getSimpleName();
        }

        public RecordEvent getEvent() {
            return this.event;
        }

        public Integer getRecordErrorsInvalidValues() {
            return this.recordErrorsInvalidValues;
        }

        public Integer getRecordErrorsMissingValues() {
            return this.recordErrorsMissingValues;
        }

        public Integer getRecordWarnings() {
            return this.recordWarnings;
        }

        public Integer getRecordWarningsMissingValues() {
            return this.recordWarningsMissingValues;
        }
    }
}

