/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.util.HashMap;
import java.util.Map;
import org.openforis.collect.manager.DatabaseVersionManager;
import org.openforis.collect.manager.DatabaseVersionNotCompatibleException;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.proxy.SurveyProxy;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.collect.model.proxy.UserProxy;
import org.openforis.collect.persistence.RecordUnlockedException;
import org.openforis.collect.web.session.SessionState;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionService {
    @Autowired
    protected RecordSessionManager sessionManager;
    @Autowired
    protected SurveyManager surveyManager;
    @Autowired
    protected DatabaseVersionManager databaseVersionManager;

    public void keepAlive(Boolean editing) throws RecordUnlockedException {
        this.sessionManager.keepSessionAlive();
        if (editing.booleanValue()) {
            this.sessionManager.checkIsActiveRecordLocked();
        }
    }

    public Map<String, Object> initSession(String locale) throws DatabaseVersionNotCompatibleException {
        this.databaseVersionManager.checkIsVersionCompatible();
        this.sessionManager.setLocale(locale);
        SessionState sessionState = this.sessionManager.getSessionState();
        User user = sessionState.getUser();
        UserProxy userProxy = new UserProxy(user);
        String sessionId = sessionState.getSessionId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("user", userProxy);
        result.put("sessionId", sessionId);
        return result;
    }

    public SurveyProxy setActiveSurvey(String name) {
        CollectSurvey survey = this.surveyManager.get(name);
        return this.setActiveSurvey(survey, false);
    }

    public SurveyProxy setActiveSurvey(int surveyId) {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        return this.setActiveSurvey(survey, false);
    }

    public SurveyProxy setActivePreviewSurvey(int surveyId) {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        return this.setActiveSurvey(survey, true);
    }

    public SurveyProxy setDesignerSurveyAsActive(int surveyId, boolean work) {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        if (survey == null) {
            survey = work ? this.surveyManager.loadSurvey(surveyId) : this.surveyManager.getById(surveyId);
        }
        if (survey == null) {
            throw new IllegalArgumentException("Survey not found");
        }
        return this.setActiveSurvey(survey, work);
    }

    protected SurveyProxy setActiveSurvey(CollectSurvey survey, boolean work) {
        SessionState sessionState = this.sessionManager.getSessionState();
        sessionState.setActiveSurvey(survey);
        sessionState.setActiveSurveyWork(work);
        SurveyProxy proxy = new SurveyProxy(survey);
        return proxy;
    }

    public void logout() {
        this.sessionManager.invalidateSession();
    }
}

