/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency.proxy;

import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.concurrency.Job;

public class JobProxy
implements Proxy {
    protected transient Job job;

    public JobProxy(Job job) {
        this.job = job;
    }

    protected Job getJob() {
        return this.job;
    }

    @ExternalizedProperty
    public String getId() {
        return this.job.getId().toString();
    }

    @ExternalizedProperty
    public Status getStatus() {
        return Status.valueOf(this.job.getStatus().name());
    }

    @ExternalizedProperty
    public boolean isPending() {
        return this.job.isPending();
    }

    @ExternalizedProperty
    public boolean isRunning() {
        return this.job.isRunning();
    }

    @ExternalizedProperty
    public boolean isFailed() {
        return this.job.isFailed();
    }

    @ExternalizedProperty
    public boolean isAborted() {
        return this.job.isAborted();
    }

    @ExternalizedProperty
    public boolean isCompleted() {
        return this.job.isCompleted();
    }

    @ExternalizedProperty
    public int getProgressPercent() {
        return this.job.getProgressPercent();
    }

    @ExternalizedProperty
    public String getErrorMessage() {
        return this.job.getErrorMessage();
    }

    @ExternalizedProperty
    public String[] getErrorMessageArgs() {
        return this.job.getErrorMessageArgs();
    }

    @ExternalizedProperty
    public String getName() {
        return this.job.getName();
    }

    public static enum Status {
        PENDING,
        RUNNING,
        COMPLETED,
        FAILED,
        ABORTED;

    }
}

