/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.config;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.Environment;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
extends AbstractWebSocketMessageBrokerConfigurer {
    private static Logger LOG = LogManager.getLogger(WebSocketConfig.class);
    private static final String ENDPOINT = "/ws";
    private static final String ALLOWED_ORIGINS = "*";
    private static final String SOCK_JS_VERSION = "1.5.0";
    private static final String SOCK_JS_CLIENT_LIBRARY_URL = "../assets/js/sockjs/1.5.0/sockjs.js";

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        super.configureMessageBroker(registry);
        registry.setPreservePublishOrder(true);
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        RequestUpgradeStrategy requestUpgradeStrategy = this.createRequestUpgradeStrategy();
        if (requestUpgradeStrategy == null) {
            LOG.info("no upgrade strategy in use");
            registry.addEndpoint(new String[]{ENDPOINT}).setAllowedOrigins(new String[]{ALLOWED_ORIGINS}).withSockJS().setClientLibraryUrl(SOCK_JS_CLIENT_LIBRARY_URL);
        } else {
            LOG.info("using " + requestUpgradeStrategy.getClass().getSimpleName());
            registry.addEndpoint(new String[]{ENDPOINT}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler(requestUpgradeStrategy)).setAllowedOrigins(new String[]{ALLOWED_ORIGINS}).withSockJS().setClientLibraryUrl(SOCK_JS_CLIENT_LIBRARY_URL);
        }
    }

    private RequestUpgradeStrategy createRequestUpgradeStrategy() {
        if (Environment.isServerJetty()) {
            LOG.info("running in Jetty application server");
            return new JettyRequestUpgradeStrategy();
        }
        if (Environment.isServerTomcat()) {
            LOG.info("running in Tomcat application server");
            return new TomcatRequestUpgradeStrategy();
        }
        return null;
    }
}

